/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jrobin.core.RrdException;
import org.jrobin.core.timespec.TimeParser;
import org.jrobin.core.timespec.TimeSpec;
import org.opennms.core.utils.StreamUtils;
import org.opennms.web.servlet.MissingParameterException;
import org.opennms.web.svclayer.RrdGraphService;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class RrdGraphController
extends AbstractController {
    private RrdGraphService m_rrdGraphService;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        InputStream tempIn;
        String[] requiredParameters;
        for (String requiredParameter : requiredParameters = new String[]{"resourceId", "start", "end"}) {
            if (request.getParameter(requiredParameter) != null) continue;
            throw new MissingParameterException(requiredParameter, requiredParameters);
        }
        String resourceId = request.getParameter("resourceId");
        long[] times = this.parseTimes(request);
        long startTime = times[0];
        long endTime = times[1];
        if ("true".equals(request.getParameter("adhoc"))) {
            String[] adhocRequiredParameters;
            for (String requiredParameter : adhocRequiredParameters = new String[]{"title", "ds", "agfunction", "color", "dstitle", "style"}) {
                if (request.getParameter(requiredParameter) != null) continue;
                throw new MissingParameterException(requiredParameter, adhocRequiredParameters);
            }
            String title = request.getParameter("title");
            String[] dataSources = request.getParameterValues("ds");
            String[] aggregateFunctions = request.getParameterValues("agfunction");
            String[] colors = request.getParameterValues("color");
            String[] dataSourceTitles = request.getParameterValues("dstitle");
            String[] styles = request.getParameterValues("style");
            tempIn = this.m_rrdGraphService.getAdhocGraph(resourceId, title, dataSources, aggregateFunctions, colors, dataSourceTitles, styles, startTime, endTime);
        } else {
            String report = request.getParameter("report");
            if (report == null) {
                throw new MissingParameterException("report");
            }
            String width = request.getParameter("width");
            String height = request.getParameter("height");
            tempIn = this.m_rrdGraphService.getPrefabGraph(resourceId, report, startTime, endTime, width != null && !width.isEmpty() ? Integer.valueOf(width) : null, height != null && !height.isEmpty() ? Integer.valueOf(height) : null);
        }
        response.setContentType("image/png");
        StreamUtils.streamToStream((InputStream)tempIn, (OutputStream)response.getOutputStream());
        tempIn.close();
        return null;
    }

    public long[] parseTimes(HttpServletRequest request) {
        String startTime = request.getParameter("start");
        String endTime = request.getParameter("end");
        if (startTime == null || "".equals(startTime)) {
            startTime = "now - 1day";
        }
        if (endTime == null || "".equals(endTime)) {
            endTime = "now";
        }
        boolean startIsInteger = false;
        boolean endIsInteger = false;
        long start = 0L;
        long end = 0L;
        try {
            start = Long.valueOf(startTime);
            startIsInteger = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            end = Long.valueOf(endTime);
            endIsInteger = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (endIsInteger && startIsInteger) {
            return new long[]{start, end};
        }
        if (startIsInteger) {
            startTime = "" + start / 1000L;
        }
        if (endIsInteger) {
            endTime = "" + end / 1000L;
        }
        TimeParser startParser = new TimeParser(startTime);
        TimeParser endParser = new TimeParser(endTime);
        try {
            TimeSpec specStart = startParser.parse();
            TimeSpec specEnd = endParser.parse();
            long[] results = TimeSpec.getTimestamps((TimeSpec)specStart, (TimeSpec)specEnd);
            results[0] = results[0] * 1000L;
            results[1] = results[1] * 1000L;
            return results;
        }
        catch (RrdException e) {
            throw new IllegalArgumentException("Could not parse start '" + startTime + "' and end '" + endTime + "' as valid time specifications", e);
        }
    }

    public RrdGraphService getRrdGraphService() {
        return this.m_rrdGraphService;
    }

    public void setRrdGraphService(RrdGraphService rrdGraphService) {
        this.m_rrdGraphService = rrdGraphService;
    }
}

