/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.provision.persist.DefaultForeignSourceService;
import org.opennms.netmgt.provision.persist.FilesystemForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceService;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;

public class DefaultForeignSourceServiceTest {
    private FilesystemForeignSourceRepository m_deployed;
    private FilesystemForeignSourceRepository m_pending;
    private ForeignSourceService m_service;

    @Before
    public void setUp() {
        FileUtils.deleteQuietly((File)new File("target/foreign-sources"));
        FileUtils.deleteQuietly((File)new File("target/imports"));
        this.m_deployed = new FilesystemForeignSourceRepository();
        this.m_deployed.setForeignSourcePath("target/foreign-sources/deployed");
        this.m_deployed.setRequisitionPath("target/imports/deployed");
        this.m_pending = new FilesystemForeignSourceRepository();
        this.m_pending.setForeignSourcePath("target/foreign-sources");
        this.m_pending.setRequisitionPath("target/imports");
        this.m_service = new DefaultForeignSourceService();
        this.m_service.setDeployedForeignSourceRepository((ForeignSourceRepository)this.m_deployed);
        this.m_service.setPendingForeignSourceRepository((ForeignSourceRepository)this.m_pending);
    }

    @Test
    public void integrationTest() throws Exception {
        Assert.assertTrue((boolean)this.m_deployed.getForeignSources().isEmpty());
        Assert.assertTrue((boolean)this.m_pending.getForeignSources().isEmpty());
        Assert.assertEquals((long)0L, (long)this.m_service.getAllForeignSources().size());
        ForeignSource fs = this.m_service.getForeignSource("test");
        Assert.assertTrue((boolean)fs.isDefault());
        fs.setDetectors(new ArrayList());
        this.m_service.saveForeignSource("test", fs);
        fs = this.m_service.getForeignSource("test");
        Assert.assertFalse((boolean)fs.isDefault());
        this.m_service.saveForeignSource("default", fs);
        fs = this.m_service.getForeignSource("monkey");
        Assert.assertTrue((boolean)fs.isDefault());
    }
}

