/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2007-2014 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2014 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.dashboard.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;

/**
 * <p>SimplePager class.</p>
 *
 * @author <a href="mailto:brozow@opennms.org">Mathew Brozowski</a>
 * @author <a href="mailto:dj@opennms.org">DJ Gregor</a>
 * @author <a href="mailto:brozow@opennms.org">Mathew Brozowski</a>
 * @author <a href="mailto:dj@opennms.org">DJ Gregor</a>
 * @version $Id: $
 * @since 1.8.1
 */
public class SimplePager extends Composite {
    private SimplePageable m_pageable;
    private org.gwtbootstrap3.client.ui.Pager m_pager = new org.gwtbootstrap3.client.ui.Pager();
    
    /**
     * <p>Constructor for SimplePager.</p>
     *
     * @param pageable a {@link org.opennms.dashboard.client.SimplePageable} object.
     */
    public SimplePager(SimplePageable pageable) {
        m_pageable = pageable;
        
        m_pager.addPreviousClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                m_pageable.adjustPage(-1);
            }
        });

        m_pager.addNextClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                m_pageable.adjustPage(1);
            }
        });

        initWidget(m_pager);
    }

}
