/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.users.parsers;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.opennms.web.admin.users.parsers.NotificationInfo;

public class User
implements Cloneable {
    public static final String USER_ID_PROPERTY = "userId";
    private String m_userId = "";
    private String m_fullName = "";
    private String m_userComments = "";
    private String m_password = "";
    private NotificationInfo m_notifInfo;
    private PropertyChangeSupport m_propChange = new PropertyChangeSupport(this);

    public User() {
        this.m_notifInfo = new NotificationInfo();
    }

    public Object clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        User newUser = new User();
        newUser.setUserId(this.m_userId);
        newUser.setFullName(this.m_fullName);
        newUser.setUserComments(this.m_userComments);
        newUser.setEncryptedPassword(this.m_password);
        newUser.setNotificationInfo((NotificationInfo)this.m_notifInfo.clone());
        return newUser;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propChange.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propChange.removePropertyChangeListener(listener);
    }

    public NotificationInfo getNotificationInfo() {
        return this.m_notifInfo;
    }

    public void setNotificationInfo(NotificationInfo someInfo) {
        this.m_notifInfo = someInfo;
    }

    public void setUserId(String aUserId) {
        String old = this.m_userId;
        this.m_userId = aUserId;
        this.m_propChange.firePropertyChange(USER_ID_PROPERTY, old, this.m_userId);
    }

    public String getUserId() {
        return this.m_userId;
    }

    public void setFullName(String aFullName) {
        this.m_fullName = aFullName;
    }

    public String getFullName() {
        return this.m_fullName;
    }

    public void setUserComments(String someUserComments) {
        this.m_userComments = someUserComments;
    }

    public String getUserComments() {
        return this.m_userComments;
    }

    public void setEncryptedPassword(String aPassword) {
        this.m_password = aPassword;
    }

    public void setUnencryptedPassword(String aPassword) throws IllegalStateException {
        this.m_password = User.encryptPassword(aPassword);
    }

    public static String encryptPassword(String aPassword) throws IllegalStateException {
        String encryptedPassword = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            encryptedPassword = User.hexToString(digest.digest(aPassword.getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.toString());
        }
        return encryptedPassword;
    }

    private static String hexToString(byte[] data) {
        char[] hexadecimals = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (data.length % 2 != 0) {
            return null;
        }
        char[] buffer = new char[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            int low = data[i] & 0xF;
            int high = (data[i] & 0xF0) >> 4;
            buffer[i * 2] = hexadecimals[high];
            buffer[i * 2 + 1] = hexadecimals[low];
        }
        return new String(buffer);
    }

    public boolean comparePasswords(String aPassword) {
        return this.m_password.equals(User.encryptPassword(aPassword));
    }

    public String getPassword() {
        return this.m_password;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("user id           = " + this.m_userId + "\n");
        buffer.append("full name         = " + this.m_fullName + "\n");
        buffer.append("user comments     = " + this.m_userComments + "\n");
        buffer.append("password          = " + this.m_password + "\n");
        buffer.append(this.m_notifInfo.toString());
        return buffer.toString();
    }
}

