/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.users;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.netmgt.config.UserFactory;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.users.User;

public class SaveUserServlet
extends HttpServlet {
    private static final long serialVersionUID = -2138716651602916013L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession user = request.getSession(false);
        if (user != null) {
            User newUser = (User)user.getAttribute("user.modifyUser.jsp");
            if (newUser.isReadOnly() && !request.isUserInRole("ROLE_ADMIN")) {
                throw new ServletException("Error: user " + newUser.getUserId() + " is read-only!");
            }
            try {
                UserManager userFactory = UserFactory.getInstance();
                userFactory.saveUser(newUser.getUserId(), newUser);
            }
            catch (Throwable e) {
                throw new ServletException("Error saving user " + newUser.getUserId(), e);
            }
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/userGroupView/users/list.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }
}

