/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.notification;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.filter.Filter;
import org.opennms.web.notification.AcknowledgeType;
import org.opennms.web.notification.Notification;
import org.opennms.web.notification.SortStyle;
import org.opennms.web.notification.filter.NodeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoticeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NoticeFactory.class);

    private NoticeFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNoticeCount(AcknowledgeType ackType, Filter[] filters) throws SQLException {
        if (ackType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int noticeCount = 0;
        DBUtils d = new DBUtils(NoticeFactory.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            StringBuffer select = new StringBuffer("SELECT COUNT(NOTIFYID) AS NOTICECOUNT FROM NOTIFICATIONS WHERE");
            select.append(ackType.getAcknowledgeTypeClause());
            for (Filter filter : filters) {
                select.append(" AND");
                select.append(filter.getParamSql());
            }
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            int parameterIndex = 1;
            for (Filter filter : filters) {
                parameterIndex += filter.bindParam(stmt, parameterIndex);
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                noticeCount = rs.getInt("NOTICECOUNT");
            }
        }
        finally {
            d.cleanUp();
        }
        return noticeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Notification getNotice(int noticeId, ServletContext servletContext) throws SQLException {
        Notification notice = null;
        DBUtils d = new DBUtils(NoticeFactory.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM NOTIFICATION WHERE NOTIFYID=?");
            d.watch((Object)stmt);
            stmt.setInt(1, noticeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            Notification[] notices = NoticeFactory.rs2Notices(rs, servletContext);
            if (notices.length > 0) {
                notice = notices[0];
            }
        }
        finally {
            d.cleanUp();
        }
        return notice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canDisplayEvent(int eventId) {
        boolean display = false;
        DBUtils d = new DBUtils(NoticeFactory.class);
        try {
            Connection connection = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)connection);
            PreparedStatement statement = connection.prepareStatement("SELECT eventDisplay FROM events WHERE eventid=?");
            d.watch((Object)statement);
            statement.setInt(1, eventId);
            ResultSet results = statement.executeQuery();
            d.watch((Object)results);
            results.next();
            String status = results.getString(1);
            if (status.equals("Y")) {
                display = true;
            }
        }
        catch (SQLException e) {
            LOG.error("Error getting event display status: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            d.cleanUp();
        }
        return display;
    }

    public static Notification[] getNotices(ServletContext servletContext) throws SQLException {
        return NoticeFactory.getNotices(SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, servletContext);
    }

    public static Notification[] getNotices(AcknowledgeType ackType, ServletContext servletContext) throws SQLException {
        return NoticeFactory.getNotices(SortStyle.ID, ackType, servletContext);
    }

    public static Notification[] getNotices(SortStyle sortStyle, ServletContext servletContext) throws SQLException {
        return NoticeFactory.getNotices(sortStyle, AcknowledgeType.UNACKNOWLEDGED, servletContext);
    }

    public static Notification[] getNotices(SortStyle sortStyle, boolean includeAcknowledged, ServletContext servletContext) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return NoticeFactory.getNotices(sortStyle, ackType, servletContext);
    }

    public static Notification[] getNotices(SortStyle sortStyle, AcknowledgeType ackType, ServletContext servletContext) throws SQLException {
        return NoticeFactory.getNotices(sortStyle, ackType, new Filter[0], servletContext);
    }

    public static Notification[] getNotices(SortStyle sortStyle, AcknowledgeType ackType, Filter[] filters, ServletContext servletContext) throws SQLException {
        return NoticeFactory.getNotices(sortStyle, ackType, filters, -1, -1, servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Notification[] getNotices(SortStyle sortStyle, AcknowledgeType ackType, Filter[] filters, int limit, int offset, ServletContext servletContext) throws SQLException {
        if (sortStyle == null || ackType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        boolean useLimits = false;
        if (limit > 0 && offset > -1) {
            useLimits = true;
        }
        Notification[] notices = null;
        DBUtils d = new DBUtils(NoticeFactory.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            StringBuffer select = new StringBuffer("SELECT * FROM NOTIFICATIONS WHERE");
            select.append(ackType.getAcknowledgeTypeClause());
            for (Filter filter : filters) {
                select.append(" AND");
                select.append(filter.getParamSql());
            }
            select.append(sortStyle.getOrderByClause());
            if (useLimits) {
                select.append(" LIMIT ?");
                select.append(" OFFSET ?");
            }
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            int parameterIndex = 1;
            for (Filter filter : filters) {
                parameterIndex += filter.bindParam(stmt, parameterIndex);
            }
            if (useLimits) {
                stmt.setInt(parameterIndex++, limit);
                stmt.setInt(parameterIndex, offset);
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            notices = NoticeFactory.rs2Notices(rs, servletContext);
        }
        finally {
            d.cleanUp();
        }
        return notices;
    }

    public static Notification[] getNoticesForNode(int nodeId, ServletContext servletContext) throws SQLException {
        return NoticeFactory.getNoticesForNode(nodeId, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, servletContext);
    }

    public static Notification[] getNoticesForNode(int nodeId, boolean includeAcknowledged, ServletContext servletContext) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return NoticeFactory.getNoticesForNode(nodeId, SortStyle.ID, ackType, servletContext);
    }

    public static Notification[] getNoticesForNode(int nodeId, SortStyle sortStyle, AcknowledgeType ackType, ServletContext servletContext) throws SQLException {
        if (sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId)};
        return NoticeFactory.getNotices(sortStyle, ackType, filters, servletContext);
    }

    public static Notification[] getNoticesForInterface(int nodeId, String ipAddress, ServletContext servletContext) throws SQLException {
        return NoticeFactory.getNoticesForInterface(nodeId, ipAddress, false, servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Notification[] getNoticesForInterface(int nodeId, String ipAddress, boolean includeAcknowledged, ServletContext servletContext) throws SQLException {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Notification[] notices = null;
        DBUtils d = new DBUtils(NoticeFactory.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            StringBuffer select = new StringBuffer("SELECT * FROM NOTIFICATIONS WHERE NODEID=? AND INTERFACEID=?");
            if (!includeAcknowledged) {
                select.append(" AND RESPONDTIME IS NULL");
            }
            select.append(" ORDER BY NOTIFYID DESC");
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            stmt.setString(2, ipAddress);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            notices = NoticeFactory.rs2Notices(rs, servletContext);
        }
        finally {
            d.cleanUp();
        }
        return notices;
    }

    public static Notification[] getNoticesForInterface(String ipAddress, ServletContext servletContext) throws SQLException {
        return NoticeFactory.getNoticesForInterface(ipAddress, false, servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Notification[] getNoticesForInterface(String ipAddress, boolean includeAcknowledged, ServletContext servletContext) throws SQLException {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Notification[] notices = null;
        DBUtils d = new DBUtils(NoticeFactory.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            StringBuffer select = new StringBuffer("SELECT * FROM NOTIFICATIONS WHERE INTERFACEID=?");
            if (!includeAcknowledged) {
                select.append(" AND RESPONDTIME IS NULL");
            }
            select.append(" ORDER BY NOTIFYID DESC");
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            stmt.setString(1, ipAddress);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            notices = NoticeFactory.rs2Notices(rs, servletContext);
        }
        finally {
            d.cleanUp();
        }
        return notices;
    }

    public static Notification[] getNoticesForService(int nodeId, String ipAddress, int serviceId, ServletContext servletContext) throws SQLException {
        return NoticeFactory.getNoticesForService(nodeId, ipAddress, serviceId, false, servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Notification[] getNoticesForService(int nodeId, String ipAddress, int serviceId, boolean includeAcknowledged, ServletContext servletContext) throws SQLException {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Notification[] notices = null;
        DBUtils d = new DBUtils(NoticeFactory.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            StringBuffer select = new StringBuffer("SELECT * FROM NOTIFICATIONS WHERE NODEID=? AND INTERFACEID=? AND SERVICEID=?");
            if (!includeAcknowledged) {
                select.append(" AND RESPONDTIME IS NULL");
            }
            select.append(" ORDER BY NOTIFYID DESC");
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            stmt.setString(2, ipAddress);
            stmt.setInt(3, serviceId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            notices = NoticeFactory.rs2Notices(rs, servletContext);
        }
        finally {
            d.cleanUp();
        }
        return notices;
    }

    public static Notification[] getNoticesForService(int serviceId, ServletContext servletContext) throws SQLException {
        return NoticeFactory.getNoticesForService(serviceId, false, servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Notification[] getNoticesForService(int serviceId, boolean includeAcknowledged, ServletContext servletContext) throws SQLException {
        Notification[] notices = null;
        DBUtils d = new DBUtils(NoticeFactory.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            StringBuffer select = new StringBuffer("SELECT * FROM NOTIFICATION WHERE SERVICEID=?");
            if (!includeAcknowledged) {
                select.append(" AND RESPONDTIME IS NULL");
            }
            select.append(" ORDER BY NOTIFIYID DESC");
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            stmt.setInt(1, serviceId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            notices = NoticeFactory.rs2Notices(rs, servletContext);
        }
        finally {
            d.cleanUp();
        }
        return notices;
    }

    public static void acknowledge(Notification[] notices, String user) throws SQLException {
        NoticeFactory.acknowledge(notices, user, new Date());
    }

    public static void acknowledge(Notification[] notices, String user, Date time) throws SQLException {
        if (notices == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int[] ids = new int[notices.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = notices[i].getId();
        }
        NoticeFactory.acknowledge(ids, user, time);
    }

    public static void acknowledge(int[] noticeIds, String user) throws SQLException {
        NoticeFactory.acknowledge(noticeIds, user, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acknowledge(int[] noticeIds, String user, Date time) throws SQLException {
        if (noticeIds == null || user == null || time == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (noticeIds.length > 0) {
            StringBuffer update = new StringBuffer("UPDATE NOTIFICATIONS SET RESPONDTIME=?, ANSWEREDBY=?");
            update.append(" WHERE NOTIFYID IN (");
            update.append(noticeIds[0]);
            for (int i = 1; i < noticeIds.length; ++i) {
                update.append(",");
                update.append(noticeIds[i]);
            }
            update.append(")");
            update.append(" AND RESPONDTIME IS NULL");
            DBUtils d = new DBUtils(NoticeFactory.class);
            try {
                Connection conn = DataSourceFactory.getInstance().getConnection();
                d.watch((Object)conn);
                PreparedStatement stmt = conn.prepareStatement(update.toString());
                d.watch((Object)stmt);
                stmt.setTimestamp(1, new Timestamp(time.getTime()));
                stmt.setString(2, user);
                stmt.executeUpdate();
            }
            finally {
                d.cleanUp();
            }
        }
    }

    protected static Notification[] rs2Notices(ResultSet rs, ServletContext servletContext) throws SQLException {
        Notification[] notices = null;
        Vector<Notification> vector = new Vector<Notification>();
        while (rs.next()) {
            Notification notice = new Notification();
            Object element = rs.getInt("notifyid");
            notice.m_notifyID = (Integer)element;
            element = rs.getTimestamp("pagetime");
            if (element != null) {
                notice.m_timeSent = ((Timestamp)element).getTime();
            }
            if ((element = rs.getTimestamp("respondtime")) != null) {
                notice.m_timeReply = ((Timestamp)element).getTime();
            }
            element = rs.getString("textmsg");
            notice.m_txtMsg = (String)element;
            element = rs.getString("numericmsg");
            notice.m_numMsg = (String)element;
            element = rs.getString("answeredby");
            notice.m_responder = (String)element;
            element = rs.getInt("nodeid");
            notice.m_nodeID = (Integer)element;
            element = rs.getString("interfaceid");
            notice.m_interfaceID = (String)element;
            element = rs.getInt("eventid");
            notice.m_eventId = (Integer)element;
            element = rs.getInt("serviceid");
            if (element != null) {
                notice.m_serviceId = (Integer)element;
                element = NetworkElementFactory.getInstance(servletContext).getServiceNameFromId(notice.m_serviceId);
                notice.m_serviceName = (String)element;
            }
            vector.addElement(notice);
        }
        notices = new Notification[vector.size()];
        for (int i = 0; i < notices.length; ++i) {
            notices[i] = (Notification)vector.elementAt(i);
        }
        return notices;
    }
}

