/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.enlinkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.dao.api.BridgeBridgeLinkDao;
import org.opennms.netmgt.dao.api.BridgeElementDao;
import org.opennms.netmgt.dao.api.BridgeMacLinkDao;
import org.opennms.netmgt.dao.api.CdpElementDao;
import org.opennms.netmgt.dao.api.CdpLinkDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.IpNetToMediaDao;
import org.opennms.netmgt.dao.api.IsIsElementDao;
import org.opennms.netmgt.dao.api.IsIsLinkDao;
import org.opennms.netmgt.dao.api.LldpElementDao;
import org.opennms.netmgt.dao.api.LldpLinkDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OspfElementDao;
import org.opennms.netmgt.dao.api.OspfLinkDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.CdpElement;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.IpNetToMedia;
import org.opennms.netmgt.model.IsIsElement;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.web.api.Util;
import org.opennms.web.enlinkd.BridgeElementNode;
import org.opennms.web.enlinkd.BridgeLinkNode;
import org.opennms.web.enlinkd.BridgeLinkRemoteNode;
import org.opennms.web.enlinkd.CdpElementNode;
import org.opennms.web.enlinkd.CdpLinkNode;
import org.opennms.web.enlinkd.EnLinkdElementFactoryInterface;
import org.opennms.web.enlinkd.IsisElementNode;
import org.opennms.web.enlinkd.IsisLinkNode;
import org.opennms.web.enlinkd.LldpElementNode;
import org.opennms.web.enlinkd.LldpLinkNode;
import org.opennms.web.enlinkd.NodeLinkBridge;
import org.opennms.web.enlinkd.OspfElementNode;
import org.opennms.web.enlinkd.OspfLinkNode;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Transactional(readOnly=true)
public class EnLinkdElementFactory
implements InitializingBean,
EnLinkdElementFactoryInterface {
    @Autowired
    private OspfElementDao m_ospfElementDao;
    @Autowired
    private OspfLinkDao m_ospfLinkDao;
    @Autowired
    private LldpElementDao m_lldpElementDao;
    @Autowired
    private LldpLinkDao m_lldpLinkDao;
    @Autowired
    private CdpElementDao m_cdpElementDao;
    @Autowired
    private CdpLinkDao m_cdpLinkDao;
    @Autowired
    private BridgeElementDao m_bridgeElementDao;
    @Autowired
    private BridgeMacLinkDao m_bridgeMacLinkDao;
    @Autowired
    private BridgeBridgeLinkDao m_bridgeBridgeLinkDao;
    @Autowired
    private IpNetToMediaDao m_ipNetToMediaDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    @Autowired
    private IsIsElementDao m_isisElementDao;
    @Autowired
    private IsIsLinkDao m_isisLinkDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    public static EnLinkdElementFactoryInterface getInstance(ServletContext servletContext) {
        return EnLinkdElementFactory.getInstance((ApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext));
    }

    public static EnLinkdElementFactoryInterface getInstance(ApplicationContext appContext) {
        return (EnLinkdElementFactoryInterface)appContext.getBean(EnLinkdElementFactoryInterface.class);
    }

    @Override
    public OspfElementNode getOspfElement(int nodeId) {
        return this.convertFromModel(this.m_ospfElementDao.findByNodeId(Integer.valueOf(nodeId)));
    }

    private OspfElementNode convertFromModel(OspfElement ospf) {
        if (ospf == null) {
            return null;
        }
        OspfElementNode ospfNode = new OspfElementNode();
        ospfNode.setOspfRouterId(InetAddressUtils.str((InetAddress)ospf.getOspfRouterId()));
        ospfNode.setOspfVersionNumber(ospf.getOspfVersionNumber());
        ospfNode.setOspfAdminStat(OspfElement.Status.getTypeString((Integer)ospf.getOspfAdminStat().getValue()));
        ospfNode.setOspfCreateTime(Util.formatDateToUIString((Date)ospf.getOspfNodeCreateTime()));
        ospfNode.setOspfLastPollTime(Util.formatDateToUIString((Date)ospf.getOspfNodeLastPollTime()));
        return ospfNode;
    }

    @Override
    public List<OspfLinkNode> getOspfLinks(int nodeId) {
        ArrayList<OspfLinkNode> nodelinks = new ArrayList<OspfLinkNode>();
        for (OspfLink link : this.m_ospfLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodelinks.addAll(this.convertFromModel(nodeId, link));
        }
        return nodelinks;
    }

    @Transactional
    private List<OspfLinkNode> convertFromModel(int nodeid, OspfLink link) {
        ArrayList<OspfLinkNode> linkNodes = new ArrayList<OspfLinkNode>();
        List ospfElements = this.m_ospfElementDao.findAllByRouterId(link.getOspfRemRouterId());
        if (ospfElements.size() > 0) {
            for (OspfElement ospfElement : ospfElements) {
                OspfLinkNode linknode = new OspfLinkNode();
                linknode.setOspfIpAddr(InetAddressUtils.str((InetAddress)link.getOspfIpAddr()));
                linknode.setOspfAddressLessIndex(link.getOspfAddressLessIndex());
                linknode.setOspfIfIndex(link.getOspfIfIndex());
                linknode.setOspfRemRouterId(this.getRemRouterIdString(InetAddressUtils.str((InetAddress)link.getOspfRemRouterId()), ospfElement.getNode().getLabel()));
                linknode.setOspfRemRouterUrl(this.getNodeUrl(ospfElement.getNode().getId()));
                linknode.setOspfRemIpAddr(InetAddressUtils.str((InetAddress)link.getOspfRemIpAddr()));
                linknode.setOspfRemAddressLessIndex(link.getOspfRemAddressLessIndex());
                if (ospfElement != null && linknode.getOspfRemIpAddr() != null) {
                    linknode.setOspfRemPortUrl(this.getIpInterfaceUrl(ospfElement.getNode().getId(), linknode.getOspfRemIpAddr()));
                }
                linknode.setOspfLinkCreateTime(Util.formatDateToUIString((Date)link.getOspfLinkCreateTime()));
                linknode.setOspfLinkLastPollTime(Util.formatDateToUIString((Date)link.getOspfLinkLastPollTime()));
                linkNodes.add(linknode);
            }
        } else {
            OspfLinkNode linknode = new OspfLinkNode();
            linknode.setOspfIpAddr(InetAddressUtils.str((InetAddress)link.getOspfIpAddr()));
            linknode.setOspfAddressLessIndex(link.getOspfAddressLessIndex());
            linknode.setOspfIfIndex(link.getOspfIfIndex());
            linknode.setOspfRemRouterId(InetAddressUtils.str((InetAddress)link.getOspfRemRouterId()));
            linknode.setOspfRemIpAddr(InetAddressUtils.str((InetAddress)link.getOspfRemIpAddr()));
            linknode.setOspfRemAddressLessIndex(link.getOspfRemAddressLessIndex());
            linknode.setOspfLinkCreateTime(Util.formatDateToUIString((Date)link.getOspfLinkCreateTime()));
            linknode.setOspfLinkLastPollTime(Util.formatDateToUIString((Date)link.getOspfLinkLastPollTime()));
            linkNodes.add(linknode);
        }
        return linkNodes;
    }

    @Override
    public CdpElementNode getCdpElement(int nodeId) {
        return this.convertFromModel(this.m_cdpElementDao.findByNodeId(Integer.valueOf(nodeId)));
    }

    private CdpElementNode convertFromModel(CdpElement cdp) {
        if (cdp == null) {
            return null;
        }
        CdpElementNode cdpNode = new CdpElementNode();
        cdpNode.setCdpGlobalRun(OspfElement.TruthValue.getTypeString((Integer)cdp.getCdpGlobalRun().getValue()));
        cdpNode.setCdpGlobalDeviceId(cdp.getCdpGlobalDeviceId());
        if (cdp.getCdpGlobalDeviceIdFormat() != null) {
            cdpNode.setCdpGlobalDeviceIdFormat(CdpElement.CdpGlobalDeviceIdFormat.getTypeString((Integer)cdp.getCdpGlobalDeviceIdFormat().getValue()));
        } else {
            cdpNode.setCdpGlobalDeviceIdFormat("&nbsp");
        }
        cdpNode.setCdpCreateTime(Util.formatDateToUIString((Date)cdp.getCdpNodeCreateTime()));
        cdpNode.setCdpLastPollTime(Util.formatDateToUIString((Date)cdp.getCdpNodeLastPollTime()));
        return cdpNode;
    }

    @Override
    public List<CdpLinkNode> getCdpLinks(int nodeId) {
        ArrayList<CdpLinkNode> nodelinks = new ArrayList<CdpLinkNode>();
        for (CdpLink link : this.m_cdpLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodelinks.add(this.convertFromModel(nodeId, link));
        }
        return nodelinks;
    }

    @Transactional
    private CdpLinkNode convertFromModel(int nodeid, CdpLink link) {
        CdpLinkNode linknode = new CdpLinkNode();
        linknode.setCdpLocalPort(this.getPortString(link.getCdpCacheIfIndex(), link.getCdpInterfaceName()));
        if (link.getCdpCacheIfIndex() != null) {
            linknode.setCdpLocalPortUrl(this.getSnmpInterfaceUrl(nodeid, link.getCdpCacheIfIndex()));
        }
        linknode.setCdpCacheAddressType(CdpLink.CiscoNetworkProtocolType.getTypeString((Integer)link.getCdpCacheAddressType().getValue()));
        linknode.setCdpCacheAddress(link.getCdpCacheAddress());
        linknode.setCdpCacheDeviceId(link.getCdpCacheDeviceId());
        linknode.setCdpCacheDevicePlatform(link.getCdpCacheDevicePlatform());
        linknode.setCdpCacheVersion(link.getCdpCacheVersion());
        linknode.setCdpCacheDevicePort(link.getCdpCacheDevicePort());
        CdpElement cdpCacheElement = this.m_cdpElementDao.findByGlobalDeviceId(link.getCdpCacheDeviceId());
        if (cdpCacheElement != null) {
            linknode.setCdpCacheDeviceUrl(this.getNodeUrl(cdpCacheElement.getNode().getId()));
            OnmsSnmpInterface cdpcachesnmp = this.getFromCdpCacheDevicePort(cdpCacheElement.getNode().getId(), link.getCdpCacheDevicePort());
            if (cdpcachesnmp != null) {
                linknode.setCdpCacheDevicePort(this.getPortString(cdpcachesnmp.getIfIndex(), link.getCdpCacheDevicePort()));
                linknode.setCdpCacheDevicePortUrl(this.getSnmpInterfaceUrl(cdpCacheElement.getNode().getId(), cdpcachesnmp.getIfIndex()));
            }
        }
        linknode.setCdpCreateTime(Util.formatDateToUIString((Date)link.getCdpLinkCreateTime()));
        linknode.setCdpLastPollTime(Util.formatDateToUIString((Date)link.getCdpLinkLastPollTime()));
        return linknode;
    }

    @Override
    public LldpElementNode getLldpElement(int nodeId) {
        return this.convertFromModel(this.m_lldpElementDao.findByNodeId(Integer.valueOf(nodeId)));
    }

    private LldpElementNode convertFromModel(LldpElement lldp) {
        if (lldp == null) {
            return null;
        }
        LldpElementNode lldpNode = new LldpElementNode();
        lldpNode.setLldpChassisIdString(this.getChassisIdString(lldp.getLldpChassisId(), lldp.getLldpChassisIdSubType()));
        lldpNode.setLldpSysName(lldp.getLldpSysname());
        lldpNode.setLldpCreateTime(Util.formatDateToUIString((Date)lldp.getLldpNodeCreateTime()));
        lldpNode.setLldpLastPollTime(Util.formatDateToUIString((Date)lldp.getLldpNodeLastPollTime()));
        return lldpNode;
    }

    @Override
    public List<LldpLinkNode> getLldpLinks(int nodeId) {
        ArrayList<LldpLinkNode> nodelinks = new ArrayList<LldpLinkNode>();
        for (LldpLink link : this.m_lldpLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodelinks.add(this.convertFromModel(nodeId, link));
        }
        return nodelinks;
    }

    @Transactional
    private LldpLinkNode convertFromModel(int nodeid, LldpLink link) {
        LldpLinkNode linknode = new LldpLinkNode();
        linknode.setLldpPortString(this.getPortString(link.getLldpPortId(), link.getLldpPortIdSubType()));
        linknode.setLldpPortDescr(link.getLldpPortDescr());
        linknode.setLldpPortUrl(this.getSnmpInterfaceUrl(nodeid, link.getLldpPortIfindex()));
        linknode.setLldpRemSysName(link.getLldpRemSysname());
        linknode.setLldpRemPortString(this.getPortString(link.getLldpRemPortId(), link.getLldpRemPortIdSubType()));
        linknode.setLldpRemPortDescr(link.getLldpRemPortDescr());
        linknode.setLldpCreateTime(Util.formatDateToUIString((Date)link.getLldpLinkCreateTime()));
        linknode.setLldpLastPollTime(Util.formatDateToUIString((Date)link.getLldpLinkLastPollTime()));
        OnmsNode remNode = null;
        List lldpremelements = this.m_lldpElementDao.findByChassisId(link.getLldpRemChassisId(), link.getLldpRemChassisIdSubType());
        if (lldpremelements.size() == 1) {
            remNode = ((LldpElement)lldpremelements.get(0)).getNode();
        } else {
            if (lldpremelements.size() > 1) {
                linknode.setLldpRemChassisIdString(this.getChassisIdString("Found " + lldpremelements.size() + " nodes for", link.getLldpRemChassisId(), link.getLldpRemChassisIdSubType()));
                return linknode;
            }
            Criteria criteria = new Criteria(OnmsNode.class).addRestriction((Restriction)new EqRestriction("sysName", (Object)link.getLldpRemSysname()));
            List nodes = this.m_nodeDao.findMatching(criteria);
            if (nodes.size() == 1) {
                remNode = (OnmsNode)nodes.get(0);
            }
        }
        if (remNode != null) {
            linknode.setLldpRemChassisIdString(this.getChassisIdString(remNode.getLabel(), link.getLldpRemChassisId(), link.getLldpRemChassisIdSubType()));
            linknode.setLldpRemChassisIdUrl(this.getNodeUrl(remNode.getId()));
            if (link.getLldpRemPortIdSubType() == LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_LOCAL) {
                try {
                    Integer remIfIndex = Integer.getInteger(link.getLldpRemPortId());
                    linknode.setLldpRemPortUrl(this.getSnmpInterfaceUrl((int)remNode.getId(), remIfIndex));
                }
                catch (Exception exception) {}
            }
        } else {
            linknode.setLldpRemChassisIdString(this.getChassisIdString(link.getLldpRemChassisId(), link.getLldpRemChassisIdSubType()));
        }
        return linknode;
    }

    @Override
    public IsisElementNode getIsisElement(int nodeId) {
        return this.convertFromModel(this.m_isisElementDao.findByNodeId(Integer.valueOf(nodeId)));
    }

    private IsisElementNode convertFromModel(IsIsElement isis) {
        if (isis == null) {
            return null;
        }
        IsisElementNode isisNode = new IsisElementNode();
        isisNode.setIsisSysID(isis.getIsisSysID());
        isisNode.setIsisSysAdminState(IsIsElement.IsisAdminState.getTypeString((Integer)isis.getIsisSysAdminState().getValue()));
        isisNode.setIsisCreateTime(Util.formatDateToUIString((Date)isis.getIsisNodeCreateTime()));
        isisNode.setIsisLastPollTime(Util.formatDateToUIString((Date)isis.getIsisNodeLastPollTime()));
        return isisNode;
    }

    @Override
    public List<IsisLinkNode> getIsisLinks(int nodeId) {
        ArrayList<IsisLinkNode> nodelinks = new ArrayList<IsisLinkNode>();
        for (IsIsLink link : this.m_isisLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodelinks.add(this.convertFromModel(nodeId, link));
        }
        return nodelinks;
    }

    @Transactional
    private IsisLinkNode convertFromModel(int nodeid, IsIsLink link) {
        IsIsLink adjLink;
        IsisLinkNode linknode = new IsisLinkNode();
        linknode.setIsisCircIfIndex(link.getIsisCircIfIndex());
        linknode.setIsisCircAdminState(IsIsElement.IsisAdminState.getTypeString((Integer)link.getIsisCircAdminState().getValue()));
        IsIsElement isiselement = this.m_isisElementDao.findByIsIsSysId(link.getIsisISAdjNeighSysID());
        if (isiselement != null) {
            linknode.setIsisISAdjNeighSysID(this.getAdjSysIDString(link.getIsisISAdjNeighSysID(), isiselement.getNode().getLabel()));
            linknode.setIsisISAdjUrl(this.getNodeUrl(isiselement.getNode().getId()));
        } else {
            linknode.setIsisISAdjNeighSysID(link.getIsisISAdjNeighSysID());
        }
        linknode.setIsisISAdjNeighSysType(IsIsLink.IsisISAdjNeighSysType.getTypeString((Integer)link.getIsisISAdjNeighSysType().getValue()));
        linknode.setIsisISAdjNeighSNPAAddress(link.getIsisISAdjNeighSNPAAddress());
        linknode.setIsisISAdjState(IsIsLink.IsisISAdjState.get((Integer)link.getIsisISAdjState().getValue()).toString());
        linknode.setIsisISAdjNbrExtendedCircID(link.getIsisISAdjNbrExtendedCircID());
        OnmsSnmpInterface remiface = null;
        if (isiselement != null && (adjLink = this.m_isisLinkDao.get(isiselement.getNode().getId(), link.getIsisISAdjIndex(), link.getIsisCircIndex())) != null) {
            remiface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(isiselement.getNode().getId(), adjLink.getIsisCircIfIndex());
        }
        if (remiface == null) {
            remiface = this.getFromPhysAddress(link.getIsisISAdjNeighSNPAAddress());
        }
        if (remiface != null) {
            linknode.setIsisISAdjNeighPort(this.getPortString(remiface.getIfIndex(), remiface.getIfName()));
            linknode.setIsisISAdjUrl(this.getSnmpInterfaceUrl(remiface.getNode().getId(), remiface.getIfIndex()));
        } else {
            linknode.setIsisISAdjNeighPort("(Isis IS Adj Index: " + link.getIsisISAdjIndex() + ")");
        }
        linknode.setIsisLinkCreateTime(Util.formatDateToUIString((Date)link.getIsisLinkCreateTime()));
        linknode.setIsisLinkLastPollTime(Util.formatDateToUIString((Date)link.getIsisLinkLastPollTime()));
        return linknode;
    }

    @Override
    public List<BridgeElementNode> getBridgeElements(int nodeId) {
        ArrayList<BridgeElementNode> nodes = new ArrayList<BridgeElementNode>();
        for (BridgeElement bridge : this.m_bridgeElementDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodes.add(this.convertFromModel(bridge));
        }
        return nodes;
    }

    private BridgeElementNode convertFromModel(BridgeElement bridge) {
        if (bridge == null) {
            return null;
        }
        BridgeElementNode bridgeNode = new BridgeElementNode();
        bridgeNode.setBaseBridgeAddress(bridge.getBaseBridgeAddress());
        bridgeNode.setBaseNumPorts(bridge.getBaseNumPorts());
        bridgeNode.setBaseType(BridgeElement.BridgeDot1dBaseType.getTypeString((Integer)bridge.getBaseType().getValue()));
        bridgeNode.setVlan(bridge.getVlan());
        bridgeNode.setVlanname(bridge.getVlanname());
        if (bridge.getStpProtocolSpecification() != null) {
            bridgeNode.setStpProtocolSpecification(BridgeElement.BridgeDot1dStpProtocolSpecification.getTypeString((Integer)bridge.getStpProtocolSpecification().getValue()));
        }
        bridgeNode.setStpPriority(bridge.getStpPriority());
        bridgeNode.setStpDesignatedRoot(bridge.getStpDesignatedRoot());
        bridgeNode.setStpRootCost(bridge.getStpRootCost());
        bridgeNode.setStpRootPort(bridge.getStpRootPort());
        bridgeNode.setBridgeNodeCreateTime(Util.formatDateToUIString((Date)bridge.getBridgeNodeCreateTime()));
        bridgeNode.setBridgeNodeLastPollTime(Util.formatDateToUIString((Date)bridge.getBridgeNodeLastPollTime()));
        return bridgeNode;
    }

    @Override
    public Collection<NodeLinkBridge> getNodeLinks(int nodeId) {
        HashMap<Integer, NodeLinkBridge> nodelinks = new HashMap<Integer, NodeLinkBridge>();
        for (OnmsIpInterface ip : this.m_ipInterfaceDao.findByNodeId(Integer.valueOf(nodeId))) {
            for (IpNetToMedia ipnetomedia : this.m_ipNetToMediaDao.findByNetAddress(ip.getIpAddress())) {
                for (BridgeMacLink maclink : this.m_bridgeMacLinkDao.findByMacAddress(ipnetomedia.getPhysAddress())) {
                    this.convertFromModel(nodeId, maclink, this.getNodePortString(InetAddressUtils.str((InetAddress)ipnetomedia.getNetAddress()), ipnetomedia.getPhysAddress()), nodelinks);
                }
            }
        }
        return nodelinks.values();
    }

    @Transactional
    private void convertFromModel(int nodeid, BridgeMacLink link, String port, Map<Integer, NodeLinkBridge> nodelinks) {
        if (!nodelinks.containsKey(link.getId())) {
            OnmsSnmpInterface remiface;
            NodeLinkBridge linknode = new NodeLinkBridge();
            BridgeLinkRemoteNode remlinknode = new BridgeLinkRemoteNode();
            Integer nodeId = link.getNode() == null ? null : link.getNode().getId();
            Integer bridgePortIfIndex = link.getBridgePortIfIndex();
            remlinknode.setBridgeRemoteNode(link.getNode().getLabel());
            remlinknode.setBridgeRemoteUrl(this.getNodeUrl(nodeId));
            OnmsSnmpInterface onmsSnmpInterface = remiface = bridgePortIfIndex == null ? null : this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(nodeId, bridgePortIfIndex);
            if (remiface != null) {
                remlinknode.setBridgeRemotePort(this.getPortString(remiface));
            } else {
                remlinknode.setBridgeRemotePort(this.getPortString(bridgePortIfIndex, null));
            }
            remlinknode.setBridgeRemotePortUrl(this.getSnmpInterfaceUrl(nodeId, bridgePortIfIndex));
            remlinknode.setBridgeRemoteVlan(link.getVlan());
            linknode.setBridgeLinkRemoteNode(remlinknode);
            linknode.setBridgeLinkCreateTime(Util.formatDateToUIString((Date)link.getBridgeMacLinkCreateTime()));
            linknode.setBridgeLinkLastPollTime(Util.formatDateToUIString((Date)link.getBridgeMacLinkLastPollTime()));
            nodelinks.put(link.getId(), linknode);
        }
        nodelinks.get(link.getId()).getNodeLocalPorts().add(port);
    }

    @Override
    public Collection<BridgeLinkNode> getBridgeLinks(int nodeId) {
        HashMap<Integer, BridgeLinkNode> bridgelinks = new HashMap<Integer, BridgeLinkNode>();
        for (BridgeMacLink link : this.m_bridgeMacLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            this.convertFromModel(nodeId, link, bridgelinks);
        }
        for (BridgeMacLink link : this.m_bridgeBridgeLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            this.convertFromModel(nodeId, (BridgeBridgeLink)link, bridgelinks);
        }
        for (BridgeMacLink link : this.m_bridgeBridgeLinkDao.findByDesignatedNodeId(Integer.valueOf(nodeId))) {
            this.convertFromModel(nodeId, link.getReverseBridgeBridgeLink(), bridgelinks);
        }
        return bridgelinks.values();
    }

    @Transactional
    private void convertFromModel(int nodeid, BridgeBridgeLink link, Map<Integer, BridgeLinkNode> bridgelinks) {
        BridgeLinkNode linknode = new BridgeLinkNode();
        if (bridgelinks.containsKey(link.getBridgePort())) {
            linknode = bridgelinks.get(link.getBridgePort());
        } else {
            linknode.setBridgeLocalPort(this.getBridgePortString(link.getBridgePort(), link.getBridgePortIfIndex()));
            linknode.setBridgeLocalVlan(link.getVlan());
            linknode.setBridgeLinkCreateTime(Util.formatDateToUIString((Date)link.getBridgeBridgeLinkCreateTime()));
            linknode.setBridgeLinkLastPollTime(Util.formatDateToUIString((Date)link.getBridgeBridgeLinkLastPollTime()));
            bridgelinks.put(link.getBridgePort(), linknode);
        }
        BridgeLinkRemoteNode remlinknode = new BridgeLinkRemoteNode();
        remlinknode.setBridgeRemoteNode(link.getDesignatedNode().getLabel());
        remlinknode.setBridgeRemoteUrl(this.getNodeUrl(link.getDesignatedNode().getId()));
        OnmsSnmpInterface remiface = this.getSnmpInterface(link.getDesignatedNode(), link.getDesignatedPortIfIndex());
        remlinknode.setBridgeRemotePort(this.getPortString(remiface));
        remlinknode.setBridgeRemotePortUrl(this.getSnmpInterfaceUrl(remiface));
        remlinknode.setBridgeRemoteVlan(link.getDesignatedVlan());
        linknode.getBridgeLinkRemoteNodes().add(remlinknode);
    }

    @Transactional
    private void convertFromModel(int nodeid, BridgeMacLink link, Map<Integer, BridgeLinkNode> bridgelinks) {
        BridgeLinkNode linknode = new BridgeLinkNode();
        if (bridgelinks.containsKey(link.getBridgePort())) {
            linknode = bridgelinks.get(link.getBridgePort());
        } else {
            linknode.setBridgeLocalPort(this.getBridgePortString(link.getBridgePort(), link.getBridgePortIfIndex()));
            linknode.setBridgeLocalVlan(link.getVlan());
            linknode.setBridgeLinkCreateTime(Util.formatDateToUIString((Date)link.getBridgeMacLinkCreateTime()));
            linknode.setBridgeLinkLastPollTime(Util.formatDateToUIString((Date)link.getBridgeMacLinkLastPollTime()));
            bridgelinks.put(link.getBridgePort(), linknode);
        }
        List ipnettomedias = this.m_ipNetToMediaDao.findByPhysAddress(link.getMacAddress());
        if (ipnettomedias.isEmpty()) {
            BridgeLinkRemoteNode remlinknode = new BridgeLinkRemoteNode();
            OnmsSnmpInterface snmp = this.getFromPhysAddress(link.getMacAddress());
            if (snmp == null) {
                remlinknode.setBridgeRemoteNode(link.getMacAddress() + " No node associated in db");
            } else {
                remlinknode.setBridgeRemoteNode(snmp.getNode().getLabel());
                remlinknode.setBridgeRemoteUrl(this.getNodeUrl(snmp.getNode().getId()));
                remlinknode.setBridgeRemotePort(this.getPortString(snmp));
                remlinknode.setBridgeRemotePortUrl(this.getSnmpInterfaceUrl(snmp.getNode().getId(), snmp.getIfIndex()));
            }
            linknode.getBridgeLinkRemoteNodes().add(remlinknode);
        }
        for (IpNetToMedia ipnettomedia : ipnettomedias) {
            BridgeLinkRemoteNode remlinknode = new BridgeLinkRemoteNode();
            List ips = this.m_ipInterfaceDao.findByIpAddress(ipnettomedia.getNetAddress().getHostAddress());
            if (ips.isEmpty()) {
                remlinknode.setBridgeRemoteNode(InetAddressUtils.str((InetAddress)ipnettomedia.getNetAddress()) + "/" + link.getMacAddress() + " No node associated in db");
            } else if (ips.size() > 1) {
                remlinknode.setBridgeRemoteNode(InetAddressUtils.str((InetAddress)ipnettomedia.getNetAddress()) + "/" + link.getMacAddress() + " duplicated ip multiple node associated in db");
            }
            for (OnmsIpInterface ip : ips) {
                remlinknode.setBridgeRemoteNode(ip.getNode().getLabel());
                remlinknode.setBridgeRemoteUrl(this.getNodeUrl(ip.getNode().getId()));
                remlinknode.setBridgeRemotePort(InetAddressUtils.str((InetAddress)ipnettomedia.getNetAddress()) + "/" + link.getMacAddress());
                remlinknode.setBridgeRemotePortUrl(this.getIpInterfaceUrl(ip));
            }
            linknode.getBridgeLinkRemoteNodes().add(remlinknode);
        }
    }

    private String getAdjSysIDString(String adjsysid, String label) {
        return adjsysid + "(" + label + ")";
    }

    private String getChassisIdString(String sysname, String chassisId, LldpUtils.LldpChassisIdSubType chassisType) {
        return sysname + ": " + LldpUtils.LldpChassisIdSubType.getTypeString((Integer)chassisType.getValue()) + ": " + chassisId;
    }

    private String getChassisIdString(String chassisId, LldpUtils.LldpChassisIdSubType chassisType) {
        return LldpUtils.LldpChassisIdSubType.getTypeString((Integer)chassisType.getValue()) + ": " + chassisId;
    }

    private String getPortString(String portId, LldpUtils.LldpPortIdSubType type) {
        return LldpUtils.LldpPortIdSubType.getTypeString((Integer)type.getValue()) + ": " + portId;
    }

    private OnmsSnmpInterface getFromCdpCacheDevicePort(Integer nodeid, String cdpCacheDevicePort) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsSnmpInterface.class);
        builder.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        builder.sql((Object)("snmpifalias = '" + cdpCacheDevicePort + "' OR snmpifname = '" + cdpCacheDevicePort + "' OR snmpifdescr = '" + cdpCacheDevicePort + "'")).eq("node.id", (Object)nodeid);
        List nodes = this.m_snmpInterfaceDao.findMatching(builder.toCriteria());
        if (nodes.size() == 1) {
            return (OnmsSnmpInterface)nodes.get(0);
        }
        return null;
    }

    private OnmsSnmpInterface getFromPhysAddress(String physAddress) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsSnmpInterface.class);
        builder.eq("physAddr", (Object)physAddress);
        List nodes = this.m_snmpInterfaceDao.findMatching(builder.toCriteria());
        if (nodes.size() == 1) {
            return (OnmsSnmpInterface)nodes.get(0);
        }
        return null;
    }

    private String getNodePortString(String ip, String physaddr) {
        if (ip != null && physaddr != null) {
            return ip + "(" + physaddr + ")";
        }
        return null;
    }

    private String getBridgePortString(Integer bridgePort, Integer ifindex) {
        if (ifindex != null) {
            return "bridge port: " + bridgePort + "(ifindex:" + ifindex + ")";
        }
        return "bridge port: " + bridgePort;
    }

    private OnmsSnmpInterface getSnmpInterface(OnmsNode node, Integer ifIndex) {
        if (node != null && node.getId() != null && ifIndex != null) {
            OnmsSnmpInterface snmpInterface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(node.getId(), ifIndex);
            return snmpInterface;
        }
        return null;
    }

    private String getPortString(OnmsSnmpInterface iface) {
        if (iface != null) {
            return this.getPortString(iface.getIfIndex(), iface.getIfName());
        }
        return this.getPortString((Integer)null, (String)null);
    }

    private String getPortString(Integer ifindex, String portName) {
        if (ifindex != null && portName != null) {
            return portName + "(ifindex:" + ifindex + ")";
        }
        if (portName != null) {
            return portName;
        }
        if (ifindex != null) {
            return "(ifindex:" + ifindex + ")";
        }
        return "(no interface found in db)";
    }

    private String getRemRouterIdString(String ip, String label) {
        return ip + "(" + label + ")";
    }

    private String getNodeUrl(Integer nodeid) {
        return "element/node.jsp?node=" + nodeid;
    }

    private String getSnmpInterfaceUrl(OnmsSnmpInterface iface) {
        if (iface != null) {
            return this.getSnmpInterfaceUrl(iface.getNode().getId(), iface.getIfIndex());
        }
        return null;
    }

    private String getSnmpInterfaceUrl(Integer nodeid, Integer ifindex) {
        if (ifindex != null && nodeid != null) {
            return "element/snmpinterface.jsp?node=" + nodeid + "&ifindex=" + ifindex;
        }
        return null;
    }

    private String getIpInterfaceUrl(Integer nodeid, String ipaddress) {
        return "element/interface.jsp?node=" + nodeid + "&intf=" + ipaddress;
    }

    private String getIpInterfaceUrl(OnmsIpInterface ip) {
        return "element/interface.jsp?node=" + ip.getNode().getId() + "&intf=" + InetAddressUtils.str((InetAddress)ip.getIpAddress());
    }
}

