/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.admin.notifications;

import com.google.common.collect.Maps;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.utils.BundleLists;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.xml.eventconf.Event;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.view.RedirectView;

public class ChooseUeisController
extends AbstractController {
    @Autowired
    private EventConfDao m_eventConfDao;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        Notification newNotice = (Notification)session.getAttribute("newNotice");
        if (newNotice == null) {
            return new ModelAndView((View)new RedirectView("eventNotices.htm"));
        }
        return new ModelAndView("/admin/notification/noticeWizard/chooseUeis", "model", this.createModel(newNotice));
    }

    private Map<String, Object> createModel(Notification newNotice) throws FileNotFoundException, IOException {
        HashMap model = Maps.newHashMap();
        model.put("title", newNotice.getName() != null ? "Editing notice: " + newNotice.getName() : "");
        model.put("noticeUei", newNotice.getUei() != null ? newNotice.getUei() : "");
        model.put("eventSelect", this.buildEventSelect(newNotice));
        return model;
    }

    private String buildEventSelect(Notification notice) throws IOException, FileNotFoundException {
        String uei;
        List events = this.m_eventConfDao.getEventsByLabel();
        StringBuffer buffer = new StringBuffer();
        List<String> excludeList = this.getExcludeList();
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        ArrayList<Event> disappearingList = new ArrayList<Event>();
        if (notice.getUei() != null && notice.getUei().startsWith("~")) {
            buffer.append("<option selected value=\"" + notice.getUei() + "\">REGEX_FIELD</option>\n");
        } else {
            buffer.append("<option value=\"~^$\">REGEX_FIELD</option>\n");
        }
        for (Event e : events) {
            uei = e.getUei();
            String label = e.getEventLabel();
            String trimmedUei = this.stripUei(uei);
            if (!excludeList.contains(trimmedUei) && !this.isDisappearingEvent(e)) {
                sortedMap.put(label, uei);
            }
            if (!this.isDisappearingEvent(e)) continue;
            disappearingList.add(e);
        }
        for (String label : sortedMap.keySet()) {
            uei = (String)sortedMap.get(label);
            if (uei.equals(notice.getUei())) {
                buffer.append("<option selected VALUE=" + uei + ">" + label + "</option>");
                continue;
            }
            buffer.append("<option value=" + uei + ">" + label + "</option>");
        }
        if (!disappearingList.isEmpty()) {
            buffer.append("<optgroup label=\"Events not eligible for notifications\" disabled=\"true\">");
            for (Event e : disappearingList) {
                String selected = " ";
                if (e.getUei().equals(notice.getUei())) {
                    selected = " selected ";
                }
                buffer.append("<option" + selected + "value=\"" + e.getUei() + "\">" + e.getEventLabel() + "</option>");
            }
            buffer.append("</optgroup>");
        }
        return buffer.toString();
    }

    public String stripUei(String uei) {
        String leftover = uei;
        for (int i = 0; i < 3; ++i) {
            leftover = leftover.substring(leftover.indexOf(47) + 1);
        }
        return leftover;
    }

    public List<String> getExcludeList() throws IOException, FileNotFoundException {
        ArrayList<String> excludes = new ArrayList<String>();
        Properties excludeProperties = new Properties();
        excludeProperties.load(new FileInputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.EXCLUDE_UEI_FILE_NAME)));
        String[] ueis = BundleLists.parseBundleList((String)excludeProperties.getProperty("excludes"));
        for (int i = 0; i < ueis.length; ++i) {
            excludes.add(ueis[i]);
        }
        return excludes;
    }

    public boolean isDisappearingEvent(Event e) {
        if (e.getLogmsg() != null && "donotpersist".equalsIgnoreCase(e.getLogmsg().getDest())) {
            return true;
        }
        return e.getAlarmData() != null && e.getAlarmData().getAutoClean() == true;
    }

    public void setEventConfDao(EventConfDao eventConfDao) {
        this.m_eventConfDao = eventConfDao;
    }
}

