/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.discovery;

import javax.servlet.http.HttpServletRequest;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class GeneralSettingsLoader {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralSettingsLoader.class);

    GeneralSettingsLoader() {
    }

    public static DiscoveryConfiguration load(HttpServletRequest request, DiscoveryConfiguration config) {
        String initSTStr = request.getParameter("initialsleeptime");
        String restartSTStr = request.getParameter("restartsleeptime");
        String threadsStr = request.getParameter("threads");
        String retriesStr = request.getParameter("retries");
        String timeoutStr = request.getParameter("timeout");
        LOG.debug("initialsleeptime: {}", (Object)initSTStr);
        LOG.debug("restartsleeptime: {}", (Object)restartSTStr);
        LOG.debug("threads: {}", (Object)threadsStr);
        LOG.debug("retries: {}", (Object)retriesStr);
        LOG.debug("timeout: {}", (Object)timeoutStr);
        long initSt = WebSecurityUtils.safeParseLong((String)initSTStr);
        long restartSt = WebSecurityUtils.safeParseLong((String)restartSTStr);
        config.setInitialSleepTime(initSt);
        config.setRestartSleepTime(restartSt);
        if (threadsStr != null) {
            config.setThreads(WebSecurityUtils.safeParseInt((String)threadsStr));
        }
        if (retriesStr != null && !retriesStr.trim().equals("") && !retriesStr.trim().equals("3")) {
            config.setRetries(WebSecurityUtils.safeParseInt((String)retriesStr));
        } else {
            config.deleteRetries();
        }
        if (timeoutStr != null && !timeoutStr.trim().equals("") && !timeoutStr.trim().equals("800")) {
            config.setTimeout(Long.valueOf(timeoutStr).longValue());
        } else {
            config.deleteTimeout();
        }
        LOG.debug("General settings uploaded.");
        return config;
    }
}

