/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public enum SortStyle {
    NODE("node"),
    FOREIGNSOURCE("foreignsource"),
    INTERFACE("interface"),
    SERVICE("service"),
    IFLOSTSERVICE("iflostservice"),
    IFREGAINEDSERVICE("ifregainedservice"),
    ID("id"),
    REVERSE_NODE("rev_node"),
    REVERSE_FOREIGNSOURCE("rev_foreignsource"),
    REVERSE_INTERFACE("rev_interface"),
    REVERSE_SERVICE("rev_service"),
    REVERSE_IFLOSTSERVICE("rev_iflostservice"),
    REVERSE_IFREGAINEDSERVICE("rev_ifregainedservice"),
    REVERSE_ID("rev_id");

    public static final SortStyle DEFAULT_SORT_STYLE;
    private static final Map<String, SortStyle> m_sortStylesString;
    private String m_shortName;

    private SortStyle(String shortName) {
        this.m_shortName = shortName;
    }

    public String toString() {
        return "SortStyle." + this.getName();
    }

    public String getName() {
        return this.name();
    }

    public String getShortName() {
        return this.m_shortName;
    }

    public static SortStyle getSortStyle(String sortStyleString) {
        Assert.notNull((Object)sortStyleString, (String)"Cannot take null parameters.");
        return m_sortStylesString.get(sortStyleString.toLowerCase());
    }

    protected String getOrderByClause() {
        String clause = null;
        switch (this) {
            case NODE: {
                clause = " ORDER BY NODELABEL ASC";
                break;
            }
            case REVERSE_NODE: {
                clause = " ORDER BY NODELABEL DESC";
                break;
            }
            case FOREIGNSOURCE: {
                clause = " ORDER BY FOREIGNSOURCE ASC";
                break;
            }
            case REVERSE_FOREIGNSOURCE: {
                clause = " ORDER BY FOREIGNSOURCE DESC";
                break;
            }
            case INTERFACE: {
                clause = " ORDER BY IPADDR ASC";
                break;
            }
            case REVERSE_INTERFACE: {
                clause = " ORDER BY IPADDR DESC";
                break;
            }
            case SERVICE: {
                clause = " ORDER BY SERVICENAME ASC";
                break;
            }
            case REVERSE_SERVICE: {
                clause = " ORDER BY SERVICENAME DESC";
                break;
            }
            case IFLOSTSERVICE: {
                clause = " ORDER BY IFLOSTSERVICE DESC";
                break;
            }
            case REVERSE_IFLOSTSERVICE: {
                clause = " ORDER BY IFLOSTSERVICE ASC";
                break;
            }
            case IFREGAINEDSERVICE: {
                clause = " ORDER BY IFREGAINEDSERVICE DESC";
                break;
            }
            case REVERSE_IFREGAINEDSERVICE: {
                clause = " ORDER BY IFREGAINEDSERVICE ASC";
                break;
            }
            case ID: {
                clause = " ORDER BY OUTAGEID DESC";
                break;
            }
            case REVERSE_ID: {
                clause = " ORDER BY OUTAGEID ASC";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SortStyle: " + (Object)((Object)this));
            }
        }
        return clause;
    }

    static {
        DEFAULT_SORT_STYLE = ID;
        m_sortStylesString = new HashMap<String, SortStyle>();
        for (SortStyle sortStyle : SortStyle.values()) {
            m_sortStylesString.put(sortStyle.getShortName(), sortStyle);
        }
    }
}

