/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.beans.PropertyEditor;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.Duration;
import org.opennms.core.spring.PropertyPath;
import org.opennms.netmgt.provision.persist.ForeignSourceService;
import org.opennms.netmgt.provision.persist.StringIntervalPropertyEditor;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/admin/editForeignSource.htm"})
public class EditForeignSourceController {
    private static final Logger LOG = LoggerFactory.getLogger(EditForeignSourceController.class);
    public static final String COMMAND_NAME = "foreignSourceEditForm";
    @Autowired
    private ForeignSourceService m_foreignSourceService;

    @InitBinder
    public void initBinder(ServletRequestDataBinder binder) {
        binder.registerCustomEditor(Duration.class, (PropertyEditor)new StringIntervalPropertyEditor());
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView onSubmit(@ModelAttribute(value="foreignSourceEditForm") @Valid TreeCommand treeCmd, BindingResult errors) {
        LOG.debug("treeCmd = {}", (Object)treeCmd);
        if (errors.hasErrors()) {
            return new ModelAndView("/admin/editForeignSource", COMMAND_NAME, (Object)treeCmd);
        }
        String action = treeCmd.getAction();
        if (action != null) {
            if ("addDetector".equalsIgnoreCase(action)) {
                this.doAddDetector(treeCmd);
            } else if ("addPolicy".equalsIgnoreCase(action)) {
                this.doAddPolicy(treeCmd);
            } else if ("addParameter".equalsIgnoreCase(action)) {
                this.doAddParameter(treeCmd);
            } else if ("save".equalsIgnoreCase(action)) {
                this.doSave(treeCmd);
            } else if ("edit".equalsIgnoreCase(action)) {
                this.doEdit(treeCmd);
            } else if ("cancel".equalsIgnoreCase(action)) {
                this.doCancel(treeCmd);
            } else if ("delete".equalsIgnoreCase(action)) {
                this.doDelete(treeCmd);
            } else {
                if ("done".equalsIgnoreCase(action)) {
                    return this.done(treeCmd);
                }
                errors.reject("Unrecognized action: " + action);
            }
        }
        return new ModelAndView("/admin/editForeignSource", COMMAND_NAME, (Object)treeCmd);
    }

    private ModelAndView done(TreeCommand treeCmd) {
        this.m_foreignSourceService.saveForeignSource(treeCmd.getForeignSourceName(), treeCmd.getFormData());
        return new ModelAndView("redirect:/admin/provisioningGroups.htm");
    }

    private void doAddDetector(TreeCommand treeCmd) {
        ForeignSource fs = this.m_foreignSourceService.addDetectorToForeignSource(treeCmd.getForeignSourceName(), "New Detector");
        treeCmd.setFormData(fs);
        treeCmd.setCurrentNode(treeCmd.getFormPath() + ".detectors[" + (fs.getDetectors().size() - 1) + "]");
    }

    private void doAddPolicy(TreeCommand treeCmd) {
        ForeignSource fs = this.m_foreignSourceService.addPolicyToForeignSource(treeCmd.getForeignSourceName(), "New Policy");
        treeCmd.setFormData(fs);
        treeCmd.setCurrentNode(treeCmd.getFormPath() + ".policies[" + (fs.getPolicies().size() - 1) + "]");
    }

    private void doAddParameter(TreeCommand treeCmd) {
        ForeignSource fs = this.m_foreignSourceService.addParameter(treeCmd.getForeignSourceName(), treeCmd.getDataPath());
        treeCmd.setFormData(fs);
        PropertyPath path = new PropertyPath(treeCmd.getDataPath());
        PluginConfig obj = (PluginConfig)path.getValue((Object)fs);
        int numParameters = obj.getParameters().size() - 1;
        treeCmd.setCurrentNode(treeCmd.getFormPath() + ".parameters[" + numParameters + "]");
    }

    private void doSave(TreeCommand treeCmd) {
        ForeignSource fs = this.m_foreignSourceService.saveForeignSource(treeCmd.getForeignSourceName(), treeCmd.getFormData());
        treeCmd.setFormData(fs);
        treeCmd.setCurrentNode("");
    }

    private void doEdit(TreeCommand treeCmd) {
        treeCmd.setCurrentNode(treeCmd.getFormPath());
    }

    private void doCancel(TreeCommand treeCmd) {
        ForeignSource fs = this.m_foreignSourceService.getForeignSource(treeCmd.getForeignSourceName());
        treeCmd.setFormData(fs);
        treeCmd.setCurrentNode("");
    }

    private void doDelete(TreeCommand treeCmd) {
        ForeignSource fs = this.m_foreignSourceService.deletePath(treeCmd.getForeignSourceName(), treeCmd.getDataPath());
        treeCmd.setFormData(fs);
    }

    @ModelAttribute(value="foreignSourceEditForm")
    public TreeCommand formBackingObject(@RequestParam String foreignSourceName) {
        TreeCommand formCommand = new TreeCommand();
        if (foreignSourceName == null) {
            throw new IllegalArgumentException("foreignSourceName required");
        }
        ForeignSource fs = this.m_foreignSourceService.getForeignSource(foreignSourceName);
        formCommand.setFormData(fs);
        return formCommand;
    }

    @ModelAttribute
    private void referenceData(ModelMap map) {
        int classFieldWidth = 20;
        int valueFieldWidth = 20;
        Map detectorTypes = this.m_foreignSourceService.getDetectorTypes();
        map.put((Object)"detectorTypes", (Object)detectorTypes);
        for (String key : detectorTypes.keySet()) {
            classFieldWidth = Math.max(classFieldWidth, key.length());
        }
        Map policyTypes = this.m_foreignSourceService.getPolicyTypes();
        map.put((Object)"policyTypes", (Object)policyTypes);
        for (String key : policyTypes.keySet()) {
            classFieldWidth = Math.max(classFieldWidth, key.length());
        }
        map.put((Object)"pluginInfo", (Object)this.m_foreignSourceService.getWrappers());
        map.put((Object)"classFieldWidth", (Object)classFieldWidth);
        map.put((Object)"valueFieldWidth", (Object)20);
    }

    public static class TreeCommand {
        private String m_formPath;
        private String m_action;
        @NotNull
        @Valid
        private ForeignSource m_formData;
        @NotNull
        private String m_currentNode;
        @NotEmpty
        private String m_foreignSourceName = "hardcoded";

        public String getAction() {
            return this.m_action;
        }

        public void setAction(String action) {
            this.m_action = action;
        }

        public String getForeignSourceName() {
            return this.m_foreignSourceName;
        }

        public void setForeignSourceName(String foreignSourceName) {
            this.m_foreignSourceName = foreignSourceName;
        }

        public ForeignSource getFormData() {
            return this.m_formData;
        }

        public void setFormData(ForeignSource importData) {
            this.m_formData = importData;
        }

        public static String getDefaultFormPath() {
            return "foreignSourceEditForm.formData";
        }

        public String getFormPath() {
            return this.m_formPath;
        }

        public void setFormPath(String target) {
            this.m_formPath = target;
        }

        public String getCurrentNode() {
            return this.m_currentNode;
        }

        public void setCurrentNode(String node) {
            this.m_currentNode = node;
        }

        public String getDataPath() {
            return this.m_formPath.substring("foreignSourceEditForm.formData.".length());
        }

        public void setDataPath(String path) {
            this.m_formPath = "foreignSourceEditForm.formData." + path;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("foreign source", (Object)this.m_foreignSourceName).append("form path", (Object)this.m_formPath).append("action", (Object)this.m_action).append("form data", (Object)this.m_formData).append("current node", (Object)this.m_currentNode).toString();
        }
    }
}

