/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.notification.noticeWizard;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.NotifdConfigFactory;
import org.opennms.netmgt.config.NotificationFactory;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.config.notifications.Parameter;
import org.opennms.netmgt.config.notifications.Rule;
import org.opennms.netmgt.config.notifications.Varbind;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.filter.api.FilterParseException;
import org.opennms.web.api.Util;

public class NotificationWizardServlet
extends HttpServlet {
    private static final long serialVersionUID = -5623373180751511103L;
    private static final Pattern SERVICES = Pattern.compile("\\s*\\&\\s*\\(\\s*\\!?is.+");
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final Pattern WHITESPACE_BEGINNING = Pattern.compile("^\\s");
    private static final Pattern WHITESPACE_END = Pattern.compile("\\s$");
    public static final String SOURCE_PAGE_OTHER_WEBUI = "eventslist";
    public static final String SOURCE_PAGE_NOTICES = "eventNotices.htm";
    public static final String SOURCE_PAGE_NOTIFS_FOR_UEI = "notifsForUEI.jsp";
    public static final String SOURCE_PAGE_UEIS = "chooseUeis.htm";
    public static final String SOURCE_PAGE_RULE = "buildRule.jsp";
    public static final String SOURCE_PAGE_VALIDATE = "validateRule.jsp";
    public static final String SOURCE_PAGE_PATH_OUTAGE = "buildPathOutage.jsp";
    public static final String SOURCE_PAGE_VALIDATE_PATH_OUTAGE = "validatePathOutage.jsp";
    public static final String SOURCE_PAGE_PATH = "choosePath.jsp";
    public static final String SOURCE_PAGE_NOTIFICATION_INDEX = "../index.jsp";
    private static final String SQL_DELETE_CRITICAL_PATH = "DELETE FROM pathoutage WHERE nodeid=?";
    private static final String SQL_SET_CRITICAL_PATH = "INSERT INTO pathoutage (nodeid, criticalpathip, criticalpathservicename) VALUES (?, ?, ?)";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sourcePage = request.getParameter("sourcePage");
        HttpSession user = request.getSession(true);
        try {
            NotifdConfigFactory.init();
        }
        catch (Throwable t) {
            throw new ServletException("Failed to initialize NotifdConfigFactory: " + t.getMessage(), t);
        }
        try {
            NotificationFactory.init();
        }
        catch (Throwable t) {
            throw new ServletException("Failed to initialize NotificationFactory: " + t.getMessage(), t);
        }
        if (SOURCE_PAGE_NOTICES.equals(sourcePage)) {
            response.sendRedirect(this.processNotices(request, user));
        } else if (SOURCE_PAGE_UEIS.equals(sourcePage)) {
            response.sendRedirect(this.processUeis(request, user));
        } else if (SOURCE_PAGE_RULE.equals(sourcePage)) {
            response.sendRedirect(this.processRule(request, user));
        } else if (SOURCE_PAGE_VALIDATE.equals(sourcePage)) {
            response.sendRedirect(this.processValidate(request, user));
        } else if (SOURCE_PAGE_PATH.equals(sourcePage)) {
            response.sendRedirect(this.processPath(request, user));
        } else if (SOURCE_PAGE_PATH_OUTAGE.equals(sourcePage)) {
            response.sendRedirect(this.processPathOutage(request));
        } else if (SOURCE_PAGE_VALIDATE_PATH_OUTAGE.equals(sourcePage)) {
            response.sendRedirect(this.processValidatePathOutage(request));
        } else if (SOURCE_PAGE_OTHER_WEBUI.equals(sourcePage)) {
            response.sendRedirect(this.processOtherWebUi(request, user));
        } else if (SOURCE_PAGE_NOTIFS_FOR_UEI.equals(sourcePage)) {
            response.sendRedirect(this.processNotificationsForUei(request, user));
        } else {
            throw new ServletException("no redirect specified for this wizard!");
        }
    }

    private String processNotices(HttpServletRequest request, HttpSession user) throws ServletException {
        String userAction = request.getParameter("userAction");
        if ("delete".equals(userAction)) {
            try {
                this.getNotificationFactory().removeNotification(request.getParameter("notice"));
            }
            catch (Throwable t) {
                throw new ServletException("Couldn't save/reload notifications configuration file: " + t.getMessage(), t);
            }
            return SOURCE_PAGE_NOTICES;
        }
        if ("edit".equals(userAction)) {
            return this.edit(request, user);
        }
        if ("new".equals(userAction)) {
            user.setAttribute("newNotice", (Object)this.buildNewNotification("off"));
            return SOURCE_PAGE_UEIS;
        }
        if ("on".equals(userAction) || "off".equals(userAction)) {
            try {
                this.getNotificationFactory().updateStatus(request.getParameter("notice"), userAction);
            }
            catch (Throwable t) {
                throw new ServletException("Couldn't save/reload notifications configuration file: " + t.getMessage(), t);
            }
            return SOURCE_PAGE_NOTICES;
        }
        return "";
    }

    private String processUeis(HttpServletRequest request, HttpSession user) {
        Notification newNotice = (Notification)user.getAttribute("newNotice");
        newNotice.setUei(request.getParameter("uei"));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("newRule", NotificationWizardServlet.toSingleQuote(newNotice.getRule().getContent()));
        return SOURCE_PAGE_RULE + this.makeQueryString(params);
    }

    private String processValidate(HttpServletRequest request, HttpSession user) {
        String userAction = request.getParameter("userAction");
        if ("rebuild".equals(userAction)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("newRule", request.getParameter("newRule"));
            String[] services = request.getParameterValues("services");
            if (services != null) {
                params.put("services", services);
            }
            params.put("mode", "rebuild");
            return SOURCE_PAGE_RULE + this.makeQueryString(params);
        }
        Notification newNotice = (Notification)user.getAttribute("newNotice");
        Rule rule = new Rule();
        rule.setContent(request.getParameter("newRule"));
        newNotice.setRule(rule);
        return SOURCE_PAGE_PATH;
    }

    private String processRule(HttpServletRequest request, HttpSession user) {
        String[] notServices;
        String ruleString = request.getParameter("newRule");
        ruleString = NotificationWizardServlet.toSingleQuote(ruleString);
        ruleString = NotificationWizardServlet.stripExtraWhite(ruleString);
        ruleString = NotificationWizardServlet.stripServices(ruleString);
        ruleString = NotificationWizardServlet.checkParens(ruleString);
        StringBuffer rule = new StringBuffer(ruleString);
        String[] services = request.getParameterValues("services");
        if (services != null) {
            rule.append(" & ").append(" (");
            for (int i = 0; i < services.length; ++i) {
                rule.append("is").append(services[i]);
                if (i >= services.length - 1) continue;
                rule.append(" | ");
            }
            rule.append(" )");
        }
        if ((notServices = request.getParameterValues("notServices")) != null) {
            rule.append(" & ").append(" (");
            for (int i = 0; i < notServices.length; ++i) {
                rule.append("!is").append(notServices[i]);
                if (i >= notServices.length - 1) continue;
                rule.append(" & ");
            }
            rule.append(" )");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("newRule", rule.toString());
        if (services != null) {
            params.put("services", services);
        }
        if (notServices != null) {
            params.put("notServices", notServices);
        }
        String redirectPage = request.getParameter("nextPage");
        try {
            this.getFilterDao().validateRule(rule.toString());
        }
        catch (FilterParseException e) {
            params.put("mode", "failed");
            redirectPage = SOURCE_PAGE_RULE;
        }
        if (redirectPage.equals(SOURCE_PAGE_PATH)) {
            Notification newNotice = (Notification)user.getAttribute("newNotice");
            Rule filterRule = new Rule();
            filterRule.setContent(rule.toString());
            newNotice.setRule(filterRule);
        }
        return redirectPage + this.makeQueryString(params);
    }

    private String processPath(HttpServletRequest request, HttpSession user) throws ServletException {
        Notification newNotice = (Notification)user.getAttribute("newNotice");
        newNotice.setDestinationPath(request.getParameter("path"));
        String description = request.getParameter("description");
        if (description != null && !description.trim().equals("")) {
            newNotice.setDescription(description);
        } else {
            newNotice.setDescription(null);
        }
        newNotice.setTextMessage(request.getParameter("textMsg"));
        String subject = request.getParameter("subject");
        if (subject != null && !subject.trim().equals("")) {
            newNotice.setSubject(subject);
        } else {
            newNotice.setSubject(null);
        }
        String numMessage = request.getParameter("numMsg");
        if (numMessage != null && !numMessage.trim().equals("")) {
            newNotice.setNumericMessage(numMessage);
        } else {
            newNotice.setNumericMessage(null);
        }
        String oldName = newNotice.getName();
        newNotice.setName(request.getParameter("name"));
        String varbindName = request.getParameter("varbindName");
        String varbindValue = request.getParameter("varbindValue");
        Varbind varbind = newNotice.getVarbind();
        if (varbindName != null && !varbindName.trim().equals("") && varbindValue != null && !varbindValue.trim().equals("")) {
            if (varbind == null) {
                varbind = new Varbind();
                newNotice.setVarbind(varbind);
            }
            varbind.setVbname(varbindName);
            varbind.setVbvalue(varbindValue);
        } else {
            newNotice.setVarbind(null);
        }
        try {
            this.getNotificationFactory().replaceNotification(oldName, newNotice);
        }
        catch (Throwable t) {
            throw new ServletException("Couldn't save/reload notification configuration file.", t);
        }
        String suppliedReturnPage = (String)user.getAttribute("noticeWizardReturnPage");
        if (suppliedReturnPage != null && !"".equals(suppliedReturnPage)) {
            user.removeAttribute("noticeWizardReturnPage");
            return suppliedReturnPage;
        }
        return SOURCE_PAGE_NOTICES;
    }

    private String processPathOutage(HttpServletRequest request) {
        String newRule = request.getParameter("newRule");
        newRule = NotificationWizardServlet.toSingleQuote(newRule);
        newRule = NotificationWizardServlet.stripExtraWhite(newRule);
        newRule = NotificationWizardServlet.stripServices(newRule);
        newRule = NotificationWizardServlet.checkParens(newRule);
        String redirectPage = SOURCE_PAGE_VALIDATE_PATH_OUTAGE;
        String criticalService = request.getParameter("criticalSvc");
        String showNodes = request.getParameter("showNodes");
        String criticalIp = request.getParameter("criticalIp");
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (newRule != null) {
            params.put("newRule", newRule);
        }
        if (criticalService != null) {
            params.put("criticalSvc", criticalService);
        }
        if (showNodes != null) {
            params.put("showNodes", showNodes);
        }
        if (criticalIp != null && !criticalIp.equals("")) {
            params.put("criticalIp", criticalIp);
            try {
                this.getFilterDao().validateRule("IPADDR IPLIKE " + criticalIp);
            }
            catch (FilterParseException e) {
                params.put("mode", "Critical path IP failed");
                redirectPage = SOURCE_PAGE_PATH_OUTAGE;
            }
        }
        try {
            this.getFilterDao().validateRule(newRule);
        }
        catch (FilterParseException e) {
            params.put("mode", "Current rule failed");
            redirectPage = SOURCE_PAGE_PATH_OUTAGE;
        }
        return redirectPage + this.makeQueryString(params);
    }

    private String processValidatePathOutage(HttpServletRequest request) {
        String userAction = request.getParameter("userAction");
        String criticalIp = request.getParameter("criticalIp");
        String criticalSvc = request.getParameter("criticalSvc");
        String newRule = request.getParameter("newRule");
        String redirectPage = SOURCE_PAGE_NOTIFICATION_INDEX;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (userAction != null && userAction.equals("rebuild")) {
            params.put("newRule", newRule);
            params.put("criticalIp", criticalIp);
            params.put("criticalSvc", criticalSvc);
            if (request.getParameter("showNodes") != null) {
                params.put("showNodes", request.getParameter("showNodes"));
            }
            redirectPage = SOURCE_PAGE_PATH_OUTAGE;
        } else {
            try {
                this.updatePaths(newRule, criticalIp, criticalSvc);
            }
            catch (Exception e) {
                params.put("mode", "Update failed");
                redirectPage = SOURCE_PAGE_PATH_OUTAGE;
            }
        }
        return redirectPage + this.makeQueryString(params);
    }

    private String processOtherWebUi(HttpServletRequest request, HttpSession user) throws ServletException {
        user.setAttribute("noticeWizardReturnPage", (Object)request.getParameter("returnPage"));
        String uei = request.getParameter("uei");
        try {
            boolean hasUei = this.getNotificationFactory().hasUei(uei);
            if (hasUei) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("uei", uei);
                return SOURCE_PAGE_NOTIFS_FOR_UEI + this.makeQueryString(params);
            }
            return this.newNotifWithUEI(request, user);
        }
        catch (Exception e) {
            throw new ServletException("Exception while checking if there is an existing notification for UEI " + uei, (Throwable)e);
        }
    }

    private String processNotificationsForUei(HttpServletRequest request, HttpSession user) throws ServletException {
        String userAction = request.getParameter("userAction");
        if ("edit".equals(userAction)) {
            return this.edit(request, user);
        }
        if ("new".equals(userAction)) {
            return this.newNotifWithUEI(request, user);
        }
        return "";
    }

    private String newNotifWithUEI(HttpServletRequest request, HttpSession user) {
        String uei = request.getParameter("uei");
        Notification newNotice = this.buildNewNotification("on");
        newNotice.setUei(uei);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("newRule", NotificationWizardServlet.toSingleQuote(newNotice.getRule().getContent()));
        user.setAttribute("newNotice", (Object)newNotice);
        return SOURCE_PAGE_RULE + this.makeQueryString(params);
    }

    private Notification buildNewNotification(String status) {
        Notification notice = new Notification();
        Rule rule = new Rule();
        rule.setContent("IPADDR IPLIKE *.*.*.*");
        notice.setRule(rule);
        notice.setNumericMessage("111-%noticeid%");
        notice.setSubject("Notice #%noticeid%");
        notice.setStatus(status);
        return notice;
    }

    private String edit(HttpServletRequest request, HttpSession user) throws ServletException {
        try {
            Notification oldNotice = this.getNotificationFactory().getNotification(request.getParameter("notice"));
            user.setAttribute("newNotice", (Object)this.copyNotice(oldNotice));
            return SOURCE_PAGE_UEIS;
        }
        catch (Throwable t) {
            throw new ServletException("couldn't get a copy of the notification to edit.", t);
        }
    }

    private Notification copyNotice(Notification oldNotice) {
        Notification newNotice = new Notification();
        newNotice.setName(oldNotice.getName());
        newNotice.setWriteable(oldNotice.getWriteable());
        newNotice.setDescription(oldNotice.getDescription());
        newNotice.setUei(oldNotice.getUei());
        newNotice.setRule(oldNotice.getRule());
        newNotice.setDestinationPath(oldNotice.getDestinationPath());
        newNotice.setNoticeQueue(oldNotice.getNoticeQueue());
        newNotice.setTextMessage(oldNotice.getTextMessage());
        newNotice.setSubject(oldNotice.getSubject());
        newNotice.setNumericMessage(oldNotice.getNumericMessage());
        newNotice.setStatus(oldNotice.getStatus());
        newNotice.setVarbind(oldNotice.getVarbind());
        for (Parameter parameter : oldNotice.getParameter()) {
            Parameter newParam = new Parameter();
            newParam.setName(parameter.getName());
            newParam.setValue(parameter.getValue());
            newNotice.addParameter(newParam);
        }
        return newNotice;
    }

    private String makeQueryString(Map<String, Object> map) {
        StringBuffer buffer = new StringBuffer();
        String separator = "?";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String[]) {
                String[] list;
                for (String valueEntry : list = (String[])value) {
                    buffer.append(separator).append(key).append("=").append(Util.encode((String)valueEntry));
                    separator = "&";
                }
            } else {
                buffer.append(separator).append(key).append("=").append(Util.encode((String)((String)value)));
            }
            separator = "&";
        }
        return buffer.toString();
    }

    private static String toSingleQuote(String rule) {
        StringBuffer buffer = new StringBuffer(rule);
        for (int i = 0; i < buffer.length(); ++i) {
            if (i < buffer.length() - 5 && buffer.substring(i, i + 6).equals("&quot;")) {
                buffer.replace(i, i + 6, "'");
                continue;
            }
            if (buffer.charAt(i) != '\"') continue;
            buffer.replace(i, i + 1, "'");
        }
        return buffer.toString();
    }

    private static String stripExtraWhite(String s) {
        Matcher matcher1 = WHITESPACE.matcher(s);
        Matcher matcher2 = WHITESPACE_BEGINNING.matcher(matcher1.replaceAll(" "));
        Matcher matcher3 = WHITESPACE_END.matcher(matcher2.replaceAll(""));
        return matcher3.replaceAll("");
    }

    private static String stripServices(String s) {
        return SERVICES.matcher(s).replaceAll("");
    }

    private static String checkParens(String rule) {
        if (rule.length() == 0) {
            return rule;
        }
        if (rule.charAt(0) != '(' || rule.charAt(rule.length() - 1) != ')') {
            return "(" + rule + ")";
        }
        return rule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCriticalPath(int node, Connection conn) throws SQLException {
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            PreparedStatement stmt = conn.prepareStatement(SQL_DELETE_CRITICAL_PATH);
            d.watch((Object)stmt);
            stmt.setInt(1, node);
            stmt.execute();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCriticalPath(int node, String criticalIp, String criticalSvc, Connection conn) throws SQLException {
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            PreparedStatement stmt = conn.prepareStatement(SQL_SET_CRITICAL_PATH);
            d.watch((Object)stmt);
            stmt.setInt(1, node);
            stmt.setString(2, InetAddressUtils.normalize((String)criticalIp));
            stmt.setString(3, criticalSvc);
            stmt.execute();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePaths(String rule, String criticalIp, String criticalSvc) throws FilterParseException, SQLException {
        Connection conn = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass(), new Object[]{conn});
        try {
            SortedMap nodes = this.getFilterDao().getNodeMap(rule);
            for (Map.Entry entry : nodes.entrySet()) {
                int key = (Integer)entry.getKey();
                this.deleteCriticalPath(key, conn);
                if (criticalIp == null || "".equals(criticalIp)) continue;
                this.setCriticalPath(key, criticalIp, criticalSvc, conn);
            }
        }
        finally {
            d.cleanUp();
        }
    }

    private FilterDao getFilterDao() {
        return FilterDaoFactory.getInstance();
    }

    private NotificationFactory getNotificationFactory() {
        return NotificationFactory.getInstance();
    }
}

