/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.web.admin.nodeManagement.SnmpManagedInterface;
import org.opennms.web.servlet.MissingParameterException;

public class SnmpGetInterfacesServlet
extends HttpServlet {
    private static final long serialVersionUID = -5538965497977581230L;
    private static final String INTERFACE_QUERY = "SELECT snmpinterface.nodeid, snmpinterface.snmpifindex, ipinterface.iphostname, ipinterface.issnmpprimary, snmpinterface.snmpifdescr, snmpinterface.snmpiftype, snmpinterface.snmpifname, snmpinterface.snmpifalias, snmpinterface.snmpcollect, snmpinterface.id FROM snmpinterface LEFT JOIN ipinterface ON ipinterface.snmpinterfaceid=snmpinterface.id WHERE snmpinterface.nodeid=?";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession user = request.getSession(true);
        String nodeIdString = request.getParameter("node");
        if (nodeIdString == null) {
            throw new MissingParameterException("node");
        }
        int nodeid = WebSecurityUtils.safeParseInt((String)nodeIdString);
        try {
            user.setAttribute("listInterfacesForNode.snmpselect.jsp", this.getNodeInterfaces(user, nodeid));
        }
        catch (SQLException e) {
            throw new ServletException((Throwable)e);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/snmpselect.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SnmpManagedInterface> getNodeInterfaces(HttpSession userSession, int nodeid) throws SQLException {
        Connection connection = null;
        ArrayList<SnmpManagedInterface> nodeInterfaces = new ArrayList<SnmpManagedInterface>();
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            connection = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)connection);
            PreparedStatement interfaceSelect = connection.prepareStatement(INTERFACE_QUERY);
            d.watch((Object)interfaceSelect);
            interfaceSelect.setInt(1, nodeid);
            ResultSet interfaceSet = interfaceSelect.executeQuery();
            d.watch((Object)interfaceSet);
            if (interfaceSet != null) {
                while (interfaceSet.next()) {
                    SnmpManagedInterface newInterface = new SnmpManagedInterface();
                    nodeInterfaces.add(newInterface);
                    newInterface.setNodeid(interfaceSet.getInt(1));
                    newInterface.setIfIndex(interfaceSet.getInt(2));
                    newInterface.setIpHostname(interfaceSet.getString(3));
                    newInterface.setStatus(interfaceSet.getString(4));
                    newInterface.setIfDescr(interfaceSet.getString(5));
                    newInterface.setIfType(interfaceSet.getInt(6));
                    newInterface.setIfName(interfaceSet.getString(7));
                    newInterface.setIfAlias(interfaceSet.getString(8));
                    newInterface.setCollectFlag(interfaceSet.getString(9));
                    newInterface.setSnmpInterfaceId(interfaceSet.getInt(10));
                }
            }
        }
        finally {
            d.cleanUp();
        }
        Collections.sort(nodeInterfaces);
        return nodeInterfaces;
    }
}

