/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.opennms.dashboard.client.Pageable;

public class Pager
extends Composite {
    private org.gwtbootstrap3.client.ui.Pager m_gwtPager = new org.gwtbootstrap3.client.ui.Pager();
    private Label m_label = new Label();
    private Pageable m_pageable;

    public Pager(Pageable pageable) {
        this.m_pageable = pageable;
        this.m_gwtPager.addPreviousClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Pager.this.adjustPage(-1);
            }
        });
        this.m_gwtPager.addNextClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Pager.this.adjustPage(1);
            }
        });
        this.initWidget((Widget)this.m_gwtPager);
    }

    private void updateLabel() {
        int current = this.m_pageable.getCurrentElement();
        int pageSize = this.m_pageable.getPageSize();
        int total = this.m_pageable.getElementCount();
        int first = current + 1;
        int last = Math.min(current + pageSize, total);
        this.m_label.setText(first + " to " + last + " of " + total);
    }

    private int getPageSize() {
        return Math.max(1, this.m_pageable.getPageSize());
    }

    private int getMaxIndex() {
        int pages = this.m_pageable.getElementCount() / this.getPageSize();
        int extras = this.m_pageable.getElementCount() % this.getPageSize();
        if (extras == 0) {
            return (pages - 1) * this.getPageSize();
        }
        return pages * this.getPageSize();
    }

    private void adjustPage(int direction) {
        int adjustment = direction * this.getPageSize();
        int maxIndex = this.getMaxIndex();
        int newIndex = Math.max(Math.min(this.m_pageable.getCurrentElement() + adjustment, maxIndex), 0);
        this.m_pageable.setCurrentElement(newIndex);
    }

    public void update() {
        this.updateLabel();
    }
}

