/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.services;

import java.net.InetAddress;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.svclayer.support.DefaultPollerService;

public class PollerServiceTest
extends TestCase {
    DefaultPollerService m_pollerService;
    EventProxy m_eventProxy;

    protected void setUp() throws Exception {
        this.m_eventProxy = (EventProxy)EasyMock.createMock(EventProxy.class);
        this.m_pollerService = new DefaultPollerService();
        this.m_pollerService.setEventProxy(this.m_eventProxy);
    }

    public void testPoll() throws EventProxyException {
        int expectedPolldId = 7;
        OnmsServiceType svcType = new OnmsServiceType();
        svcType.setId(Integer.valueOf(3));
        svcType.setName("HTTP");
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        OnmsSnmpInterface snmpIface = new OnmsSnmpInterface(node, 1);
        OnmsIpInterface iface = new OnmsIpInterface("192.168.1.1", node);
        iface.setSnmpInterface(snmpIface);
        final OnmsMonitoredService monSvc = new OnmsMonitoredService(iface, svcType);
        this.m_eventProxy.send((Event)EasyMock.isA(Event.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                Event event = (Event)EasyMock.getCurrentArguments()[0];
                Assert.assertEquals((String)"Incorrect uei for demandPollService event", (String)"uei.opennms.org/internal/demandPollService", (String)event.getUei());
                Assert.assertEquals((String)"Incorrect nodeid for demandPollService event", (long)monSvc.getNodeId().longValue(), (long)event.getNodeid());
                Assert.assertEquals((String)"Incorrect ipadr for demandPollService event", (String)InetAddressUtils.str((InetAddress)monSvc.getIpAddress()), (String)event.getInterface());
                Assert.assertEquals((String)"Incorrect ifIndex for demandPollService event", (Object)monSvc.getIfIndex(), (Object)event.getIfIndex());
                Assert.assertEquals((String)"Incorrect service for demandPollService event", (String)monSvc.getServiceType().getName(), (String)event.getService());
                EventUtils.requireParm((Event)event, (String)"demandPollId");
                Assert.assertEquals((int)7, (int)EventUtils.getIntParm((Event)event, (String)"demandPollId", (int)-1));
                return null;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.m_eventProxy});
        this.m_pollerService.poll(monSvc, 7);
        EasyMock.verify((Object[])new Object[]{this.m_eventProxy});
    }
}

