/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import com.google.common.collect.ImmutableSortedMap;
import java.io.Serializable;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.opennms.netmgt.config.attrsummary.Summary;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.web.controller.RrdSummaryController;
import org.opennms.web.svclayer.model.SummarySpecification;
import org.opennms.web.svclayer.rrd.RrdSummaryService;
import org.opennms.web.svclayer.rrd.support.DefaultRrdSummaryService;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

public class RrdSummaryControllerTest {
    private RrdSummaryController m_controller;
    private DefaultRrdSummaryService m_rrdSummaryService;

    @Before
    public void setUp() {
        this.m_rrdSummaryService = new DefaultRrdSummaryService();
        this.m_controller = new RrdSummaryController();
        this.m_controller.setRrdSummaryService((RrdSummaryService)this.m_rrdSummaryService);
    }

    @Test
    public void canGenerateEmptySummary() {
        String rule = "ipaddr iplike 172.20.1.1";
        FilterDao filterDao = (FilterDao)Mockito.mock(FilterDao.class);
        Mockito.when((Object)filterDao.getNodeMap(rule)).thenReturn((Object)ImmutableSortedMap.of((Comparable)Integer.valueOf(1), (Object)"node1"));
        OnmsNode node = (OnmsNode)Mockito.mock(OnmsNode.class);
        NodeDao nodeDao = (NodeDao)Mockito.mock(NodeDao.class);
        Mockito.when((Object)nodeDao.load((Serializable)Integer.valueOf(1))).thenReturn((Object)node);
        OnmsResource resource = (OnmsResource)Mockito.mock(OnmsResource.class);
        ResourceDao resourceDao = (ResourceDao)Mockito.mock(ResourceDao.class);
        Mockito.when((Object)resourceDao.getResourceForNode(node)).thenReturn((Object)resource);
        this.m_rrdSummaryService.setFilterDao(filterDao);
        this.m_rrdSummaryService.setNodeDao(nodeDao);
        this.m_rrdSummaryService.setResourceDao(resourceDao);
        SummarySpecification summarySpec = new SummarySpecification();
        summarySpec.setFilterRule("ipaddr iplike 172.20.1.1");
        summarySpec.setStartTime(1472746964L);
        summarySpec.setEndTime(1473265364L);
        summarySpec.setAttributeSieve(".*");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ModelAndView mv = this.m_controller.processFormSubmission((HttpServletResponse)response, summarySpec);
        Summary summary = (Summary)mv.getModel().get("summary");
        Assert.assertEquals((long)0L, (long)summary.getResourceCount());
    }
}

