/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm.filter;

import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AlarmRepository;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.alarm.AlarmUtil;
import org.opennms.web.alarm.filter.AfterFirstEventTimeFilter;
import org.opennms.web.alarm.filter.AlarmCriteria;
import org.opennms.web.alarm.filter.AlarmTypeFilter;
import org.opennms.web.alarm.filter.BeforeFirstEventTimeFilter;
import org.opennms.web.alarm.filter.BeforeLastEventTimeFilter;
import org.opennms.web.alarm.filter.DescriptionSubstringFilter;
import org.opennms.web.alarm.filter.EventParmLikeFilter;
import org.opennms.web.alarm.filter.ExactUEIFilter;
import org.opennms.web.alarm.filter.IPAddrLikeFilter;
import org.opennms.web.alarm.filter.InterfaceFilter;
import org.opennms.web.alarm.filter.LogMessageMatchesAnyFilter;
import org.opennms.web.alarm.filter.LogMessageSubstringFilter;
import org.opennms.web.alarm.filter.NegativeAcknowledgedByFilter;
import org.opennms.web.alarm.filter.NegativeEventParmLikeFilter;
import org.opennms.web.alarm.filter.NegativeExactUEIFilter;
import org.opennms.web.alarm.filter.NegativeInterfaceFilter;
import org.opennms.web.alarm.filter.NegativeNodeFilter;
import org.opennms.web.alarm.filter.NegativePartialUEIFilter;
import org.opennms.web.alarm.filter.NegativeServiceFilter;
import org.opennms.web.alarm.filter.NegativeSeverityFilter;
import org.opennms.web.alarm.filter.NodeNameLikeFilter;
import org.opennms.web.alarm.filter.ServiceFilter;
import org.opennms.web.alarm.filter.SeverityBetweenFilter;
import org.opennms.web.filter.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/daoWebRepositoryTestContext.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
@DirtiesContext
public class AlarmRepositoryFilterIT
implements InitializingBean {
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    AlarmRepository m_daoAlarmRepo;
    @Autowired
    ApplicationContext m_appContext;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_dbPopulator.populateDatabase();
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testAlarmTypeFilter() {
        OnmsAlarm[] alarm = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)new AlarmCriteria(new Filter[]{new AlarmTypeFilter(3)})));
        Assert.assertEquals((long)0L, (long)alarm.length);
        alarm = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)new AlarmCriteria(new Filter[]{new AlarmTypeFilter(1)})));
        Assert.assertEquals((long)1L, (long)alarm.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testBeforeFirstEventTimeFilter() {
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)new AlarmCriteria(new Filter[]{new BeforeFirstEventTimeFilter(new Date())})));
        Assert.assertEquals((long)1L, (long)alarms.length);
        alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)new AlarmCriteria(new Filter[]{new BeforeLastEventTimeFilter(new Date())})));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testBeforeLastEventTime() {
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)new AlarmCriteria(new Filter[]{new BeforeLastEventTimeFilter(new Date())})));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testExactUeiFilter() {
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)new AlarmCriteria(new Filter[]{new ExactUEIFilter("test uei")})));
        Assert.assertEquals((long)0L, (long)alarms.length);
        alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)new AlarmCriteria(new Filter[]{new ExactUEIFilter("uei.opennms.org/test")})));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testInterfaceFilter() {
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)new AlarmCriteria(new Filter[]{new InterfaceFilter(InetAddressUtils.addr((String)"192.168.1.1"))})));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testNegativeAcknowledgeByFilter() {
        AlarmCriteria criteria = new AlarmCriteria(new Filter[]{new NegativeAcknowledgedByFilter("non user")});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testIPLikeFilter() {
        AlarmCriteria criteria = new AlarmCriteria(new Filter[]{new IPAddrLikeFilter("192.168.1.1")});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)1L, (long)alarms.length);
        Assert.assertEquals((Object)InetAddressUtils.addr((String)"192.168.1.1"), (Object)alarms[0].getIpAddr());
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testNegativeInterfaceFilter() {
        AlarmCriteria criteria = new AlarmCriteria(new Filter[]{new NegativeInterfaceFilter(InetAddressUtils.addr((String)"192.168.1.101"))});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testNegativeNodeFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new NegativeNodeFilter(11, this.m_appContext)});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)1L, (long)alarms.length);
        NegativeNodeFilter filter = new NegativeNodeFilter(11, this.m_appContext);
        Assert.assertEquals((Object)"node is not 11", (Object)filter.getTextDescription());
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testNegativeExactUeiFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new NegativeExactUEIFilter("uei.opennms.org/bogus")});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testNegativePartialUEIFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new NegativePartialUEIFilter("uei.opennms.org")});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)0L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testNegativeServiceFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new NegativeServiceFilter(12, null)});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testNegativeSeverityFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new NegativeSeverityFilter(OnmsSeverity.CRITICAL)});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testNodeNameLikeFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new NodeNameLikeFilter("mr")});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)0L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testSeverityBetweenFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new SeverityBetweenFilter(OnmsSeverity.CLEARED, OnmsSeverity.MAJOR)});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testServiceFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new ServiceFilter(1, null)});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testAfterFirstEventTime() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new AfterFirstEventTimeFilter(new Date())});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)0L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testDescriptionSubstringFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new DescriptionSubstringFilter("alarm")});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testLogMessageSubstringFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new LogMessageSubstringFilter("this is a test")});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testLogMessageMatchAnyFilter() {
        AlarmCriteria criteria = this.getCriteria(new Filter[]{new LogMessageMatchesAnyFilter("log")});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testParmsLikeFilter() {
        List events = this.m_dbPopulator.getEventDao().findAll();
        Assert.assertNotNull((Object)events);
        OnmsEvent event = (OnmsEvent)events.get(0);
        OnmsDistPoller poller = this.m_dbPopulator.getDistPollerDao().whoami();
        Assert.assertNotNull((Object)poller);
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setUei("uei.opennms.org/vendor/Juniper/traps/jnxVpnIfUp");
        alarm.setLastEvent(event);
        alarm.setSeverityId(Integer.valueOf(3));
        alarm.setDistPoller(poller);
        alarm.setCounter(Integer.valueOf(100));
        alarm.setEventParms("url=http://localhost:8980/opennms/rtc/post/Network+Interfaces(string,text);user=rtc(string,text);passwd=rtc(string,text);catlabel=Network Interfaces(string,text)");
        AlarmDao alarmDao = this.m_dbPopulator.getAlarmDao();
        alarmDao.save((Object)alarm);
        alarmDao.flush();
        OnmsAlarm alarm2 = new OnmsAlarm();
        alarm2.setUei("uei.opennms.org/vendor/Juniper/traps/jnxVpnIfUp");
        alarm2.setLastEvent(event);
        alarm2.setSeverityId(Integer.valueOf(3));
        alarm2.setDistPoller(poller);
        alarm2.setCounter(Integer.valueOf(100));
        alarm2.setEventParms("componentType=serviceElement(string,text);url=http://localhost:8980/opennms/rtc/post/Network+Interfaces(string,text);user=rtcbomb(string,text);passwd=rtc(string,text);catlabel=Network Interfaces(string,text)");
        alarmDao.save((Object)alarm2);
        alarmDao.flush();
        EventParmLikeFilter eventParmFilter = new EventParmLikeFilter("user=rtc");
        Assert.assertEquals((Object)"user=\"rtc\"", (Object)eventParmFilter.getTextDescription());
        AlarmCriteria criteria = new AlarmCriteria(new Filter[]{eventParmFilter});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)1L, (long)alarms.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testParmsNotLikeFilter() {
        List events = this.m_dbPopulator.getEventDao().findAll();
        Assert.assertNotNull((Object)events);
        OnmsEvent event = (OnmsEvent)events.get(0);
        OnmsDistPoller poller = this.m_dbPopulator.getDistPollerDao().whoami();
        Assert.assertNotNull((Object)poller);
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setUei("uei.opennms.org/vendor/Juniper/traps/jnxVpnIfUp");
        alarm.setLastEvent(event);
        alarm.setSeverityId(Integer.valueOf(3));
        alarm.setDistPoller(poller);
        alarm.setCounter(Integer.valueOf(100));
        alarm.setEventParms("componentType=service(string,text);url=http://localhost:8980/opennms/rtc/post/Network+Interfaces(string,text);user=rtc(string,text);passwd=rtc(string,text);catlabel=Network Interfaces(string,text)");
        AlarmDao alarmDao = this.m_dbPopulator.getAlarmDao();
        alarmDao.save((Object)alarm);
        alarmDao.flush();
        OnmsAlarm alarm2 = new OnmsAlarm();
        alarm2.setUei("uei.opennms.org/vendor/Juniper/traps/jnxVpnIfUp");
        alarm2.setLastEvent(event);
        alarm2.setSeverityId(Integer.valueOf(3));
        alarm2.setDistPoller(poller);
        alarm2.setCounter(Integer.valueOf(100));
        alarm2.setEventParms("componentType=serviceElement(string,text);url=http://localhost:8980/opennms/rtc/post/Network+Interfaces(string,text);user=admin(string,text);passwd=rtc(string,text);catlabel=Network Interfaces(string,text)");
        alarmDao.save((Object)alarm2);
        alarmDao.flush();
        NegativeEventParmLikeFilter parmFilter = new NegativeEventParmLikeFilter("user=rtc");
        Assert.assertEquals((Object)"user is not \"rtc\"", (Object)parmFilter.getTextDescription());
        AlarmCriteria criteria = new AlarmCriteria(new Filter[]{parmFilter});
        OnmsAlarm[] alarms = this.m_daoAlarmRepo.getMatchingAlarms(AlarmUtil.getOnmsCriteria((AlarmCriteria)criteria));
        Assert.assertEquals((long)2L, (long)alarms.length);
    }

    private AlarmCriteria getCriteria(Filter ... filters) {
        return new AlarmCriteria(filters);
    }
}

