/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.server;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.dashboard.client.NodeRtc;
import org.opennms.dashboard.client.SurveillanceService;
import org.opennms.dashboard.client.SurveillanceSet;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath*:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:org/opennms/dashboard/applicationContext-svclayer-dashboard-test.xml", "classpath:/META-INF/opennms/applicationContext-insertData-enabled.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class DefaultSurveillanceServiceIntegrationIT
implements InitializingBean {
    @Autowired
    private SurveillanceService m_gwtSurveillanceService;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        SecurityContextHolder.clearContext();
    }

    @Test
    public void testGetRtcForSet() {
        DefaultSurveillanceServiceIntegrationIT.populateSecurityContext();
        NodeRtc[] rtcs = this.m_gwtSurveillanceService.getRtcForSet(SurveillanceSet.DEFAULT);
        Assert.assertNotNull((String)"rtcs should not be null", (Object)rtcs);
    }

    private static UserDetails populateSecurityContext() {
        User details = new User("user", "password", true, true, true, true, new ArrayList());
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)details, null, details.getAuthorities());
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        return details;
    }
}

