/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gwt.web.ui.asset;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.gwt.web.ui.asset.CommandBeanMockup;
import org.opennms.gwt.web.ui.asset.server.AssetServiceImpl;
import org.opennms.gwt.web.ui.asset.shared.AssetCommand;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.AssetRecordDao;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-mockDao.xml", "classpath*:/META-INF/opennms/component-dao.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class AssetServiceImplIT
implements InitializingBean {
    @Autowired
    private DistPollerDao m_distPollerDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private AssetRecordDao m_assetRecordDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;
    private final GrantedAuthority ROLE_ADMIN = new SimpleGrantedAuthority("ROLE_ADMIN");
    private final String USERNAME = "opennms";
    private final String PASS = "r0c|<Z";
    private User validAdmin;
    private Authentication m_auth;
    private SecurityContext m_context;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_databasePopulator.populateDatabase();
        this.m_context = new SecurityContextImpl();
        this.validAdmin = new User("opennms", "r0c|<Z", true, true, true, true, Arrays.asList(this.ROLE_ADMIN));
        this.m_auth = new PreAuthenticatedAuthenticationToken((Object)this.validAdmin, new Object());
        this.m_context.setAuthentication(this.m_auth);
        SecurityContextHolder.setContext((SecurityContext)this.m_context);
    }

    @After
    public void tearDown() {
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        this.m_nodeDao.flush();
    }

    @Test
    public void testCreateAndGets() {
        OnmsNode onmsNode = new OnmsNode("myNode");
        this.m_nodeDao.save((Object)onmsNode);
        OnmsAssetRecord assetRecord = onmsNode.getAssetRecord();
        assetRecord.setAssetNumber("imported-id: 7");
        this.m_assetRecordDao.update((Object)assetRecord);
        this.m_assetRecordDao.flush();
        List assetRecords = this.m_assetRecordDao.findAll();
        Assert.assertEquals((long)7L, (long)assetRecords.size());
        Assert.assertEquals((long)7L, (long)this.m_assetRecordDao.countAll());
    }

    @Test
    public void testAssetServiceImpl() {
        OnmsNode onmsNode = new OnmsNode("myNode");
        this.m_nodeDao.save((Object)onmsNode);
        OnmsAssetRecord assetRecord = onmsNode.getAssetRecord();
        assetRecord.setAssetNumber("imported-id: " + onmsNode.getId());
        assetRecord.setAdmin("supermario");
        assetRecord.getGeolocation().setAddress1("my address");
        assetRecord.getGeolocation().setZip("myzip");
        this.m_assetRecordDao.update((Object)assetRecord);
        this.m_assetRecordDao.flush();
        onmsNode = new OnmsNode("myNode2");
        this.m_nodeDao.save((Object)onmsNode);
        assetRecord = onmsNode.getAssetRecord();
        assetRecord.setAssetNumber("imported-id: 23");
        assetRecord.setAdmin("mediummario");
        assetRecord.getGeolocation().setAddress1("youraddress");
        assetRecord.getGeolocation().setZip("yourzip");
        this.m_assetRecordDao.update((Object)assetRecord);
        this.m_assetRecordDao.flush();
        AssetServiceImpl assetServiceImpl = new AssetServiceImpl();
        assetServiceImpl.setNodeDao(this.m_nodeDao);
        assetServiceImpl.setAssetRecordDao(this.m_assetRecordDao);
        System.out.println("AssetCommand: " + assetServiceImpl.getAssetByNodeId(onmsNode.getId().intValue()).toString());
        System.out.println("Suggestions: " + assetServiceImpl.getAssetSuggestions());
        Assert.assertTrue((String)"Test save or update by admin.", (boolean)assetServiceImpl.getAssetByNodeId(onmsNode.getId().intValue()).getAllowModify());
    }

    @Test
    public void testSaveOrUpdate() {
        OnmsNode onmsNode = new OnmsNode("myNode");
        this.m_nodeDao.save((Object)onmsNode);
        OnmsAssetRecord assetRecord = onmsNode.getAssetRecord();
        assetRecord.setAssetNumber("imported-id: " + onmsNode.getId());
        assetRecord.setAdmin("supermario");
        assetRecord.setLastModifiedDate(new Date());
        assetRecord.getGeolocation().setAddress1("220 Chatham Business Drive");
        assetRecord.getGeolocation().setCity("Pittsboro");
        assetRecord.getGeolocation().setState("NC");
        assetRecord.getGeolocation().setZip("27312");
        assetRecord.getGeolocation().setCountry("US");
        assetRecord.getGeolocation().setLatitude(Float.valueOf(35.717583f));
        assetRecord.getGeolocation().setLongitude(Float.valueOf(-79.1618f));
        this.m_assetRecordDao.update((Object)assetRecord);
        this.m_assetRecordDao.flush();
        AssetCommand assetCommand = new AssetCommand();
        org.springframework.beans.BeanUtils.copyProperties((Object)assetRecord, (Object)assetCommand);
        System.out.println("AssetCommand (Source): " + assetCommand);
        System.out.println("Asset to Save (Target): " + assetRecord);
        AssetServiceImpl assetServiceImpl = new AssetServiceImpl();
        assetServiceImpl.setNodeDao(this.m_nodeDao);
        assetServiceImpl.setAssetRecordDao(this.m_assetRecordDao);
        System.out.println();
        Assert.assertTrue((boolean)assetServiceImpl.saveOrUpdateAssetByNodeId(onmsNode.getId().intValue(), assetCommand));
        OnmsAssetRecord updated = (OnmsAssetRecord)this.m_assetRecordDao.get((Serializable)assetRecord.getId());
        Assert.assertEquals((Object)assetRecord.getGeolocation().getAddress1(), (Object)updated.getGeolocation().getAddress1());
        Assert.assertEquals((Object)assetRecord.getGeolocation().getState(), (Object)updated.getGeolocation().getState());
        Assert.assertEquals((Object)assetRecord.getGeolocation().getCity(), (Object)updated.getGeolocation().getCity());
        Assert.assertEquals((Object)assetRecord.getGeolocation().getZip(), (Object)updated.getGeolocation().getZip());
        Assert.assertEquals((Object)assetRecord.getGeolocation().getCountry(), (Object)updated.getGeolocation().getCountry());
        Assert.assertEquals((Object)assetRecord.getGeolocation().getLongitude(), (Object)updated.getGeolocation().getLongitude());
        Assert.assertEquals((Object)assetRecord.getGeolocation().getLatitude(), (Object)updated.getGeolocation().getLatitude());
    }

    @Test
    public void testAssetSuggestion() {
        OnmsNode onmsNode = new OnmsNode("your Node");
        onmsNode.setSysObjectId("mySysOid");
        this.m_nodeDao.save((Object)onmsNode);
        OnmsAssetRecord assetRecord = onmsNode.getAssetRecord();
        assetRecord.setAssetNumber("imported-id: 666");
        assetRecord.setAdmin("medium mario");
        assetRecord.setLastModifiedDate(new Date());
        assetRecord.getGeolocation().setZip("his zip");
        this.m_assetRecordDao.update((Object)assetRecord);
        this.m_assetRecordDao.flush();
        onmsNode = new OnmsNode("his Node");
        this.m_nodeDao.save((Object)onmsNode);
        assetRecord = onmsNode.getAssetRecord();
        assetRecord.setAssetNumber("imported-id: 999");
        assetRecord.setAdmin("super mario");
        assetRecord.setLastModifiedDate(new Date());
        assetRecord.getGeolocation().setZip("your zip");
        this.m_assetRecordDao.update((Object)assetRecord);
        this.m_assetRecordDao.flush();
        AssetServiceImpl assetServiceImpl = new AssetServiceImpl();
        assetServiceImpl.setNodeDao(this.m_nodeDao);
        assetServiceImpl.setAssetRecordDao(this.m_assetRecordDao);
        System.out.println("Asset: " + assetServiceImpl.getAssetByNodeId(onmsNode.getId().intValue()));
    }

    @Test
    public void testBasicBeanSanitizer() {
        CommandBeanMockup bean = new CommandBeanMockup();
        bean = (CommandBeanMockup)AssetServiceImpl.sanitizeBeanStringProperties((Object)bean, null);
        Assert.assertTrue((String)"Script property is sanitized", (boolean)WebSecurityUtils.sanitizeString((String)"<script>foo</script>", (boolean)false).equals(bean.getScript()));
        Assert.assertTrue((String)"Script property is not sanitized with Html allowed", (!WebSecurityUtils.sanitizeString((String)"<script>foo</script>", (boolean)true).equals(bean.getScript()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"HtmlTable is sanitized and html removed", (boolean)WebSecurityUtils.sanitizeString((String)"<table>", (boolean)false).equals(bean.getHtmlTable()));
        Assert.assertTrue((String)"Not, HtmlTable is sanitized with Html allowed", (!WebSecurityUtils.sanitizeString((String)"<table>", (boolean)true).equals(bean.getHtmlTable()) ? 1 : 0) != 0);
    }

    @Test
    public void testBeanSanitizerWithHtmlAllowList() {
        CommandBeanMockup bean = new CommandBeanMockup();
        HashSet<String> set = new HashSet<String>();
        set.add("htmltable");
        bean = (CommandBeanMockup)AssetServiceImpl.sanitizeBeanStringProperties((Object)bean, set);
        Assert.assertTrue((String)"Script property is sanitized no Html allowed", (boolean)WebSecurityUtils.sanitizeString((String)"<script>foo</script>", (boolean)false).equals(bean.getScript()));
        Assert.assertTrue((String)"Not, Script property is sanitized with Html allowed", (!WebSecurityUtils.sanitizeString((String)"<script>foo</script>", (boolean)true).equals(bean.getScript()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"HtmlTable is sanitzied with Html allowed so, no changes", (boolean)WebSecurityUtils.sanitizeString((String)"<table>", (boolean)true).equals(bean.getHtmlTable()));
        Assert.assertTrue((String)"Not, HtmlTable is sanitized and html removed", (!WebSecurityUtils.sanitizeString((String)"<table>", (boolean)false).equals(bean.getHtmlTable()) ? 1 : 0) != 0);
    }
}

