/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage.filter;

import org.opennms.web.filter.Filter;
import org.opennms.web.outage.OutageType;
import org.opennms.web.outage.SortStyle;

public class OutageCriteria {
    Filter[] m_filters = null;
    SortStyle m_sortStyle = SortStyle.DEFAULT_SORT_STYLE;
    OutageType m_outageType = OutageType.CURRENT;
    String m_groupBy = null;
    int m_limit = -1;
    int m_offset = -1;

    public OutageCriteria(Filter ... filters) {
        this(filters, null, null, -1, -1);
    }

    public OutageCriteria(OutageType outageType, Filter[] filters) {
        this(filters, null, outageType, -1, -1);
    }

    public OutageCriteria(Filter[] filters, SortStyle sortStyle, OutageType outageType, int limit, int offset) {
        this.m_filters = filters;
        this.m_sortStyle = sortStyle;
        this.m_outageType = outageType;
        this.m_limit = limit;
        this.m_offset = offset;
    }

    public <E extends Exception> void visit(OutageCriteriaVisitor<E> visitor) throws E {
        if (this.m_outageType != null) {
            visitor.visitOutageType(this.m_outageType);
        }
        for (Filter filter : this.m_filters) {
            visitor.visitFilter(filter);
        }
        visitor.visitGroupBy();
        if (this.m_sortStyle != null) {
            visitor.visitSortStyle(this.m_sortStyle);
        }
        if (this.m_limit > 0 && this.m_offset > -1) {
            visitor.visitLimit(this.m_limit, this.m_offset);
        }
    }

    public static class BaseOutageCriteriaVisitor<E extends Exception>
    implements OutageCriteriaVisitor<E> {
        @Override
        public void visitOutageType(OutageType ackType) throws E {
        }

        @Override
        public void visitFilter(Filter filter) throws E {
        }

        @Override
        public void visitLimit(int limit, int offset) throws E {
        }

        @Override
        public void visitGroupBy() throws E {
        }

        @Override
        public void visitSortStyle(SortStyle sortStyle) throws E {
        }
    }

    public static interface OutageCriteriaVisitor<E extends Exception> {
        public void visitOutageType(OutageType var1) throws E;

        public void visitFilter(Filter var1) throws E;

        public void visitSortStyle(SortStyle var1) throws E;

        public void visitGroupBy() throws E;

        public void visitLimit(int var1, int var2) throws E;
    }
}

