/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gwt.web.ui.asset.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.gwt.web.ui.asset.client.AssetService;
import org.opennms.gwt.web.ui.asset.shared.AssetCommand;
import org.opennms.gwt.web.ui.asset.shared.AssetSuggCommand;
import org.opennms.netmgt.dao.api.AssetRecordDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.api.SecurityContextService;
import org.opennms.web.springframework.security.SpringSecurityContextService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=false)
public class AssetServiceImpl
extends RemoteServiceServlet
implements AssetService {
    private static final long serialVersionUID = -6571388103047893262L;
    private static final String[] WRITE_AUTHORIZED_ROLES = new String[]{"ROLE_ADMIN", "ROLE_PROVISION", "ROLE_ASSET_EDITOR"};
    private static final String AUTOENABLE = "A";
    private static final String SSH_CONNECTION = "ssh";
    private static final String TELNET_CONNECTION = "telnet";
    private static final String RSH_CONNECTION = "rsh";
    private static List<String> s_autoenableOptions = new ArrayList<String>();
    private static List<String> s_connectionOptions = new ArrayList<String>();
    private static final Logger logger;
    private AssetRecordDao m_assetRecordDao;
    private NodeDao m_nodeDao;
    private OnmsNode m_onmsNode;
    private OnmsAssetRecord m_onmsAssetRecord;
    private SecurityContextService m_securityContext = new SpringSecurityContextService();
    private Set<String> m_allowHtmlFields = new HashSet<String>();

    public static <T> T sanitizeBeanStringProperties(T bean, Set<String> allowHtmlFields) {
        PropertyDescriptor[] descriptions;
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(bean.getClass());
        for (PropertyDescriptor description : descriptions = beanWrapper.getPropertyDescriptors()) {
            if (!description.getReadMethod().getReturnType().equals(String.class)) continue;
            try {
                boolean allowHTML = false;
                if (allowHtmlFields != null && allowHtmlFields.contains(description.getName().toLowerCase())) {
                    allowHTML = true;
                }
                logger.debug("Try to sanitize string {} in {} with html {}", new Object[]{description.getName(), bean.getClass(), allowHTML});
                description.getWriteMethod().invoke(bean, WebSecurityUtils.sanitizeString((String)((String)description.getReadMethod().invoke(bean, new Object[0])), (boolean)allowHTML));
            }
            catch (IllegalArgumentException e) {
                logger.error("Illegal argument by sanitize object {} on property {}. Error {}", new Object[]{description.getName(), bean.getClass(), e.getMessage()});
            }
            catch (IllegalAccessException e) {
                logger.error("Illegal access by sanitize object {} on property {}. Error {}", new Object[]{description.getName(), bean.getClass(), e.getMessage()});
            }
            catch (InvocationTargetException e) {
                logger.error("Invocation target exception by sanitize object {} on property {}. Error {}", new Object[]{description.getName(), bean.getClass(), e.getMessage()});
            }
        }
        return bean;
    }

    public AssetServiceImpl() {
        String allowHtmlFieldNames = System.getProperty("opennms.assets.allowHtmlFields");
        if (allowHtmlFieldNames != null) {
            for (String fieldName : allowHtmlFieldNames.split("\\s*,\\s*")) {
                this.m_allowHtmlFields.add(fieldName.toLowerCase());
            }
        }
    }

    @Override
    public AssetCommand getAssetByNodeId(int nodeId) {
        AssetCommand assetCommand = new AssetCommand();
        this.m_onmsNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        this.m_onmsAssetRecord = this.m_onmsNode.getAssetRecord();
        logger.debug("onmsAssetRecord '{}'", (Object)this.m_onmsAssetRecord);
        BeanUtils.copyProperties((Object)this.m_onmsAssetRecord, (Object)assetCommand);
        if (assetCommand.getConnection() == null) {
            assetCommand.setConnection("");
        }
        if (assetCommand.getAutoenable() == null) {
            assetCommand.setAutoenable("");
        }
        assetCommand.setSnmpSysContact(this.m_onmsNode.getSysContact());
        assetCommand.setSnmpSysDescription(this.m_onmsNode.getSysDescription());
        assetCommand.setSnmpSysLocation(this.m_onmsNode.getSysLocation());
        assetCommand.setSnmpSysName(this.m_onmsNode.getSysName());
        assetCommand.setSnmpSysObjectId(this.m_onmsNode.getSysObjectId());
        assetCommand.setAutoenableOptions(s_autoenableOptions);
        assetCommand.setConnectionOptions(s_connectionOptions);
        assetCommand.setNodeId(this.m_onmsNode.getNodeId());
        assetCommand.setNodeLabel(this.m_onmsNode.getLabel());
        assetCommand.setLoggedInUser(this.m_securityContext.getUsername());
        if (this.isWriteAuthorized()) {
            assetCommand.setAllowModify(true);
        } else {
            assetCommand.setAllowModify(false);
        }
        this.m_onmsAssetRecord.setNode(this.m_onmsNode);
        logger.debug("assetCommand: '{}'", (Object)assetCommand);
        return assetCommand;
    }

    private boolean isWriteAuthorized() {
        for (String role : WRITE_AUTHORIZED_ROLES) {
            if (!this.m_securityContext.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AssetSuggCommand getAssetSuggestions() {
        AssetSuggCommand suggestion = new AssetSuggCommand();
        List distinctAssetProperties = this.m_assetRecordDao.getDistinctProperties();
        for (OnmsAssetRecord asset : distinctAssetProperties) {
            suggestion.addAdditionalhardware(asset.getAdditionalhardware());
            OnmsGeolocation geolocation = asset.getGeolocation();
            suggestion.addAddress1(geolocation.getAddress1());
            suggestion.addAddress2(geolocation.getAddress2());
            suggestion.addAdmin(asset.getAdmin());
            suggestion.addBuilding(asset.getBuilding());
            suggestion.addCategory(asset.getCategory());
            suggestion.addCircuitId(asset.getCircuitId());
            suggestion.addCity(geolocation.getCity());
            suggestion.addCountry(geolocation.getCountry());
            suggestion.addCpu(asset.getCpu());
            suggestion.addDepartment(asset.getDepartment());
            suggestion.addDescription(asset.getDescription());
            suggestion.addDisplayCategory(asset.getDisplayCategory());
            suggestion.addDivision(asset.getDivision());
            suggestion.addFloor(asset.getFloor());
            suggestion.addHdd1(asset.getHdd1());
            suggestion.addHdd2(asset.getHdd2());
            suggestion.addHdd3(asset.getHdd3());
            suggestion.addHdd4(asset.getHdd4());
            suggestion.addHdd5(asset.getHdd5());
            suggestion.addHdd6(asset.getHdd6());
            suggestion.addInputpower(asset.getInputpower());
            suggestion.addLease(asset.getLease());
            suggestion.addMaintcontract(asset.getMaintcontract());
            suggestion.addManufacturer(asset.getManufacturer());
            suggestion.addModelNumber(asset.getModelNumber());
            suggestion.addNotifyCategory(asset.getNotifyCategory());
            suggestion.addNumpowersupplies(asset.getNumpowersupplies());
            suggestion.addOperatingSystem(asset.getOperatingSystem());
            suggestion.addPollerCategory(asset.getPollerCategory());
            suggestion.addRack(asset.getRack());
            suggestion.addRam(asset.getRam());
            suggestion.addRegion(asset.getRegion());
            suggestion.addRoom(asset.getRoom());
            suggestion.addSnmpcommunity(asset.getSnmpcommunity());
            suggestion.addState(geolocation.getState());
            suggestion.addStoragectrl(asset.getStoragectrl());
            suggestion.addSupportPhone(asset.getSupportPhone());
            suggestion.addThresholdCategory(asset.getThresholdCategory());
            suggestion.addVendor(asset.getVendor());
            suggestion.addVendorFax(asset.getVendorFax());
            suggestion.addVendorPhone(asset.getVendorPhone());
            suggestion.addZip(geolocation.getZip());
            suggestion.addVmwareManagedObjectId(asset.getVmwareManagedObjectId());
            suggestion.addVmwareManagedEntityType(asset.getVmwareManagedEntityType());
            suggestion.addVmwareManagementServer(asset.getVmwareManagementServer());
            suggestion.addVmwareTopologyInfo(asset.getVmwareTopologyInfo());
            suggestion.addVmwareState(geolocation.getState());
        }
        return suggestion;
    }

    @Override
    public Boolean saveOrUpdateAssetByNodeId(int nodeId, AssetCommand assetCommand) {
        logger.debug("nodeId: '{}' assetCommand: '{}'", (Object)nodeId, (Object)assetCommand);
        Boolean isSaved = false;
        this.m_onmsNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        this.m_onmsAssetRecord = this.m_onmsNode.getAssetRecord();
        OnmsGeolocation geolocation = this.m_onmsAssetRecord.getGeolocation();
        logger.debug("gelocation before: {}", (Object)geolocation);
        AssetCommand sanitizeBeanStringProperties = AssetServiceImpl.sanitizeBeanStringProperties(assetCommand, this.m_allowHtmlFields);
        BeanUtils.copyProperties((Object)sanitizeBeanStringProperties, (Object)this.m_onmsAssetRecord);
        geolocation = this.m_onmsAssetRecord.getGeolocation();
        logger.debug("gelocation after: {}", (Object)geolocation);
        if (geolocation == null) {
            geolocation = new OnmsGeolocation();
            this.m_onmsAssetRecord.setGeolocation(geolocation);
        }
        geolocation.setLongitude(sanitizeBeanStringProperties.getLongitude());
        geolocation.setLatitude(sanitizeBeanStringProperties.getLatitude());
        logger.debug("OnmsAssetRecord: '{}'", (Object)this.m_onmsAssetRecord);
        this.m_onmsAssetRecord.setLastModifiedBy(this.m_securityContext.getUsername());
        this.m_onmsAssetRecord.setLastModifiedDate(new Date());
        this.m_onmsAssetRecord.setNode(this.m_onmsNode);
        try {
            logger.debug("OnmsNode '{}'", (Object)this.m_onmsNode.toString());
            logger.debug("AssetRecordDao to update '{}'", (Object)this.m_assetRecordDao.toString());
            logger.debug("OnmsAssetRecord to update '{}'", (Object)this.m_onmsAssetRecord.toString());
            this.m_assetRecordDao.saveOrUpdate((Object)this.m_onmsAssetRecord);
            isSaved = true;
        }
        catch (Exception e) {
            isSaved = false;
            logger.error("Problem during saving or updating assets '{}'", (Object)e.getMessage());
            e.printStackTrace();
        }
        return isSaved;
    }

    public AssetRecordDao getAssetRecordDao() {
        return this.m_assetRecordDao;
    }

    public void setAssetRecordDao(AssetRecordDao assetRecordDao) {
        this.m_assetRecordDao = assetRecordDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    static {
        s_autoenableOptions.add(AUTOENABLE);
        s_autoenableOptions.add("");
        s_connectionOptions.add(TELNET_CONNECTION);
        s_connectionOptions.add(SSH_CONNECTION);
        s_connectionOptions.add(RSH_CONNECTION);
        s_connectionOptions.add("");
        logger = LoggerFactory.getLogger(AssetServiceImpl.class);
    }
}

