/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gwt.web.ui.asset.client.tools.fieldsets;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.Tooltip;
import org.gwtbootstrap3.client.ui.constants.ColumnSize;
import org.gwtbootstrap3.client.ui.constants.FormType;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.opennms.gwt.web.ui.asset.client.tools.fieldsets.FieldSet;
import org.opennms.gwt.web.ui.asset.client.tools.validation.Validator;

public abstract class AbstractFieldSet
extends Composite
implements FieldSet {
    protected Form form = new Form();
    protected FlowPanel panel = new FlowPanel();
    protected FormGroup formGroup = new FormGroup();
    protected Tooltip tooltip = new Tooltip();
    protected FormLabel label = new FormLabel();
    protected Boolean enabled = true;
    protected Boolean changed = false;
    protected FormLabel errorLabel = new FormLabel();
    protected FormLabel warningLabel = new FormLabel();
    protected String helpText = "";
    protected List<Validator> errorValidators = new ArrayList<Validator>();
    protected List<Validator> warningValidators = new ArrayList<Validator>();
    protected Object inititalValue;

    public AbstractFieldSet(String name, String helpText) {
        this.label.setText(name);
        this.label.addStyleName(ColumnSize.MD_3.getCssName());
        this.helpText = helpText;
        if (helpText != null && !helpText.equals("")) {
            this.tooltip.setPlacement(Placement.RIGHT);
            this.tooltip.setText(helpText);
            this.tooltip.add((Widget)this.label);
            this.formGroup.add((IsWidget)this.tooltip);
        } else {
            this.formGroup.add((Widget)this.label);
        }
        this.panel.addStyleName(ColumnSize.MD_9.getCssName());
        this.formGroup.add((Widget)this.panel);
        this.errorLabel.setVisible(false);
        this.errorLabel.setText(null);
        this.warningLabel.setVisible(false);
        this.warningLabel.setText(null);
        this.form.setType(FormType.HORIZONTAL);
        this.form.add((Widget)this.formGroup);
        this.initWidget((Widget)this.form);
    }

    public void addErrorValidator(Validator validator) {
        this.errorValidators.add(validator);
    }

    public void addWarningValidator(Validator validator) {
        this.warningValidators.add(validator);
    }

    public boolean checkField() {
        if (this.getValue() != null) {
            if (!this.getValue().equals(this.inititalValue)) {
                this.form.setStyleName("has-success", true);
                this.changed = true;
                this.validate(this.getValue());
                return true;
            }
            if (this.getError() != "") {
                this.validate(this.getValue());
            }
        }
        this.form.setStyleName("has-success", false);
        this.changed = false;
        return false;
    }

    @Override
    public void clearChanged() {
        this.changed = false;
        this.form.setStyleName("has-success", false);
    }

    @Override
    public void clearErrors() {
        this.errorLabel.setText(null);
        this.form.setStyleName("has-error", false);
    }

    public void clearErrorValidators() {
        this.errorValidators.clear();
    }

    @Override
    public void clearWarnings() {
        this.warningLabel.setText(null);
        this.form.setStyleName("has-warning", false);
    }

    public void clearWarningValidators() {
        this.warningValidators.clear();
    }

    @Override
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public String getError() {
        return this.errorLabel.getText();
    }

    public List<Validator> getErrorValidators() {
        return this.errorValidators;
    }

    @Override
    public String getLabel() {
        return this.label.getText();
    }

    @Override
    public String getWarning() {
        return this.warningLabel.getText();
    }

    public void onChange(ChangeEvent event) {
        this.checkField();
    }

    public void onFocus(FocusEvent event) {
    }

    @Override
    public void setError(String error) {
        this.errorLabel.setText(error);
        this.errorLabel.setVisible(true);
        this.form.setStyleName("has-error", true);
    }

    public void setErrors(List<String> errors) {
        String allErrors = "";
        for (String error : errors) {
            allErrors = allErrors + error + " ";
        }
        this.errorLabel.setText(allErrors);
        this.errorLabel.setVisible(true);
        this.form.setStyleName("has-error", true);
    }

    public void setErrorValidators(List<Validator> validators) {
        this.errorValidators = validators;
    }

    @Override
    public void setLabel(String lable) {
        this.label.setText(lable);
    }

    @Override
    public void setWarning(String warning) {
        this.warningLabel.setText(warning);
        this.warningLabel.setVisible(true);
        this.form.setStyleName("has-warning", true);
    }

    public void setWarnings(List<String> warnings) {
        String allWarnings = "";
        for (String warning : warnings) {
            allWarnings = allWarnings + warning + " ";
        }
        this.warningLabel.setText(allWarnings);
        this.warningLabel.setVisible(true);
        this.form.setStyleName("has-warning", true);
    }

    public void setWarningValidators(List<Validator> validators) {
        this.warningValidators = validators;
    }

    protected void validate(Object object) {
        ArrayList<String> errors = new ArrayList<String>();
        for (Validator validator2 : this.errorValidators) {
            Validator validator = validator2;
            if (validator.validate(object).length() <= 0) continue;
            errors.add(validator.validate(object));
        }
        if (errors.size() > 0) {
            this.setErrors(errors);
        } else {
            this.clearErrors();
        }
        ArrayList<String> warnings = new ArrayList<String>();
        for (Validator validator2 : this.warningValidators) {
            Validator validator = validator2;
            if (validator.validate(object).length() <= 0) continue;
            warnings.add(validator.validate(object));
        }
        if (warnings.size() > 0) {
            this.setWarnings(warnings);
        } else {
            this.clearWarnings();
        }
    }
}

