/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage.filter;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.filter.Filter;
import org.opennms.web.outage.Outage;
import org.opennms.web.outage.WebOutageRepository;
import org.opennms.web.outage.filter.InterfaceFilter;
import org.opennms.web.outage.filter.LostServiceDateAfterFilter;
import org.opennms.web.outage.filter.LostServiceDateBeforeFilter;
import org.opennms.web.outage.filter.NegativeInterfaceFilter;
import org.opennms.web.outage.filter.NegativeServiceFilter;
import org.opennms.web.outage.filter.OutageCriteria;
import org.opennms.web.outage.filter.OutageIdFilter;
import org.opennms.web.outage.filter.RecentOutagesFilter;
import org.opennms.web.outage.filter.RegainedServiceDateAfterFilter;
import org.opennms.web.outage.filter.RegainedServiceDateBeforeFilter;
import org.opennms.web.outage.filter.ServiceFilter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/daoWebRepositoryTestContext.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
@Transactional
public class WebOutageRepositoryFilterIT
implements InitializingBean {
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    @Qualifier(value="dao")
    WebOutageRepository m_daoOutageRepo;
    @Autowired
    ApplicationContext m_appContext;

    @BeforeClass
    public static void setupLogging() {
        Properties props = new Properties();
        props.setProperty("log4j.logger.org.hibernate", "INFO");
        props.setProperty("log4j.logger.org.springframework", "INFO");
        props.setProperty("log4j.logger.org.hibernate.SQL", "DEBUG");
        MockLogAppender.setupLogging((Properties)props);
    }

    @Before
    public void setUp() {
        this.m_dbPopulator.populateDatabase();
        OnmsMonitoredService svc2 = this.m_dbPopulator.getMonitoredServiceDao().get(this.m_dbPopulator.getNode2().getId(), InetAddressUtils.addr((String)"192.168.2.1"), "ICMP");
        OnmsEvent event = (OnmsEvent)this.m_dbPopulator.getEventDao().get((Serializable)Integer.valueOf(1));
        OnmsOutage unresolved2 = new OnmsOutage(new Date(), event, svc2);
        this.m_dbPopulator.getOutageDao().save((Object)unresolved2);
        this.m_dbPopulator.getOutageDao().flush();
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testOutageIdFilter() {
        OutageIdFilter filter = new OutageIdFilter(1);
        OutageCriteria criteria = new OutageCriteria(new Filter[]{filter});
        Outage[] outages = this.m_daoOutageRepo.getMatchingOutages(criteria);
        Assert.assertEquals((long)1L, (long)outages.length);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testLostServiceDateBeforeFilter() {
        LostServiceDateBeforeFilter filter = new LostServiceDateBeforeFilter(new Date());
        OutageCriteria criteria = new OutageCriteria(new Filter[]{filter});
        Outage[] outages = this.m_daoOutageRepo.getMatchingOutages(criteria);
        Assert.assertEquals((long)3L, (long)outages.length);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testLostServiceDateAfterFilter() {
        LostServiceDateAfterFilter filter = new LostServiceDateAfterFilter(WebOutageRepositoryFilterIT.yesterday());
        OutageCriteria criteria = new OutageCriteria(new Filter[]{filter});
        Outage[] outages = this.m_daoOutageRepo.getMatchingOutages(criteria);
        Assert.assertEquals((long)3L, (long)outages.length);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testRegainedServiceDateBeforeFilter() {
        RegainedServiceDateBeforeFilter filter = new RegainedServiceDateBeforeFilter(new Date());
        OutageCriteria criteria = new OutageCriteria(new Filter[]{filter});
        Outage[] outages = this.m_daoOutageRepo.getMatchingOutages(criteria);
        Assert.assertEquals((long)1L, (long)outages.length);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testRegainedServiceDateAfterFilter() {
        RegainedServiceDateAfterFilter filter = new RegainedServiceDateAfterFilter(WebOutageRepositoryFilterIT.yesterday());
        OutageCriteria criteria = new OutageCriteria(new Filter[]{filter});
        Outage[] outages = this.m_daoOutageRepo.getMatchingOutages(criteria);
        Assert.assertEquals((long)1L, (long)outages.length);
    }

    private static Date yesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    @Test
    @JUnitTemporaryDatabase
    public void testRecentOutagesFilter() {
        RecentOutagesFilter filter = new RecentOutagesFilter();
        OutageCriteria criteria = new OutageCriteria(new Filter[]{filter});
        Outage[] outages = this.m_daoOutageRepo.getMatchingOutages(criteria);
        Assert.assertEquals((long)3L, (long)outages.length);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNegativeInterfaceFilter() {
        NegativeInterfaceFilter filter = new NegativeInterfaceFilter("192.168.2.1");
        OutageCriteria criteria = new OutageCriteria(new Filter[]{filter});
        Outage[] outages = this.m_daoOutageRepo.getMatchingOutages(criteria);
        Assert.assertEquals((long)2L, (long)outages.length);
    }

    @Test
    @JUnitTemporaryDatabase
    @Ignore
    public void testNegativeNodeFilter() {
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNegativeServiceFilter() {
        NegativeServiceFilter filter = new NegativeServiceFilter(2, null);
        OutageCriteria criteria = new OutageCriteria(new Filter[]{filter});
        Outage[] outages = this.m_daoOutageRepo.getMatchingOutages(criteria);
        Assert.assertEquals((long)1L, (long)outages.length);
    }

    @Test
    @JUnitTemporaryDatabase
    @Ignore
    public void testNodeFilter() {
    }

    @Test
    @JUnitTemporaryDatabase
    public void testInterfaceFilter() {
        InterfaceFilter filter = new InterfaceFilter("192.168.1.1");
        OutageCriteria criteria = new OutageCriteria(new Filter[]{filter});
        InterfaceFilter filter2 = new InterfaceFilter("192.168.2.1");
        OutageCriteria criteria2 = new OutageCriteria(new Filter[]{filter2});
        Outage[] outages = this.m_daoOutageRepo.getMatchingOutages(criteria);
        Assert.assertEquals((long)2L, (long)outages.length);
        outages = this.m_daoOutageRepo.getMatchingOutages(criteria2);
        Assert.assertEquals((long)1L, (long)outages.length);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testServiceFilter() {
        ServiceFilter filter = new ServiceFilter(2, null);
        OutageCriteria criteria = new OutageCriteria(new Filter[]{filter});
        Outage[] outages = this.m_daoOutageRepo.getMatchingOutages(criteria);
        Assert.assertEquals((long)2L, (long)outages.length);
    }
}

