/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.element.Interface;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.element.Service;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/daoWebRepositoryTestContext.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
@Transactional
public class NetworkElementFactoryIT
implements InitializingBean {
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    ApplicationContext m_appContext;
    @Autowired
    DataSource m_dataSource;
    @Autowired
    JdbcTemplate m_jdbcTemplate;
    @Autowired
    NodeDao m_nodeDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_dbPopulator.populateDatabase();
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testGetNodeLabel() throws SQLException {
        String nodeLabel = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getNodeLabel(1);
        Assert.assertEquals((Object)nodeLabel, (Object)"node1");
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetIpPrimaryAddress() throws SQLException {
        this.m_jdbcTemplate.update("INSERT INTO node (nodeId, nodeCreateTime, nodeType, nodeLabel) VALUES (12, now(), 'A', 'nodeLabel')");
        this.m_jdbcTemplate.update("INSERT INTO ipinterface (nodeid, ipaddr, iplastcapsdpoll, issnmpprimary) VALUES (12, '172.168.1.1', now(), 'P')");
        String ipAddr = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getIpPrimaryAddress(12);
        Assert.assertEquals((Object)ipAddr, (Object)"172.168.1.1");
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testGetNodesWithIpLikeOneInterface() throws Exception {
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        this.m_nodeDao.flush();
        this.m_jdbcTemplate.update("INSERT INTO node (nodeId, nodeCreateTime, nodeType) VALUES (12, now(), 'A')");
        this.m_jdbcTemplate.update("INSERT INTO ipInterface (nodeId, ipAddr, isManaged) VALUES (12, '1.1.1.1', 'M')");
        List nodes = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getNodesWithIpLike("*.*.*.*");
        Assert.assertEquals((String)"node count", (long)1L, (long)nodes.size());
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetNodesWithIpLikeTwoInterfaces() throws Exception {
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        this.m_nodeDao.flush();
        this.m_jdbcTemplate.update("INSERT INTO node (nodeId, nodeCreateTime, nodeType) VALUES (12, now(), 'A')");
        this.m_jdbcTemplate.update("INSERT INTO ipInterface (nodeId, ipAddr, isManaged) VALUES (12, '1.1.1.1', 'M')");
        this.m_jdbcTemplate.update("INSERT INTO ipInterface (nodeId, ipAddr, isManaged) VALUES (12, '1.1.1.2', 'M')");
        List nodes = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getNodesWithIpLike("*.*.*.*");
        Assert.assertEquals((String)"node count", (long)1L, (long)nodes.size());
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testGetInterfacesWithIpAddress() throws Exception {
        Interface[] interfaces = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getInterfacesWithIpAddress("fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%5");
        Assert.assertEquals((String)"interface count", (long)1L, (long)interfaces.length);
        Assert.assertEquals((String)"node ID", (long)this.m_dbPopulator.getNode1().getId().intValue(), (long)interfaces[0].getNodeId());
        Assert.assertEquals((String)"ifIndex", (long)4L, (long)interfaces[0].getIfIndex());
        interfaces = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getInterfacesWithIpAddress("fe80:0000:0000:0000:aaaa:bbbb:cccc:0001%5");
        Assert.assertEquals((String)"interface count", (long)0L, (long)interfaces.length);
        interfaces = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getInterfacesWithIpAddress("fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4");
        Assert.assertEquals((String)"interface count", (long)0L, (long)interfaces.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testGetActiveInterfacesOnNode() {
        Interface[] intfs = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getActiveInterfacesOnNode(this.m_dbPopulator.getNode1().getId().intValue());
        Assert.assertEquals((String)"active interfaces", (long)4L, (long)intfs.length);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetServicesOnInterface() {
        this.m_jdbcTemplate.update("UPDATE ifservices SET status='A' WHERE id=2;");
        Service[] svc = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getServicesOnInterface(1, "192.168.1.1");
        Assert.assertEquals((long)1L, (long)svc.length);
    }
}

