/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.config.siteStatusViews.Category;
import org.opennms.netmgt.config.siteStatusViews.RowDef;
import org.opennms.netmgt.config.siteStatusViews.Rows;
import org.opennms.netmgt.config.siteStatusViews.View;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SiteStatusViewConfigDao;
import org.opennms.netmgt.model.AggregateStatusDefinition;
import org.opennms.netmgt.model.AggregateStatusView;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.svclayer.support.DefaultSiteStatusViewService;

public class DefaultSiteStatusServiceTest {
    private NodeDao m_nodeDao;
    private CategoryDao m_categoryDao;
    private SiteStatusViewConfigDao m_siteStatusViewConfigDao;

    @Before
    public void setUp() throws Exception {
        this.m_nodeDao = (NodeDao)EasyMock.createMock(NodeDao.class);
        this.m_categoryDao = (CategoryDao)EasyMock.createMock(CategoryDao.class);
        this.m_siteStatusViewConfigDao = (SiteStatusViewConfigDao)EasyMock.createMock(SiteStatusViewConfigDao.class);
    }

    @Test
    public void testCreateAggregateStatusUsingNodeId() {
        HashSet<AggregateStatusDefinition> defs = new HashSet<AggregateStatusDefinition>();
        OnmsCategory catRouters = new OnmsCategory("routers");
        OnmsCategory catSwitches = new OnmsCategory("switches");
        AggregateStatusDefinition definition = new AggregateStatusDefinition("Routers/Switches", new HashSet<OnmsCategory>(Arrays.asList(catRouters, catSwitches)));
        defs.add(definition);
        OnmsCategory catServers = new OnmsCategory("servers");
        definition = new AggregateStatusDefinition("Servers", new HashSet<OnmsCategory>(Arrays.asList(catServers)));
        defs.add(definition);
        DefaultSiteStatusViewService aggregateSvc = new DefaultSiteStatusViewService();
        aggregateSvc.setNodeDao(this.m_nodeDao);
        aggregateSvc.setCategoryDao(this.m_categoryDao);
        aggregateSvc.setSiteStatusViewConfigDao(this.m_siteStatusViewConfigDao);
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        node.getAssetRecord().setBuilding("HQ");
        ArrayList<OnmsNode> nodes = new ArrayList<OnmsNode>();
        nodes.add(node);
        for (AggregateStatusDefinition def : defs) {
            EasyMock.expect((Object)this.m_nodeDao.findAllByVarCharAssetColumnCategoryList("building", "HQ", (Collection)def.getCategories())).andReturn(nodes);
        }
        for (OnmsNode n : nodes) {
            EasyMock.expect((Object)this.m_nodeDao.load((Serializable)n.getId())).andReturn((Object)n);
        }
        EasyMock.replay((Object[])new Object[]{this.m_nodeDao});
        EasyMock.expect((Object)this.m_categoryDao.findByName("switches")).andReturn((Object)catSwitches);
        EasyMock.expect((Object)this.m_categoryDao.findByName("routers")).andReturn((Object)catRouters);
        EasyMock.expect((Object)this.m_categoryDao.findByName("servers")).andReturn((Object)catServers);
        EasyMock.replay((Object[])new Object[]{this.m_categoryDao});
        Rows rows = new Rows();
        RowDef rowDef = new RowDef();
        Category category = new Category();
        category.setName("servers");
        rowDef.addCategory(category);
        rows.addRowDef(rowDef);
        rowDef = new RowDef();
        category = new Category();
        category.setName("switches");
        rowDef.addCategory(category);
        category = new Category();
        category.setName("routers");
        rowDef.addCategory(category);
        rows.addRowDef(rowDef);
        View view = new View();
        view.setRows(rows);
        EasyMock.expect((Object)this.m_siteStatusViewConfigDao.getView("building")).andReturn((Object)view);
        EasyMock.replay((Object[])new Object[]{this.m_siteStatusViewConfigDao});
        Collection aggrStati = aggregateSvc.createAggregateStatusesUsingNodeId(node.getId().intValue(), "building");
        EasyMock.verify((Object[])new Object[]{this.m_nodeDao});
        EasyMock.verify((Object[])new Object[]{this.m_categoryDao});
        EasyMock.verify((Object[])new Object[]{this.m_siteStatusViewConfigDao});
        Assert.assertNotNull((Object)aggrStati);
    }

    @Test
    public void testCreateAggregateStatusUsingBuilding() {
        HashSet<AggregateStatusDefinition> defs = new HashSet<AggregateStatusDefinition>();
        AggregateStatusDefinition definition = new AggregateStatusDefinition("Routers/Switches", new HashSet<OnmsCategory>(Arrays.asList(new OnmsCategory("routers"), new OnmsCategory("switches"))));
        defs.add(definition);
        definition = new AggregateStatusDefinition("Servers", new HashSet<OnmsCategory>(Arrays.asList(new OnmsCategory("servers"))));
        defs.add(definition);
        DefaultSiteStatusViewService aggregateSvc = new DefaultSiteStatusViewService();
        aggregateSvc.setNodeDao(this.m_nodeDao);
        OnmsNode node = new OnmsNode();
        ArrayList<OnmsNode> nodes = new ArrayList<OnmsNode>();
        nodes.add(node);
        for (AggregateStatusDefinition def : defs) {
            EasyMock.expect((Object)this.m_nodeDao.findAllByVarCharAssetColumnCategoryList("building", "HQ", (Collection)def.getCategories())).andReturn(nodes);
        }
        EasyMock.replay((Object[])new Object[]{this.m_nodeDao});
        AggregateStatusView view = new AggregateStatusView();
        view.setColumnName("building");
        view.setColumnValue("HQ");
        view.setTableName("assets");
        view.setStatusDefinitions(new LinkedHashSet(defs));
        Collection aggrStati = aggregateSvc.createAggregateStatusUsingAssetColumn(view);
        EasyMock.verify((Object[])new Object[]{this.m_nodeDao});
        Assert.assertNotNull((Object)aggrStati);
    }
}

