/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.GraphDao;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.mock.MockResourceType;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;
import org.opennms.web.command.DistributedStatusDetailsCommand;
import org.opennms.web.svclayer.SimpleWebTable;
import org.opennms.web.svclayer.support.DefaultDistributedStatusService;
import org.opennms.web.svclayer.support.DistributedStatusHistoryModel;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;

public class DefaultDistributedStatusServiceTest
extends TestCase {
    private DefaultDistributedStatusService m_service = new DefaultDistributedStatusService();
    private EasyMockUtils m_easyMockUtils = new EasyMockUtils();
    private MonitoredServiceDao m_monitoredServiceDao = (MonitoredServiceDao)this.m_easyMockUtils.createMock(MonitoredServiceDao.class);
    private LocationMonitorDao m_locationMonitorDao = (LocationMonitorDao)this.m_easyMockUtils.createMock(LocationMonitorDao.class);
    private ApplicationDao m_applicationDao = (ApplicationDao)this.m_easyMockUtils.createMock(ApplicationDao.class);
    private ResourceDao m_resourceDao = (ResourceDao)this.m_easyMockUtils.createMock(ResourceDao.class);
    private GraphDao m_graphDao = (GraphDao)this.m_easyMockUtils.createMock(GraphDao.class);
    private OnmsMonitoringLocationDefinition m_locationDefinition1;
    private OnmsMonitoringLocationDefinition m_locationDefinition2;
    private OnmsMonitoringLocationDefinition m_locationDefinition3;
    private OnmsLocationMonitor m_locationMonitor1_1;
    private OnmsLocationMonitor m_locationMonitor2_1;
    private OnmsLocationMonitor m_locationMonitor2_2;
    private OnmsApplication m_application1;
    private OnmsApplication m_application2;
    private Collection<OnmsMonitoredService> m_services;
    private OnmsNode m_node;
    private String m_ip;
    private Set<OnmsMonitoredService> m_applicationServices1;
    private Set<OnmsMonitoredService> m_applicationServices2;
    private static final SimpleDateFormat s_dbDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.mmm");
    public static final String IGNORE_MATCH = "**IGNORE*MATCH**";

    protected void setUp() throws Exception {
        super.setUp();
        this.m_service.setMonitoredServiceDao(this.m_monitoredServiceDao);
        this.m_service.setLocationMonitorDao(this.m_locationMonitorDao);
        this.m_service.setApplicationDao(this.m_applicationDao);
        this.m_service.setResourceDao(this.m_resourceDao);
        this.m_service.setGraphDao(this.m_graphDao);
        this.m_service.afterPropertiesSet();
        this.m_locationDefinition1 = new OnmsMonitoringLocationDefinition("Raleigh", "raleigh", "OpenNMS NC");
        this.m_locationDefinition2 = new OnmsMonitoringLocationDefinition("Durham", "durham", "OpenNMS NC");
        this.m_locationDefinition3 = new OnmsMonitoringLocationDefinition("Columbus", "columbus", "OpenNMS OH");
        this.m_application1 = new OnmsApplication();
        this.m_application1.setName("Application 1");
        this.m_application2 = new OnmsApplication();
        this.m_application2.setName("Application 2");
        this.m_locationMonitor1_1 = new OnmsLocationMonitor();
        this.m_locationMonitor1_1.setId(Integer.valueOf(1));
        this.m_locationMonitor1_1.setLastCheckInTime(new Date());
        this.m_locationMonitor1_1.setDefinitionName("Raleigh");
        this.m_locationMonitor1_1.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        DefaultDistributedStatusServiceTest.assertEquals((String)"location monitor 1.1 status", (Object)OnmsLocationMonitor.MonitorStatus.STARTED, (Object)this.m_locationMonitor1_1.getStatus());
        this.m_locationMonitor2_1 = new OnmsLocationMonitor();
        this.m_locationMonitor2_1.setId(Integer.valueOf(2));
        this.m_locationMonitor2_1.setLastCheckInTime(new Date());
        this.m_locationMonitor2_1.setDefinitionName("Durham");
        this.m_locationMonitor2_1.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        DefaultDistributedStatusServiceTest.assertEquals((String)"location monitor 2.1 status", (Object)OnmsLocationMonitor.MonitorStatus.STARTED, (Object)this.m_locationMonitor2_1.getStatus());
        this.m_locationMonitor2_2 = new OnmsLocationMonitor();
        this.m_locationMonitor2_2.setId(Integer.valueOf(3));
        this.m_locationMonitor2_2.setDefinitionName("Durham");
        this.m_locationMonitor2_2.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        DefaultDistributedStatusServiceTest.assertEquals((String)"location monitor 2.2 status", (Object)OnmsLocationMonitor.MonitorStatus.STARTED, (Object)this.m_locationMonitor2_2.getStatus());
        ArrayList<String> serviceNames = new ArrayList<String>();
        serviceNames.add("ICMP");
        serviceNames.add("DNS");
        serviceNames.add("HTTP");
        serviceNames.add("HTTPS");
        Collections.shuffle(serviceNames);
        this.m_node = new OnmsNode();
        this.m_ip = "1.1.1.1";
        this.m_node.setLabel("Node 1");
        this.m_node.setId(Integer.valueOf(1));
        this.m_services = new HashSet<OnmsMonitoredService>();
        this.m_services.add(new OnmsMonitoredService(new OnmsIpInterface(this.m_ip, this.m_node), new OnmsServiceType("ICMP")));
        this.m_services.add(new OnmsMonitoredService(new OnmsIpInterface(this.m_ip, this.m_node), new OnmsServiceType("DNS")));
        this.m_services.add(new OnmsMonitoredService(new OnmsIpInterface(this.m_ip, this.m_node), new OnmsServiceType("HTTP")));
        this.m_services.add(new OnmsMonitoredService(new OnmsIpInterface(this.m_ip, this.m_node), new OnmsServiceType("HTTPS")));
        this.m_applicationServices1 = new TreeSet<OnmsMonitoredService>();
        this.m_applicationServices1.add(this.findMonitoredService(this.m_services, this.m_ip, "HTTP"));
        this.m_applicationServices1.add(this.findMonitoredService(this.m_services, this.m_ip, "HTTPS"));
        this.m_applicationServices2 = new TreeSet<OnmsMonitoredService>();
        this.m_applicationServices2.add(this.findMonitoredService(this.m_services, this.m_ip, "HTTPS"));
    }

    public void testFindLocationSpecificStatusNullLocation() {
        DistributedStatusDetailsCommand command = new DistributedStatusDetailsCommand();
        BindException errors = new BindException((Object)command, "command");
        command.setApplication(this.m_application1.getName());
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("location cannot be null"));
        try {
            this.m_service.findLocationSpecificStatus(command, (Errors)errors);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testFindLocationSpecificStatusNullApplication() {
        DistributedStatusDetailsCommand command = new DistributedStatusDetailsCommand();
        BindException errors = new BindException((Object)command, "command");
        command.setLocation(this.m_locationDefinition1.getName());
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("application cannot be null"));
        try {
            this.m_service.findLocationSpecificStatus(command, (Errors)errors);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testFindLocationSpecificStatusInvalidLocation() {
        DistributedStatusDetailsCommand command = new DistributedStatusDetailsCommand();
        BindException errors = new BindException((Object)command, "command");
        command.setLocation("invalid location");
        command.setApplication(this.m_application1.getName());
        EasyMock.expect((Object)this.m_locationMonitorDao.findMonitoringLocationDefinition(command.getLocation())).andReturn(null);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("Could not find location for location name \"" + command.getLocation() + "\""));
        this.m_easyMockUtils.replayAll();
        try {
            this.m_service.findLocationSpecificStatus(command, (Errors)errors);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        this.m_easyMockUtils.verifyAll();
        ta.verifyAnticipated();
    }

    public void testFindLocationSpecificStatusInvalidApplication() {
        DistributedStatusDetailsCommand command = new DistributedStatusDetailsCommand();
        BindException errors = new BindException((Object)command, "command");
        command.setLocation(this.m_locationDefinition1.getName());
        command.setApplication("invalid application");
        EasyMock.expect((Object)this.m_locationMonitorDao.findMonitoringLocationDefinition(this.m_locationDefinition1.getName())).andReturn((Object)this.m_locationDefinition1);
        EasyMock.expect((Object)this.m_applicationDao.findByName(command.getApplication())).andReturn(null);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("Could not find application for application name \"" + command.getApplication() + "\""));
        this.m_easyMockUtils.replayAll();
        try {
            this.m_service.findLocationSpecificStatus(command, (Errors)errors);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        this.m_easyMockUtils.verifyAll();
        ta.verifyAnticipated();
    }

    public void testFindLocationSpecificStatus() {
        DistributedStatusDetailsCommand command = new DistributedStatusDetailsCommand();
        BindException errors = new BindException((Object)command, "command");
        command.setLocation(this.m_locationDefinition1.getName());
        command.setApplication(this.m_application1.getName());
        this.expectEverything();
        EasyMock.expect((Object)this.m_monitoredServiceDao.findByApplication(this.m_application1)).andReturn(this.m_applicationServices1);
        this.m_easyMockUtils.replayAll();
        List status = this.m_service.findLocationSpecificStatus(command, (Errors)errors);
        this.m_easyMockUtils.verifyAll();
        DefaultDistributedStatusServiceTest.assertEquals((String)"status list size", (int)2, (int)status.size());
    }

    public void testCreateStatus() {
        for (int i = 0; i < 5; ++i) {
            this.runTestCreateStatus();
        }
    }

    public void runTestCreateStatus() {
        DistributedStatusDetailsCommand command = new DistributedStatusDetailsCommand();
        BindException errors = new BindException((Object)command, "command");
        command.setLocation(this.m_locationDefinition1.getName());
        command.setApplication(this.m_application1.getName());
        this.expectEverything();
        EasyMock.expect((Object)this.m_monitoredServiceDao.findByApplication(this.m_application1)).andReturn(this.m_applicationServices1);
        this.m_easyMockUtils.replayAll();
        SimpleWebTable table = this.m_service.createStatusTable(command, (Errors)errors);
        this.m_easyMockUtils.verifyAll();
        SimpleWebTable expectedTable = new SimpleWebTable();
        expectedTable.setTitle("Distributed status view for Application 1 from Raleigh location");
        expectedTable.addColumn((Object)"Node", "");
        expectedTable.addColumn((Object)"Monitor", "");
        expectedTable.addColumn((Object)"Service", "");
        expectedTable.addColumn((Object)"Status", "");
        expectedTable.addColumn((Object)"Response", "");
        expectedTable.addColumn((Object)"Last Status Change", "");
        expectedTable.addColumn((Object)"Last Update", "");
        expectedTable.newRow();
        expectedTable.addCell((Object)"Node 1", "Normal", "element/node.jsp?node=1");
        expectedTable.addCell((Object)"Raleigh-1", "", "distributed/locationMonitorDetails.htm?monitorId=1");
        expectedTable.addCell((Object)"HTTP", "", "element/service.jsp?ifserviceid=null");
        expectedTable.addCell((Object)"Up", "bright");
        expectedTable.addCell((Object)"", "");
        expectedTable.addCell((Object)IGNORE_MATCH, "");
        expectedTable.addCell((Object)IGNORE_MATCH, "");
        expectedTable.newRow();
        expectedTable.addCell((Object)"Node 1", "Indeterminate", "element/node.jsp?node=1");
        expectedTable.addCell((Object)"Raleigh-1", "", "distributed/locationMonitorDetails.htm?monitorId=1");
        expectedTable.addCell((Object)"HTTPS", "", "element/service.jsp?ifserviceid=null");
        expectedTable.addCell((Object)"Unknown", "bright");
        expectedTable.addCell((Object)"No status recorded for this service from this location", "");
        expectedTable.addCell((Object)IGNORE_MATCH, "");
        expectedTable.addCell((Object)IGNORE_MATCH, "");
        this.assertTableEquals(expectedTable, table);
    }

    public void testCreateStatusPutUnreportedServicesLast() {
        DistributedStatusDetailsCommand command = new DistributedStatusDetailsCommand();
        BindException errors = new BindException((Object)command, "command");
        command.setLocation(this.m_locationDefinition1.getName());
        command.setApplication(this.m_application1.getName());
        EasyMock.expect((Object)this.m_applicationDao.findByName("Application 1")).andReturn((Object)this.m_application1);
        EasyMock.expect((Object)this.m_locationMonitorDao.findMonitoringLocationDefinition(this.m_locationDefinition1.getName())).andReturn((Object)this.m_locationDefinition1);
        EasyMock.expect((Object)this.m_locationMonitorDao.findByLocationDefinition(this.m_locationDefinition1)).andReturn(Collections.singleton(this.m_locationMonitor1_1));
        OnmsMonitoredService httpService = this.findMonitoredService(this.m_services, this.m_ip, "HTTP");
        OnmsMonitoredService httpsService = this.findMonitoredService(this.m_services, this.m_ip, "HTTPS");
        EasyMock.expect((Object)this.m_locationMonitorDao.getMostRecentStatusChange(this.m_locationMonitor1_1, httpService)).andReturn(null);
        EasyMock.expect((Object)this.m_locationMonitorDao.getMostRecentStatusChange(this.m_locationMonitor1_1, httpsService)).andReturn((Object)new OnmsLocationSpecificStatus(this.m_locationMonitor1_1, httpsService, PollStatus.available()));
        EasyMock.expect((Object)this.m_monitoredServiceDao.findByApplication(this.m_application1)).andReturn(this.m_applicationServices1);
        this.m_easyMockUtils.replayAll();
        SimpleWebTable table = this.m_service.createStatusTable(command, (Errors)errors);
        this.m_easyMockUtils.verifyAll();
        SimpleWebTable expectedTable = new SimpleWebTable();
        expectedTable.setTitle("Distributed status view for Application 1 from Raleigh location");
        expectedTable.addColumn((Object)"Node", "");
        expectedTable.addColumn((Object)"Monitor", "");
        expectedTable.addColumn((Object)"Service", "");
        expectedTable.addColumn((Object)"Status", "");
        expectedTable.addColumn((Object)"Response", "");
        expectedTable.addColumn((Object)"Last Status Change", "");
        expectedTable.addColumn((Object)"Last Update", "");
        expectedTable.newRow();
        expectedTable.addCell((Object)"Node 1", "Normal", "element/node.jsp?node=1");
        expectedTable.addCell((Object)"Raleigh-1", "", "distributed/locationMonitorDetails.htm?monitorId=1");
        expectedTable.addCell((Object)"HTTPS", "", "element/service.jsp?ifserviceid=null");
        expectedTable.addCell((Object)"Up", "bright");
        expectedTable.addCell((Object)"", "");
        expectedTable.addCell((Object)IGNORE_MATCH, "");
        expectedTable.addCell((Object)IGNORE_MATCH, "");
        expectedTable.newRow();
        expectedTable.addCell((Object)"Node 1", "Indeterminate", "element/node.jsp?node=1");
        expectedTable.addCell((Object)"Raleigh-1", "", "distributed/locationMonitorDetails.htm?monitorId=1");
        expectedTable.addCell((Object)"HTTP", "", "element/service.jsp?ifserviceid=null");
        expectedTable.addCell((Object)"Unknown", "bright");
        expectedTable.addCell((Object)"No status recorded for this service from this location", "");
        expectedTable.addCell((Object)IGNORE_MATCH, "");
        expectedTable.addCell((Object)IGNORE_MATCH, "");
        this.assertTableEquals(expectedTable, table);
    }

    public void testCreateStatusNoLocationMonitor() {
        DistributedStatusDetailsCommand command = new DistributedStatusDetailsCommand();
        BindException errors = new BindException((Object)command, "command");
        command.setLocation(this.m_locationDefinition3.getName());
        command.setApplication(this.m_application2.getName());
        EasyMock.expect((Object)this.m_applicationDao.findByName("Application 2")).andReturn((Object)this.m_application2);
        EasyMock.expect((Object)this.m_locationMonitorDao.findMonitoringLocationDefinition(this.m_locationDefinition3.getName())).andReturn((Object)this.m_locationDefinition3);
        EasyMock.expect((Object)this.m_locationMonitorDao.findByLocationDefinition(this.m_locationDefinition3)).andReturn(new HashSet());
        this.m_easyMockUtils.replayAll();
        SimpleWebTable table = this.m_service.createStatusTable(command, (Errors)errors);
        Errors errorsOut = table.getErrors();
        DefaultDistributedStatusServiceTest.assertEquals((String)"Number of errors", (int)1, (int)errorsOut.getErrorCount());
        DefaultDistributedStatusServiceTest.assertEquals((String)"Number of global errors", (int)1, (int)errorsOut.getGlobalErrorCount());
        DefaultDistributedStatusServiceTest.assertEquals((String)"Number of field errors", (int)0, (int)errorsOut.getFieldErrorCount());
        ObjectError e = (ObjectError)errorsOut.getGlobalErrors().get(0);
        DefaultDistributedStatusServiceTest.assertEquals((String)"Error code 0", (String)"location.no-monitors", (String)e.getCode());
        DefaultDistributedStatusServiceTest.assertEquals((String)"Error 0 argument count", (int)2, (int)e.getArguments().length);
        DefaultDistributedStatusServiceTest.assertEquals((String)"Error argument 0.0", (Object)"Application 2", (Object)e.getArguments()[0]);
        DefaultDistributedStatusServiceTest.assertEquals((String)"Error argument 0.0", (Object)"Columbus", (Object)e.getArguments()[1]);
        this.m_easyMockUtils.verifyAll();
    }

    public void testCreateFacilityStatusTableNoStartDate() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("argument start cannot be null"));
        this.m_easyMockUtils.replayAll();
        try {
            this.m_service.createFacilityStatusTable(null, new Date());
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.m_easyMockUtils.verifyAll();
    }

    public void testCreateFacilityStatusTableNoEndDate() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("argument end cannot be null"));
        this.m_easyMockUtils.replayAll();
        try {
            this.m_service.createFacilityStatusTable(new Date(), null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.m_easyMockUtils.verifyAll();
    }

    public void testCreateFacilityStatusTableStateDateNotBefore() {
        Date start = new Date();
        Date end = new Date(start.getTime() - 1000L);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("start date (" + start + ") must be older than end date (" + end + ")"));
        this.m_easyMockUtils.replayAll();
        try {
            this.m_service.createFacilityStatusTable(start, end);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.m_easyMockUtils.verifyAll();
    }

    public void testCreateFacilityStatusTableDatesEqual() {
        Date startAndEnd = new Date();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("start date (" + startAndEnd + ") must be older than end date (" + startAndEnd + ")"));
        this.m_easyMockUtils.replayAll();
        try {
            this.m_service.createFacilityStatusTable(startAndEnd, startAndEnd);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.m_easyMockUtils.verifyAll();
    }

    public void testCreateFacilityStatusTableNoApplications() {
        EasyMock.expect((Object)this.m_locationMonitorDao.findAllMonitoringLocationDefinitions()).andReturn(Collections.singletonList(this.m_locationDefinition1));
        EasyMock.expect((Object)this.m_applicationDao.findAll()).andReturn(new ArrayList());
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("there are no applications"));
        Date start = new Date();
        Date end = new Date(start.getTime() + 1000L);
        this.m_easyMockUtils.replayAll();
        try {
            this.m_service.createFacilityStatusTable(start, end);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.m_easyMockUtils.verifyAll();
    }

    public void testCreateFacilityStatusTable() throws Exception {
        LinkedList<OnmsMonitoringLocationDefinition> locationDefinitions = new LinkedList<OnmsMonitoringLocationDefinition>();
        locationDefinitions.add(this.m_locationDefinition1);
        locationDefinitions.add(this.m_locationDefinition2);
        locationDefinitions.add(this.m_locationDefinition3);
        LinkedList<OnmsApplication> applications = new LinkedList<OnmsApplication>();
        applications.add(this.m_application1);
        applications.add(this.m_application2);
        Collections.shuffle(applications);
        OnmsMonitoredService httpService = this.findMonitoredService(this.m_services, this.m_ip, "HTTP");
        OnmsMonitoredService httpsService = this.findMonitoredService(this.m_services, this.m_ip, "HTTPS");
        OnmsMonitoredService icmpService = this.findMonitoredService(this.m_services, this.m_ip, "ICMP");
        LinkedList<OnmsLocationSpecificStatus> mostRecentStatuses = new LinkedList<OnmsLocationSpecificStatus>();
        mostRecentStatuses.add(this.createStatus(this.m_locationMonitor1_1, httpService, PollStatus.available(), "20061011-00:00:00"));
        mostRecentStatuses.add(this.createStatus(this.m_locationMonitor1_1, httpsService, PollStatus.available(), "20061012-06:00:00"));
        mostRecentStatuses.add(this.createStatus(this.m_locationMonitor2_1, httpService, PollStatus.available(), "20061011-00:00:00"));
        mostRecentStatuses.add(this.createStatus(this.m_locationMonitor2_1, httpsService, PollStatus.available(), "20061012-06:00:00"));
        mostRecentStatuses.add(this.createStatus(this.m_locationMonitor2_2, httpService, PollStatus.available(), "20061011-00:00:00"));
        mostRecentStatuses.add(this.createStatus(this.m_locationMonitor2_2, httpsService, PollStatus.available(), "20061012-06:00:00"));
        LinkedList<OnmsLocationSpecificStatus> statusChanges = new LinkedList<OnmsLocationSpecificStatus>();
        statusChanges.add(this.createStatus(this.m_locationMonitor1_1, httpService, PollStatus.available(), "20061011-00:00:00"));
        statusChanges.add(this.createStatus(this.m_locationMonitor1_1, httpsService, PollStatus.unavailable(), "20061012-00:00:00"));
        statusChanges.add(this.createStatus(this.m_locationMonitor1_1, httpsService, PollStatus.available(), "20061012-06:00:00"));
        statusChanges.add(this.createStatus(this.m_locationMonitor1_1, icmpService, PollStatus.down(), "20061010-06:00:00"));
        Date startDate = s_dbDate.parse("2006-10-12 00:00:00.0");
        Date endDate = s_dbDate.parse("2006-10-13 00:00:00.0");
        EasyMock.expect((Object)this.m_locationMonitorDao.findAllMonitoringLocationDefinitions()).andReturn(locationDefinitions);
        EasyMock.expect((Object)this.m_applicationDao.findAll()).andReturn(applications);
        EasyMock.expect((Object)this.m_locationMonitorDao.getAllMostRecentStatusChanges()).andReturn(mostRecentStatuses);
        EasyMock.expect((Object)this.m_locationMonitorDao.findByLocationDefinition((OnmsMonitoringLocationDefinition)locationDefinitions.get(0))).andReturn(Collections.singleton(this.m_locationMonitor1_1));
        HashSet<OnmsLocationMonitor> monitors2 = new HashSet<OnmsLocationMonitor>();
        monitors2.add(this.m_locationMonitor2_1);
        monitors2.add(this.m_locationMonitor2_2);
        EasyMock.expect((Object)this.m_locationMonitorDao.findByLocationDefinition((OnmsMonitoringLocationDefinition)locationDefinitions.get(1))).andReturn(monitors2);
        EasyMock.expect((Object)this.m_locationMonitorDao.findByLocationDefinition((OnmsMonitoringLocationDefinition)locationDefinitions.get(2))).andReturn(new HashSet());
        EasyMock.expect((Object)this.m_locationMonitorDao.getStatusChangesBetween(startDate, endDate)).andReturn(statusChanges);
        EasyMock.expect((Object)this.m_locationMonitorDao.getAllStatusChangesAt(startDate)).andReturn(new HashSet());
        EasyMock.expect((Object)this.m_monitoredServiceDao.findByApplication(this.m_application1)).andReturn(this.m_applicationServices1).times(3);
        EasyMock.expect((Object)this.m_monitoredServiceDao.findByApplication(this.m_application2)).andReturn(this.m_applicationServices2).times(3);
        this.m_easyMockUtils.replayAll();
        SimpleWebTable table = this.m_service.createFacilityStatusTable(startDate, endDate);
        this.m_easyMockUtils.verifyAll();
        SimpleWebTable expectedTable = new SimpleWebTable();
        expectedTable.setTitle("Distributed Status Summary");
        expectedTable.addColumn((Object)"Area", "");
        expectedTable.addColumn((Object)"Location", "");
        expectedTable.addColumn((Object)"Application 1", "");
        expectedTable.addColumn((Object)"Application 2", "");
        expectedTable.newRow();
        expectedTable.addCell((Object)"OpenNMS NC", "");
        expectedTable.addCell((Object)"Raleigh", "");
        expectedTable.addCell((Object)"75.000%", "Normal", "distributedStatusHistory.htm?location=Raleigh&application=Application+1");
        expectedTable.addCell((Object)"75.000%", "Normal", "distributedStatusHistory.htm?location=Raleigh&application=Application+2");
        expectedTable.newRow();
        expectedTable.addCell((Object)"OpenNMS NC", "");
        expectedTable.addCell((Object)"Durham", "");
        expectedTable.addCell((Object)"No data", "Normal");
        expectedTable.addCell((Object)"No data", "Normal");
        expectedTable.newRow();
        expectedTable.addCell((Object)"OpenNMS OH", "");
        expectedTable.addCell((Object)"Columbus", "");
        expectedTable.addCell((Object)"No data", "Indeterminate");
        expectedTable.addCell((Object)"No data", "Indeterminate");
        this.assertTableEquals(expectedTable, table);
    }

    public void testCreateFacilityStatusTableOneApplicationOneOfTwoLocationsReporting() throws Exception {
        OnmsApplication app = this.m_application2;
        LinkedList<OnmsMonitoringLocationDefinition> locationDefinitions = new LinkedList<OnmsMonitoringLocationDefinition>();
        locationDefinitions.add(this.m_locationDefinition1);
        locationDefinitions.add(this.m_locationDefinition2);
        OnmsMonitoredService httpsService = this.findMonitoredService(this.m_services, this.m_ip, "HTTPS");
        LinkedList<OnmsLocationSpecificStatus> mostRecentStatuses = new LinkedList<OnmsLocationSpecificStatus>();
        mostRecentStatuses.add(this.createStatus(this.m_locationMonitor1_1, httpsService, PollStatus.available(), "20061011-00:00:00"));
        LinkedList<OnmsLocationSpecificStatus> statusChanges = new LinkedList<OnmsLocationSpecificStatus>();
        statusChanges.add(this.createStatus(this.m_locationMonitor1_1, httpsService, PollStatus.available(), "20061011-00:00:00"));
        Date startDate = s_dbDate.parse("2006-10-12 00:00:00.0");
        Date endDate = s_dbDate.parse("2006-10-13 00:00:00.0");
        EasyMock.expect((Object)this.m_locationMonitorDao.findAllMonitoringLocationDefinitions()).andReturn(locationDefinitions);
        EasyMock.expect((Object)this.m_applicationDao.findAll()).andReturn(Collections.singletonList(app));
        EasyMock.expect((Object)this.m_locationMonitorDao.getAllMostRecentStatusChanges()).andReturn(mostRecentStatuses);
        EasyMock.expect((Object)this.m_locationMonitorDao.findByLocationDefinition((OnmsMonitoringLocationDefinition)locationDefinitions.get(0))).andReturn(Collections.singleton(this.m_locationMonitor1_1));
        EasyMock.expect((Object)this.m_locationMonitorDao.findByLocationDefinition((OnmsMonitoringLocationDefinition)locationDefinitions.get(1))).andReturn(Collections.singleton(this.m_locationMonitor2_1));
        EasyMock.expect((Object)this.m_locationMonitorDao.getStatusChangesBetween(startDate, endDate)).andReturn(statusChanges);
        EasyMock.expect((Object)this.m_locationMonitorDao.getAllStatusChangesAt(startDate)).andReturn(new HashSet());
        EasyMock.expect((Object)this.m_monitoredServiceDao.findByApplication(app)).andReturn(this.m_applicationServices2).times(2);
        this.m_easyMockUtils.replayAll();
        SimpleWebTable table = this.m_service.createFacilityStatusTable(startDate, endDate);
        this.m_easyMockUtils.verifyAll();
        SimpleWebTable expectedTable = new SimpleWebTable();
        expectedTable.setTitle("Distributed Status Summary");
        expectedTable.addColumn((Object)"Area", "");
        expectedTable.addColumn((Object)"Location", "");
        expectedTable.addColumn((Object)app.getName(), "");
        expectedTable.newRow();
        expectedTable.addCell((Object)"OpenNMS NC", "");
        expectedTable.addCell((Object)"Raleigh", "");
        expectedTable.addCell((Object)"100.000%", "Normal", "distributedStatusHistory.htm?location=Raleigh&application=Application+2");
        expectedTable.newRow();
        expectedTable.addCell((Object)"OpenNMS NC", "");
        expectedTable.addCell((Object)"Durham", "");
        expectedTable.addCell((Object)"No data", "Indeterminate");
        this.assertTableEquals(expectedTable, table);
    }

    public void testCreateFacilityStatusTableLayoutApplicationsVertically() throws Exception {
        LinkedList<OnmsMonitoringLocationDefinition> locationDefinitions = new LinkedList<OnmsMonitoringLocationDefinition>();
        locationDefinitions.add(this.m_locationDefinition1);
        locationDefinitions.add(this.m_locationDefinition2);
        locationDefinitions.add(this.m_locationDefinition3);
        LinkedList<OnmsApplication> applications = new LinkedList<OnmsApplication>();
        applications.add(this.m_application1);
        applications.add(this.m_application2);
        Collections.shuffle(applications);
        OnmsMonitoredService httpService = this.findMonitoredService(this.m_services, this.m_ip, "HTTP");
        OnmsMonitoredService httpsService = this.findMonitoredService(this.m_services, this.m_ip, "HTTPS");
        OnmsMonitoredService icmpService = this.findMonitoredService(this.m_services, this.m_ip, "ICMP");
        LinkedList<OnmsLocationSpecificStatus> mostRecentStatuses = new LinkedList<OnmsLocationSpecificStatus>();
        mostRecentStatuses.add(this.createStatus(this.m_locationMonitor1_1, httpService, PollStatus.available(), "20061011-00:00:00"));
        mostRecentStatuses.add(this.createStatus(this.m_locationMonitor1_1, httpsService, PollStatus.available(), "20061012-06:00:00"));
        mostRecentStatuses.add(this.createStatus(this.m_locationMonitor2_1, httpService, PollStatus.available(), "20061011-00:00:00"));
        mostRecentStatuses.add(this.createStatus(this.m_locationMonitor2_1, httpsService, PollStatus.available(), "20061012-06:00:00"));
        mostRecentStatuses.add(this.createStatus(this.m_locationMonitor2_2, httpService, PollStatus.available(), "20061011-00:00:00"));
        mostRecentStatuses.add(this.createStatus(this.m_locationMonitor2_2, httpsService, PollStatus.available(), "20061012-06:00:00"));
        LinkedList<OnmsLocationSpecificStatus> statusChanges = new LinkedList<OnmsLocationSpecificStatus>();
        statusChanges.add(this.createStatus(this.m_locationMonitor1_1, httpService, PollStatus.available(), "20061011-00:00:00"));
        statusChanges.add(this.createStatus(this.m_locationMonitor1_1, httpsService, PollStatus.unavailable(), "20061012-00:00:00"));
        statusChanges.add(this.createStatus(this.m_locationMonitor1_1, httpsService, PollStatus.available(), "20061012-06:00:00"));
        statusChanges.add(this.createStatus(this.m_locationMonitor1_1, icmpService, PollStatus.down(), "20061010-06:00:00"));
        Date startDate = s_dbDate.parse("2006-10-12 00:00:00.0");
        Date endDate = s_dbDate.parse("2006-10-13 00:00:00.0");
        EasyMock.expect((Object)this.m_locationMonitorDao.findAllMonitoringLocationDefinitions()).andReturn(locationDefinitions);
        EasyMock.expect((Object)this.m_applicationDao.findAll()).andReturn(applications);
        EasyMock.expect((Object)this.m_locationMonitorDao.getAllMostRecentStatusChanges()).andReturn(mostRecentStatuses);
        EasyMock.expect((Object)this.m_locationMonitorDao.findByLocationDefinition((OnmsMonitoringLocationDefinition)locationDefinitions.get(0))).andReturn(Collections.singleton(this.m_locationMonitor1_1));
        HashSet<OnmsLocationMonitor> monitors2 = new HashSet<OnmsLocationMonitor>();
        monitors2.add(this.m_locationMonitor2_1);
        monitors2.add(this.m_locationMonitor2_2);
        EasyMock.expect((Object)this.m_locationMonitorDao.findByLocationDefinition((OnmsMonitoringLocationDefinition)locationDefinitions.get(1))).andReturn(monitors2);
        EasyMock.expect((Object)this.m_locationMonitorDao.findByLocationDefinition((OnmsMonitoringLocationDefinition)locationDefinitions.get(2))).andReturn(new HashSet());
        EasyMock.expect((Object)this.m_locationMonitorDao.getStatusChangesBetween(startDate, endDate)).andReturn(statusChanges);
        EasyMock.expect((Object)this.m_locationMonitorDao.getAllStatusChangesAt(startDate)).andReturn(new HashSet());
        EasyMock.expect((Object)this.m_monitoredServiceDao.findByApplication(this.m_application1)).andReturn(this.m_applicationServices1).times(3);
        EasyMock.expect((Object)this.m_monitoredServiceDao.findByApplication(this.m_application2)).andReturn(this.m_applicationServices2).times(3);
        this.m_service.setLayoutApplicationsVertically(true);
        this.m_easyMockUtils.replayAll();
        SimpleWebTable table = this.m_service.createFacilityStatusTable(startDate, endDate);
        this.m_easyMockUtils.verifyAll();
        SimpleWebTable expectedTable = new SimpleWebTable();
        expectedTable.setTitle("Distributed Status Summary");
        expectedTable.addColumn((Object)"Application", "");
        expectedTable.addColumn((Object)"Raleigh", "");
        expectedTable.addColumn((Object)"Durham", "");
        expectedTable.addColumn((Object)"Columbus", "");
        expectedTable.newRow();
        expectedTable.addCell((Object)"Application 1", "");
        expectedTable.addCell((Object)"75.000%", "Normal", "distributedStatusHistory.htm?location=Raleigh&application=Application+1");
        expectedTable.addCell((Object)"No data", "Normal");
        expectedTable.addCell((Object)"No data", "Indeterminate");
        expectedTable.newRow();
        expectedTable.addCell((Object)"Application 2", "");
        expectedTable.addCell((Object)"75.000%", "Normal", "distributedStatusHistory.htm?location=Raleigh&application=Application+2");
        expectedTable.addCell((Object)"No data", "Normal");
        expectedTable.addCell((Object)"No data", "Indeterminate");
        this.assertTableEquals(expectedTable, table);
    }

    public void testPercentageCalculationAllAvailableStartInMiddleOfDay() throws ParseException {
        OnmsMonitoredService httpService = this.findMonitoredService(this.m_services, this.m_ip, "HTTP");
        OnmsMonitoredService httpsService = this.findMonitoredService(this.m_services, this.m_ip, "HTTPS");
        HashSet<OnmsLocationSpecificStatus> statuses = new HashSet<OnmsLocationSpecificStatus>();
        statuses.add(this.createStatus(this.m_locationMonitor1_1, httpService, PollStatus.available(), "20061011-00:00:00"));
        statuses.add(this.createStatus(this.m_locationMonitor1_1, httpService, PollStatus.available(), "20061012-00:00:00"));
        statuses.add(this.createStatus(this.m_locationMonitor1_1, httpsService, PollStatus.available(), "20061012-06:00:00"));
        statuses.add(this.createStatus(this.m_locationMonitor1_1, httpService, PollStatus.available(), "20061013-00:00:00"));
        Date startDate = s_dbDate.parse("2006-10-12 00:00:00.0");
        Date endDate = s_dbDate.parse("2006-10-13 00:00:00.0");
        this.m_easyMockUtils.replayAll();
        String percentage = this.m_service.calculatePercentageUptime(this.m_applicationServices1, statuses, startDate, endDate);
        this.m_easyMockUtils.verifyAll();
        DefaultDistributedStatusServiceTest.assertEquals((String)"percentage", (String)"100.000%", (String)percentage);
    }

    public void testPercentageCalculationOneUnavailableThenAvailaleInMiddleOfDay() throws ParseException {
        OnmsMonitoredService httpService = this.findMonitoredService(this.m_services, this.m_ip, "HTTP");
        OnmsMonitoredService httpsService = this.findMonitoredService(this.m_services, this.m_ip, "HTTPS");
        HashSet<OnmsLocationSpecificStatus> statuses = new HashSet<OnmsLocationSpecificStatus>();
        statuses.add(this.createStatus(this.m_locationMonitor1_1, httpService, PollStatus.available(), "20061011-00:00:00"));
        statuses.add(this.createStatus(this.m_locationMonitor1_1, httpService, PollStatus.available(), "20061012-00:00:00"));
        statuses.add(this.createStatus(this.m_locationMonitor1_1, httpsService, PollStatus.unavailable(), "20061012-00:00:00"));
        statuses.add(this.createStatus(this.m_locationMonitor1_1, httpsService, PollStatus.available(), "20061012-06:00:00"));
        statuses.add(this.createStatus(this.m_locationMonitor1_1, httpService, PollStatus.available(), "20061013-00:00:00"));
        Date startDate = s_dbDate.parse("2006-10-12 00:00:00.0");
        Date endDate = s_dbDate.parse("2006-10-13 00:00:00.0");
        this.m_easyMockUtils.replayAll();
        String percentage = this.m_service.calculatePercentageUptime(this.m_applicationServices1, statuses, startDate, endDate);
        this.m_easyMockUtils.verifyAll();
        DefaultDistributedStatusServiceTest.assertEquals((String)"percentage", (String)"75.000%", (String)percentage);
    }

    public void testDetails() {
        LinkedList<OnmsMonitoringLocationDefinition> locationDefinitions = new LinkedList<OnmsMonitoringLocationDefinition>();
        locationDefinitions.add(this.m_locationDefinition1);
        locationDefinitions.add(this.m_locationDefinition2);
        locationDefinitions.add(this.m_locationDefinition3);
        EasyMock.expect((Object)this.m_locationMonitorDao.findAllMonitoringLocationDefinitions()).andReturn(locationDefinitions);
        ArrayList<OnmsApplication> applications = new ArrayList<OnmsApplication>();
        applications.add(this.m_application1);
        applications.add(this.m_application2);
        EasyMock.expect((Object)this.m_applicationDao.findAll()).andReturn(applications);
        EasyMock.expect((Object)this.m_locationMonitorDao.findMonitoringLocationDefinition("Durham")).andReturn((Object)this.m_locationDefinition2);
        EasyMock.expect((Object)this.m_applicationDao.findByName("Application 2")).andReturn((Object)this.m_application2);
        ArrayList<OnmsLocationMonitor> monitors = new ArrayList<OnmsLocationMonitor>();
        monitors.add(this.m_locationMonitor2_1);
        monitors.add(this.m_locationMonitor2_2);
        EasyMock.expect((Object)this.m_locationMonitorDao.findByLocationDefinition(this.m_locationDefinition2)).andReturn(monitors);
        for (OnmsMonitoredService service : this.m_applicationServices2) {
            this.m_locationMonitorDao.initialize((Object)service.getIpInterface());
            this.m_locationMonitorDao.initialize((Object)service.getIpInterface().getNode());
        }
        String locationName = this.m_locationDefinition2.getName();
        String applicationName = this.m_application2.getName();
        String monitorId = "";
        String timeSpan = "Last Day";
        String previousLocation = "";
        EasyMock.expect((Object)this.m_monitoredServiceDao.findByApplication(this.m_application2)).andReturn(this.m_applicationServices2).times(2);
        this.expectResourceDaoCall(this.m_locationMonitor2_1, this.m_applicationServices2);
        this.m_easyMockUtils.replayAll();
        DistributedStatusHistoryModel summary = this.m_service.createHistoryModel(locationName, monitorId, applicationName, timeSpan, previousLocation);
        this.m_easyMockUtils.verifyAll();
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary should not be null", (Object)summary);
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary locations list should not be null", (Object)summary.getLocations());
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary applications list should not be null", (Object)summary.getApplications());
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary chosen location should not be null", (Object)summary.getChosenLocation());
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary chosen application should not be null", (Object)summary.getChosenApplication());
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary error list should not be null", (Object)summary.getErrors());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary locations list size", (int)locationDefinitions.size(), (int)summary.getLocations().size());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary applications list size", (int)applications.size(), (int)summary.getApplications().size());
        DefaultDistributedStatusServiceTest.assertEquals((String)("summary error list size: " + summary.getErrors()), (int)0, (int)summary.getErrors().size());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary applications 1", (Object)this.m_application1, summary.getApplications().get(0));
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary applications 2", (Object)this.m_application2, summary.getApplications().get(1));
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary chosen location", (Object)this.m_locationDefinition2, (Object)summary.getChosenLocation());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary chosen application", (Object)this.m_application2, (Object)summary.getChosenApplication());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary chosen location matches list", summary.getLocations().get(1), (Object)summary.getChosenLocation());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary chosen application matches list", summary.getApplications().get(1), (Object)summary.getChosenApplication());
        DefaultDistributedStatusServiceTest.assertEquals((String)"graph URL map size", (int)1, (int)summary.getServiceGraphs().size());
        DefaultDistributedStatusServiceTest.assertNotNull((String)"graph 0 URL should not be null", (Object)((DistributedStatusHistoryModel.ServiceGraph)summary.getServiceGraphs().iterator().next()).getUrl());
    }

    private void expectResourceDaoCall(OnmsLocationMonitor monitor, Collection<OnmsMonitoredService> services) {
        PrefabGraph httpGraph = new PrefabGraph("http", "title", new String[]{"http"}, "command", new String[0], new String[0], 0, new String[]{"distributedStatus"}, null, null, null, new String[0]);
        PrefabGraph httpsGraph = new PrefabGraph("https", "title", new String[]{"https"}, "command", new String[0], new String[0], 0, new String[]{"distributedStatus"}, null, null, null, new String[0]);
        for (OnmsMonitoredService service : services) {
            OnmsResource resource = new OnmsResource("foo", "even more foo", (OnmsResourceType)new MockResourceType(), new HashSet(0));
            EasyMock.expect((Object)this.m_resourceDao.getResourceForIpInterface(service.getIpInterface(), monitor)).andReturn((Object)resource);
            EasyMock.expect((Object)this.m_graphDao.getPrefabGraphsForResource(resource)).andReturn((Object)new PrefabGraph[]{httpGraph, httpsGraph});
        }
        EasyMock.expect((Object)this.m_graphDao.getPrefabGraph(httpGraph.getName())).andReturn((Object)httpGraph).anyTimes();
        EasyMock.expect((Object)this.m_graphDao.getPrefabGraph(httpsGraph.getName())).andReturn((Object)httpsGraph).atLeastOnce();
    }

    public void testWrongLocationDetails() {
        LinkedList<OnmsMonitoringLocationDefinition> locationDefinitions = new LinkedList<OnmsMonitoringLocationDefinition>();
        locationDefinitions.add(this.m_locationDefinition1);
        locationDefinitions.add(this.m_locationDefinition2);
        locationDefinitions.add(this.m_locationDefinition3);
        EasyMock.expect((Object)this.m_locationMonitorDao.findAllMonitoringLocationDefinitions()).andReturn(locationDefinitions);
        ArrayList<OnmsApplication> applications = new ArrayList<OnmsApplication>();
        applications.add(this.m_application1);
        applications.add(this.m_application2);
        EasyMock.expect((Object)this.m_applicationDao.findAll()).andReturn(applications);
        EasyMock.expect((Object)this.m_locationMonitorDao.findMonitoringLocationDefinition("Raleigh-bad")).andReturn(null);
        EasyMock.expect((Object)this.m_applicationDao.findByName("Application 2")).andReturn((Object)this.m_application2);
        ArrayList<OnmsLocationMonitor> monitors = new ArrayList<OnmsLocationMonitor>();
        monitors.add(this.m_locationMonitor1_1);
        EasyMock.expect((Object)this.m_locationMonitorDao.findByLocationDefinition(this.m_locationDefinition1)).andReturn(monitors);
        for (OnmsMonitoredService service : this.m_applicationServices2) {
            this.m_locationMonitorDao.initialize((Object)service.getIpInterface());
            this.m_locationMonitorDao.initialize((Object)service.getIpInterface().getNode());
        }
        String locationName = "Raleigh-bad";
        String applicationName = this.m_application2.getName();
        String monitorId = "";
        String previousLocation = "";
        String timeSpan = "";
        EasyMock.expect((Object)this.m_monitoredServiceDao.findByApplication(this.m_application2)).andReturn(this.m_applicationServices2).times(2);
        this.expectResourceDaoCall(this.m_locationMonitor1_1, this.m_applicationServices2);
        this.m_easyMockUtils.replayAll();
        DistributedStatusHistoryModel summary = this.m_service.createHistoryModel(locationName, monitorId, applicationName, timeSpan, previousLocation);
        this.m_easyMockUtils.verifyAll();
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary should not be null", (Object)summary);
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary locations list should not be null", (Object)summary.getLocations());
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary applications list should not be null", (Object)summary.getApplications());
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary chosen location should not be null", (Object)summary.getChosenLocation());
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary chosen application should not be null", (Object)summary.getChosenApplication());
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary error list should not be null", (Object)summary.getErrors());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary locations list size", (int)locationDefinitions.size(), (int)summary.getLocations().size());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary applications list size", (int)applications.size(), (int)summary.getApplications().size());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary error list size", (int)1, (int)summary.getErrors().size());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary applications 1", (Object)this.m_application1, summary.getApplications().get(0));
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary applications 2", (Object)this.m_application2, summary.getApplications().get(1));
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary error 1", (String)"Could not find location definition 'Raleigh-bad'", (String)((String)summary.getErrors().get(0)));
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary chosen location", (Object)this.m_locationDefinition1, (Object)summary.getChosenLocation());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary chosen application", (Object)this.m_application2, (Object)summary.getChosenApplication());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary chosen location matches list", summary.getLocations().get(0), (Object)summary.getChosenLocation());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary chosen application matches list", summary.getApplications().get(1), (Object)summary.getChosenApplication());
    }

    public void testWrongApplicationDetails() {
        LinkedList<OnmsMonitoringLocationDefinition> locationDefinitions = new LinkedList<OnmsMonitoringLocationDefinition>();
        locationDefinitions.add(this.m_locationDefinition1);
        locationDefinitions.add(this.m_locationDefinition2);
        locationDefinitions.add(this.m_locationDefinition3);
        EasyMock.expect((Object)this.m_locationMonitorDao.findAllMonitoringLocationDefinitions()).andReturn(locationDefinitions);
        ArrayList<OnmsApplication> applications = new ArrayList<OnmsApplication>();
        applications.add(this.m_application1);
        applications.add(this.m_application2);
        EasyMock.expect((Object)this.m_applicationDao.findAll()).andReturn(applications);
        EasyMock.expect((Object)this.m_locationMonitorDao.findMonitoringLocationDefinition(this.m_locationDefinition2.getName())).andReturn((Object)this.m_locationDefinition2);
        EasyMock.expect((Object)this.m_applicationDao.findByName("Big Bad Voodoo Daddy Application")).andReturn(null);
        ArrayList<OnmsLocationMonitor> monitors = new ArrayList<OnmsLocationMonitor>();
        monitors.add(this.m_locationMonitor2_1);
        monitors.add(this.m_locationMonitor2_2);
        EasyMock.expect((Object)this.m_locationMonitorDao.findByLocationDefinition(this.m_locationDefinition2)).andReturn(monitors);
        for (OnmsMonitoredService service : this.m_applicationServices1) {
            this.m_locationMonitorDao.initialize((Object)service.getIpInterface());
            this.m_locationMonitorDao.initialize((Object)service.getIpInterface().getNode());
        }
        String locationName = this.m_locationDefinition2.getName();
        String applicationName = "Big Bad Voodoo Daddy Application";
        String monitorId = "";
        String previousLocation = "";
        String timeSpan = "";
        EasyMock.expect((Object)this.m_monitoredServiceDao.findByApplication(this.m_application1)).andReturn(this.m_applicationServices1).times(2);
        this.expectResourceDaoCall(this.m_locationMonitor2_1, this.m_applicationServices1);
        this.m_easyMockUtils.replayAll();
        DistributedStatusHistoryModel summary = this.m_service.createHistoryModel(locationName, monitorId, applicationName, timeSpan, previousLocation);
        this.m_easyMockUtils.verifyAll();
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary should not be null", (Object)summary);
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary locations list should not be null", (Object)summary.getLocations());
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary applications list should not be null", (Object)summary.getApplications());
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary chosen location should not be null", (Object)summary.getChosenLocation());
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary chosen application should not be null", (Object)summary.getChosenApplication());
        DefaultDistributedStatusServiceTest.assertNotNull((String)"summary error list should not be null", (Object)summary.getErrors());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary locations list size", (int)locationDefinitions.size(), (int)summary.getLocations().size());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary applications list size", (int)applications.size(), (int)summary.getApplications().size());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary error list size", (int)1, (int)summary.getErrors().size());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary applications 1", (Object)this.m_application1, summary.getApplications().get(0));
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary applications 2", (Object)this.m_application2, summary.getApplications().get(1));
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary error 1", (String)"Could not find application 'Big Bad Voodoo Daddy Application'", (String)((String)summary.getErrors().get(0)));
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary chosen location", (Object)this.m_locationDefinition2, (Object)summary.getChosenLocation());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary chosen application", (Object)this.m_application1, (Object)summary.getChosenApplication());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary chosen location matches list", summary.getLocations().get(1), (Object)summary.getChosenLocation());
        DefaultDistributedStatusServiceTest.assertEquals((String)"summary chosen application matches list", summary.getApplications().get(0), (Object)summary.getChosenApplication());
    }

    private OnmsLocationSpecificStatus createStatus(OnmsLocationMonitor locationMonitor, OnmsMonitoredService service, PollStatus status, String timestamp) {
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
        try {
            status.setTimestamp(f.parse(timestamp));
        }
        catch (ParseException e) {
            AssertionFailedError error = new AssertionFailedError("Could not parse timestamp \"" + timestamp + "\"");
            error.initCause((Throwable)e);
            throw error;
        }
        return new OnmsLocationSpecificStatus(locationMonitor, service, status);
    }

    public void assertTableEquals(SimpleWebTable expectedTable, SimpleWebTable table) {
        DefaultDistributedStatusServiceTest.assertEquals((String)"table title", (String)expectedTable.getTitle(), (String)table.getTitle());
        DefaultDistributedStatusServiceTest.assertEquals((String)"number of table columns headers", (int)expectedTable.getColumnHeaders().size(), (int)table.getColumnHeaders().size());
        ListIterator columnHeaderIterator = expectedTable.getColumnHeaders().listIterator();
        for (SimpleWebTable.Cell tableColumnHeader : table.getColumnHeaders()) {
            DefaultDistributedStatusServiceTest.assertEquals((String)("column header " + (columnHeaderIterator.nextIndex() + 1)), columnHeaderIterator.next(), (Object)tableColumnHeader);
        }
        DefaultDistributedStatusServiceTest.assertEquals((String)"number of rows", (int)expectedTable.getRows().size(), (int)table.getRows().size());
        ListIterator expectedRowIterator = expectedTable.getRows().listIterator();
        for (List row : table.getRows()) {
            List expectedRow = (List)expectedRowIterator.next();
            DefaultDistributedStatusServiceTest.assertEquals((String)("row " + (expectedRowIterator.previousIndex() + 1) + " column count"), (int)expectedRow.size(), (int)row.size());
            ListIterator expectedColumnIterator = expectedRow.listIterator();
            for (SimpleWebTable.Cell column : row) {
                SimpleWebTable.Cell expectedColumn = (SimpleWebTable.Cell)expectedColumnIterator.next();
                String rowColumn = "row " + (expectedRowIterator.previousIndex() + 1) + " column " + (expectedColumnIterator.previousIndex() + 1) + " ";
                if (!IGNORE_MATCH.equals(expectedColumn.getContent())) {
                    DefaultDistributedStatusServiceTest.assertEquals((String)(rowColumn + "content"), (Object)expectedColumn.getContent(), (Object)column.getContent());
                }
                if (!IGNORE_MATCH.equals(expectedColumn.getStyleClass())) {
                    DefaultDistributedStatusServiceTest.assertEquals((String)(rowColumn + "styleClass"), (String)expectedColumn.getStyleClass(), (String)column.getStyleClass());
                }
                if (IGNORE_MATCH.equals(expectedColumn.getLink())) continue;
                DefaultDistributedStatusServiceTest.assertEquals((String)(rowColumn + "link"), (String)expectedColumn.getLink(), (String)column.getLink());
            }
        }
    }

    public void expectEverything() {
        EasyMock.expect((Object)this.m_applicationDao.findByName("Application 1")).andReturn((Object)this.m_application1);
        EasyMock.expect((Object)this.m_locationMonitorDao.findMonitoringLocationDefinition(this.m_locationDefinition1.getName())).andReturn((Object)this.m_locationDefinition1);
        EasyMock.expect((Object)this.m_locationMonitorDao.findByLocationDefinition(this.m_locationDefinition1)).andReturn(Collections.singleton(this.m_locationMonitor1_1));
        OnmsMonitoredService httpService = this.findMonitoredService(this.m_services, this.m_ip, "HTTP");
        OnmsMonitoredService httpsService = this.findMonitoredService(this.m_services, this.m_ip, "HTTPS");
        EasyMock.expect((Object)this.m_locationMonitorDao.getMostRecentStatusChange(this.m_locationMonitor1_1, httpService)).andReturn((Object)new OnmsLocationSpecificStatus(this.m_locationMonitor1_1, httpService, PollStatus.available()));
        EasyMock.expect((Object)this.m_locationMonitorDao.getMostRecentStatusChange(this.m_locationMonitor1_1, httpsService)).andReturn(null);
    }

    public OnmsMonitoredService findMonitoredService(Collection<OnmsMonitoredService> services, String interfaceIp, String serviceName) {
        return this.findMonitoredService(services, InetAddressUtils.addr((String)interfaceIp), serviceName);
    }

    private OnmsMonitoredService findMonitoredService(Collection<OnmsMonitoredService> services, InetAddress ipaddr, String serviceName) {
        for (OnmsMonitoredService service : services) {
            if (!ipaddr.equals(service.getIpAddress()) || !serviceName.equals(service.getServiceName())) continue;
            return service;
        }
        DefaultDistributedStatusServiceTest.fail((String)("Could not find service \"" + serviceName + "\" on interface \"" + ipaddr + "\""));
        return null;
    }
}

