/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.web.command.LocationMonitorIdCommand;
import org.opennms.web.svclayer.support.DefaultDistributedPollerService;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;

public class DefaultDistributedPollerServiceTest
extends TestCase {
    private List<Object> m_mocks;
    private LocationMonitorDao m_locationMonitorDao;
    private DefaultDistributedPollerService m_distributedPollerService;

    protected void setUp() {
        this.m_mocks = new LinkedList<Object>();
        this.m_locationMonitorDao = (LocationMonitorDao)EasyMock.createMock(LocationMonitorDao.class);
        this.m_mocks.add(this.m_locationMonitorDao);
        this.m_distributedPollerService = new DefaultDistributedPollerService();
        this.m_distributedPollerService.setLocationMonitorDao(this.m_locationMonitorDao);
    }

    public void testPauseLocationMonitorSuccess() {
        OnmsLocationMonitor locationMonitor = new OnmsLocationMonitor();
        locationMonitor.setId(Integer.valueOf(1));
        locationMonitor.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        EasyMock.expect((Object)this.m_locationMonitorDao.load((Serializable)locationMonitor.getId())).andReturn((Object)locationMonitor);
        this.m_locationMonitorDao.update((Object)locationMonitor);
        LocationMonitorIdCommand command = new LocationMonitorIdCommand();
        command.setMonitorId(Integer.valueOf(1));
        BindException errors = new BindException((Object)command, "command");
        this.replayMocks();
        this.m_distributedPollerService.pauseLocationMonitor(command, errors);
        this.verifyMocks();
        DefaultDistributedPollerServiceTest.assertEquals((String)"error count", (int)0, (int)errors.getErrorCount());
        DefaultDistributedPollerServiceTest.assertEquals((String)"new monitor status", (Object)OnmsLocationMonitor.MonitorStatus.PAUSED, (Object)locationMonitor.getStatus());
    }

    public void testPauseLocationMonitorAlreadyPaused() {
        OnmsLocationMonitor locationMonitor = new OnmsLocationMonitor();
        locationMonitor.setId(Integer.valueOf(1));
        locationMonitor.setStatus(OnmsLocationMonitor.MonitorStatus.PAUSED);
        EasyMock.expect((Object)this.m_locationMonitorDao.load((Serializable)locationMonitor.getId())).andReturn((Object)locationMonitor);
        LocationMonitorIdCommand command = new LocationMonitorIdCommand();
        command.setMonitorId(Integer.valueOf(1));
        BindException errors = new BindException((Object)command, "command");
        this.replayMocks();
        this.m_distributedPollerService.pauseLocationMonitor(command, errors);
        this.verifyMocks();
        DefaultDistributedPollerServiceTest.assertEquals((String)"error count", (int)1, (int)errors.getErrorCount());
        List<ObjectError> errorList = DefaultDistributedPollerServiceTest.getErrorList((Errors)errors);
        DefaultDistributedPollerServiceTest.assertEquals((String)"error list count", (int)1, (int)errorList.size());
        DefaultDistributedPollerServiceTest.assertEquals((String)"error 0 code", (String)"distributed.locationMonitor.alreadyPaused", (String)errorList.get(0).getCode());
    }

    public void testPauseLocationMonitorBindingErrors() {
        LocationMonitorIdCommand command = new LocationMonitorIdCommand();
        BindException errors = new BindException((Object)command, "command");
        errors.addError(new ObjectError("foo", null, null, "foo"));
        DefaultDistributedPollerServiceTest.assertEquals((String)"error count before pause", (int)1, (int)errors.getErrorCount());
        this.replayMocks();
        this.m_distributedPollerService.pauseLocationMonitor(command, errors);
        this.verifyMocks();
        DefaultDistributedPollerServiceTest.assertEquals((String)"error count after pause", (int)1, (int)errors.getErrorCount());
    }

    public void testPauseLocationMonitorNullCommand() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("command argument cannot be null"));
        LocationMonitorIdCommand command = new LocationMonitorIdCommand();
        BindException errors = new BindException((Object)command, "command");
        this.replayMocks();
        try {
            this.m_distributedPollerService.pauseLocationMonitor(null, errors);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.verifyMocks();
    }

    public void testPauseLocationMonitorNullBindException() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("errors argument cannot be null"));
        LocationMonitorIdCommand command = new LocationMonitorIdCommand();
        this.replayMocks();
        try {
            this.m_distributedPollerService.pauseLocationMonitor(command, null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.verifyMocks();
    }

    public void testResumeLocationMonitorSuccess() {
        OnmsLocationMonitor locationMonitor = new OnmsLocationMonitor();
        locationMonitor.setId(Integer.valueOf(1));
        locationMonitor.setStatus(OnmsLocationMonitor.MonitorStatus.PAUSED);
        EasyMock.expect((Object)this.m_locationMonitorDao.load((Serializable)locationMonitor.getId())).andReturn((Object)locationMonitor);
        this.m_locationMonitorDao.update((Object)locationMonitor);
        LocationMonitorIdCommand command = new LocationMonitorIdCommand();
        command.setMonitorId(Integer.valueOf(1));
        BindException errors = new BindException((Object)command, "command");
        this.replayMocks();
        this.m_distributedPollerService.resumeLocationMonitor(command, errors);
        this.verifyMocks();
        DefaultDistributedPollerServiceTest.assertEquals((String)"error count", (int)0, (int)errors.getErrorCount());
        DefaultDistributedPollerServiceTest.assertEquals((String)"new monitor status", (Object)OnmsLocationMonitor.MonitorStatus.STARTED, (Object)locationMonitor.getStatus());
    }

    public void testResumeLocationMonitorNotPaused() {
        OnmsLocationMonitor locationMonitor = new OnmsLocationMonitor();
        locationMonitor.setId(Integer.valueOf(1));
        locationMonitor.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        EasyMock.expect((Object)this.m_locationMonitorDao.load((Serializable)locationMonitor.getId())).andReturn((Object)locationMonitor);
        LocationMonitorIdCommand command = new LocationMonitorIdCommand();
        command.setMonitorId(Integer.valueOf(1));
        BindException errors = new BindException((Object)command, "command");
        this.replayMocks();
        this.m_distributedPollerService.resumeLocationMonitor(command, errors);
        this.verifyMocks();
        DefaultDistributedPollerServiceTest.assertEquals((String)"error count", (int)1, (int)errors.getErrorCount());
        List<ObjectError> errorList = DefaultDistributedPollerServiceTest.getErrorList((Errors)errors);
        DefaultDistributedPollerServiceTest.assertEquals((String)"error list count", (int)1, (int)errorList.size());
        DefaultDistributedPollerServiceTest.assertEquals((String)"error 0 code", (String)"distributed.locationMonitor.notPaused", (String)errorList.get(0).getCode());
    }

    public void testResumeLocationMonitorBindingErrors() {
        LocationMonitorIdCommand command = new LocationMonitorIdCommand();
        BindException errors = new BindException((Object)command, "command");
        errors.addError(new ObjectError("foo", null, null, "foo"));
        DefaultDistributedPollerServiceTest.assertEquals((String)"error count before pause", (int)1, (int)errors.getErrorCount());
        this.replayMocks();
        this.m_distributedPollerService.resumeLocationMonitor(command, errors);
        this.verifyMocks();
        DefaultDistributedPollerServiceTest.assertEquals((String)"error count after pause", (int)1, (int)errors.getErrorCount());
    }

    public void testResumeLocationMonitorNullCommand() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("command argument cannot be null"));
        LocationMonitorIdCommand command = new LocationMonitorIdCommand();
        BindException errors = new BindException((Object)command, "command");
        this.replayMocks();
        try {
            this.m_distributedPollerService.resumeLocationMonitor(null, errors);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.verifyMocks();
    }

    public void testResumeLocationMonitorNullBindException() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("errors argument cannot be null"));
        LocationMonitorIdCommand command = new LocationMonitorIdCommand();
        this.replayMocks();
        try {
            this.m_distributedPollerService.resumeLocationMonitor(command, null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.verifyMocks();
    }

    public void testDeleteLocationMonitorSuccess() {
        OnmsLocationMonitor locationMonitor = new OnmsLocationMonitor();
        locationMonitor.setId(Integer.valueOf(1));
        EasyMock.expect((Object)this.m_locationMonitorDao.load((Serializable)locationMonitor.getId())).andReturn((Object)locationMonitor);
        this.m_locationMonitorDao.delete((Object)locationMonitor);
        LocationMonitorIdCommand command = new LocationMonitorIdCommand();
        command.setMonitorId(Integer.valueOf(1));
        BindException errors = new BindException((Object)command, "command");
        this.replayMocks();
        this.m_distributedPollerService.deleteLocationMonitor(command, errors);
        this.verifyMocks();
        DefaultDistributedPollerServiceTest.assertEquals((String)"error count", (int)0, (int)errors.getErrorCount());
    }

    public void testDeleteLocationMonitorBindingErrors() {
        LocationMonitorIdCommand command = new LocationMonitorIdCommand();
        BindException errors = new BindException((Object)command, "command");
        errors.addError(new ObjectError("foo", null, null, "foo"));
        DefaultDistributedPollerServiceTest.assertEquals((String)"error count before pause", (int)1, (int)errors.getErrorCount());
        this.replayMocks();
        this.m_distributedPollerService.deleteLocationMonitor(command, errors);
        this.verifyMocks();
        DefaultDistributedPollerServiceTest.assertEquals((String)"error count after pause", (int)1, (int)errors.getErrorCount());
    }

    public void testDeleteLocationMonitorNullCommand() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("command argument cannot be null"));
        LocationMonitorIdCommand command = new LocationMonitorIdCommand();
        BindException errors = new BindException((Object)command, "command");
        this.replayMocks();
        try {
            this.m_distributedPollerService.deleteLocationMonitor(null, errors);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.verifyMocks();
    }

    public void testDeleteLocationMonitorNullBindException() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("errors argument cannot be null"));
        LocationMonitorIdCommand command = new LocationMonitorIdCommand();
        this.replayMocks();
        try {
            this.m_distributedPollerService.deleteLocationMonitor(command, null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.verifyMocks();
    }

    private void replayMocks() {
        for (Object o : this.m_mocks) {
            EasyMock.replay((Object[])new Object[]{o});
        }
    }

    private void verifyMocks() {
        for (Object o : this.m_mocks) {
            EasyMock.verify((Object[])new Object[]{o});
        }
        for (Object o : this.m_mocks) {
            EasyMock.reset((Object[])new Object[]{o});
        }
    }

    private static List<ObjectError> getErrorList(Errors errors) {
        return errors.getAllErrors();
    }
}

