/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.DemandPollDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.model.DemandPoll;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.web.services.PollerService;
import org.opennms.web.svclayer.support.DefaultDemandPollService;

public class DemandPollServiceTest
extends TestCase {
    private DefaultDemandPollService m_demandPollService;
    private DemandPollDao m_demandPollDao;
    private MonitoredServiceDao m_monitoredServiceDao;
    private PollerService m_pollerService;
    private SingleDemandPollStore m_pollStore;

    protected void setUp() throws Exception {
        this.m_demandPollDao = (DemandPollDao)EasyMock.createMock(DemandPollDao.class);
        this.m_monitoredServiceDao = (MonitoredServiceDao)EasyMock.createMock(MonitoredServiceDao.class);
        this.m_pollerService = (PollerService)EasyMock.createMock(PollerService.class);
        this.m_pollStore = new SingleDemandPollStore();
        this.m_demandPollService = new DefaultDemandPollService();
        this.m_demandPollService.setDemandPollDao(this.m_demandPollDao);
        this.m_demandPollService.setPollerAPI(this.m_pollerService);
        this.m_demandPollService.setMonitoredServiceDao(this.m_monitoredServiceDao);
    }

    protected void tearDown() throws Exception {
    }

    public void testPollMonitoredService() throws EventProxyException {
        int expectedResultId = this.m_pollStore.getExpectedId();
        this.m_demandPollDao.save(EasyMock.isA(DemandPoll.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                DemandPoll poll = (DemandPoll)EasyMock.getCurrentArguments()[0];
                DemandPollServiceTest.this.m_pollStore.save(poll);
                return null;
            }
        });
        OnmsServiceType svcType = new OnmsServiceType();
        svcType.setId(Integer.valueOf(3));
        svcType.setName("HTTP");
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        OnmsSnmpInterface snmpIface = new OnmsSnmpInterface(node, 1);
        OnmsIpInterface iface = new OnmsIpInterface("192.168.1.1", node);
        iface.setSnmpInterface(snmpIface);
        OnmsMonitoredService monSvc = new OnmsMonitoredService(iface, svcType);
        EasyMock.expect((Object)this.m_monitoredServiceDao.get(Integer.valueOf(1), InetAddressUtils.addr((String)"192.168.1.1"), Integer.valueOf(1), Integer.valueOf(3))).andReturn((Object)monSvc);
        this.m_pollerService.poll(monSvc, expectedResultId);
        EasyMock.replay((Object[])new Object[]{this.m_demandPollDao});
        EasyMock.replay((Object[])new Object[]{this.m_monitoredServiceDao});
        EasyMock.replay((Object[])new Object[]{this.m_pollerService});
        DemandPoll result = this.m_demandPollService.pollMonitoredService(1, InetAddressUtils.addr((String)"192.168.1.1"), 1, 3);
        EasyMock.verify((Object[])new Object[]{this.m_demandPollDao});
        EasyMock.verify((Object[])new Object[]{this.m_monitoredServiceDao});
        EasyMock.verify((Object[])new Object[]{this.m_pollerService});
        DemandPollServiceTest.assertNotNull((String)"Null is an invalid response from pollMonitoredService", (Object)result);
        DemandPollServiceTest.assertEquals((String)"Expected Id to be set by dao", (int)expectedResultId, (int)result.getId());
    }

    public void testGetUpdatedResults() {
        int resultId = 3;
        DemandPoll expectedResult = new DemandPoll();
        EasyMock.expect((Object)this.m_demandPollDao.get((Serializable)Integer.valueOf(3))).andReturn((Object)expectedResult);
        EasyMock.replay((Object[])new Object[]{this.m_demandPollDao});
        DemandPoll result = this.m_demandPollService.getUpdatedResults(3);
        EasyMock.verify((Object[])new Object[]{this.m_demandPollDao});
        DemandPollServiceTest.assertEquals((Object)expectedResult, (Object)result);
    }

    class SingleDemandPollStore
    implements DemandPollDao {
        int m_id = 13;
        DemandPoll m_demandPoll = null;

        SingleDemandPollStore() {
        }

        public int getExpectedId() {
            return this.m_id;
        }

        public void clear() {
        }

        public int countAll() {
            return this.m_demandPoll == null ? 0 : 1;
        }

        public void delete(Integer id) {
            if (id == this.m_demandPoll.getId()) {
                this.m_demandPoll = null;
            }
        }

        public void delete(DemandPoll entity) {
            if (entity.getId() == this.m_demandPoll.getId()) {
                this.m_demandPoll = null;
            }
        }

        public List<DemandPoll> findAll() {
            return Collections.singletonList(this.m_demandPoll);
        }

        public void flush() {
        }

        public DemandPoll get(Integer id) {
            if (id == this.m_id) {
                return this.m_demandPoll;
            }
            return null;
        }

        public DemandPoll load(Integer id) {
            return this.get(id);
        }

        public void saveOrUpdate(DemandPoll entity) {
            if (entity.getId() == null) {
                this.save(entity);
            } else {
                this.update(entity);
            }
        }

        public void update(DemandPoll entity) {
            if (entity.getId() == this.m_id) {
                this.m_demandPoll = entity;
            }
        }

        public void save(DemandPoll entity) {
            if (entity.getId() != null) {
                throw new RuntimeException("Can't save an entity that already has an id");
            }
            entity.setId(this.m_id);
            this.m_demandPoll = entity;
        }

        public void initialize(Object obj) {
        }

        public void lock() {
        }

        public List<DemandPoll> findMatching(Criteria criteria) {
            throw new UnsupportedOperationException("not yet implemeneted");
        }

        public int countMatching(Criteria criteria) {
            throw new UnsupportedOperationException("not yet implemented");
        }
    }
}

