/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer;

import java.util.Collection;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.svclayer.outage.OutageService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-insertData-enabled.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
@Transactional
@DirtiesContext
public class DefaultOutageServiceIntegrationTest
implements InitializingBean {
    private static final int RANGE_LIMIT = 5;
    @Autowired
    OutageService m_outageService;
    @Autowired
    OutageDao m_outageDao;
    @Autowired
    DatabasePopulator m_databasePopulator;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        this.m_databasePopulator.populateDatabase();
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testGetRangeOutages() {
        Collection outages = this.m_outageService.getOutagesByRange(Integer.valueOf(1), Integer.valueOf(5), "iflostservice", "asc", new OnmsCriteria(OnmsOutage.class));
        Assert.assertFalse((String)"Collection should not be emtpy", (boolean)outages.isEmpty());
    }

    @Test
    @JUnitTemporaryDatabase
    public void testLoadOutageById() {
        Collection outages = this.m_outageService.getCurrentOutages();
        Assert.assertTrue((String)"The database should contain at least one outage", (outages.size() > 0 ? 1 : 0) != 0);
        int id = ((OnmsOutage)outages.iterator().next()).getId();
        OnmsOutage outage = this.m_outageService.load(Integer.valueOf(id));
        Assert.assertTrue((String)"We loaded one outage ", (boolean)outage.getId().equals(id));
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testSuppression() {
        Collection outages = this.m_outageService.getCurrentOutages();
        Assert.assertTrue((String)"The database should contain at least one outage", (outages.size() > 0 ? 1 : 0) != 0);
        int id = ((OnmsOutage)outages.iterator().next()).getId();
        Date time = new Date();
        OnmsOutage myOutage = this.m_outageService.load(Integer.valueOf(id));
        Assert.assertTrue((String)"Loaded the outage ", (boolean)myOutage.getId().equals(id));
        myOutage.setSuppressTime(time);
        this.m_outageService.update(myOutage);
        this.m_outageService.load(Integer.valueOf(id));
    }
}

