/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.config;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml", "classpath:/applicationContext-collectd-rest-test.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class PollerConfigurationResourceTest
extends AbstractSpringJerseyRestTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(PollerConfigurationResourceTest.class);

    protected void afterServletStart() throws Exception {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
    }

    @Test
    public void testPollerConfig() throws Exception {
        this.sendRequest(GET, "/config/foo/polling", 404);
        String xml = this.sendRequest(GET, "/config/RDU/polling", 200);
        PollerConfiguration config = (PollerConfiguration)JaxbUtils.unmarshal(PollerConfiguration.class, (String)xml);
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((long)1L, (long)config.getPackages().size());
        Assert.assertEquals((Object)"example1", (Object)((Package)config.getPackages().get(0)).getName());
        Assert.assertEquals((long)17L, (long)config.getMonitors().size());
        xml = this.sendRequest(GET, "/config/00002/polling", 200);
        config = (PollerConfiguration)JaxbUtils.unmarshal(PollerConfiguration.class, (String)xml);
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((long)1L, (long)config.getPackages().size());
        Assert.assertEquals((Object)"example2", (Object)((Package)config.getPackages().get(0)).getName());
        Assert.assertEquals((long)1L, (long)config.getMonitors().size());
        xml = this.sendRequest(GET, "/config/00003/polling", 200);
        config = (PollerConfiguration)JaxbUtils.unmarshal(PollerConfiguration.class, (String)xml);
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((long)1L, (long)config.getPackages().size());
        Assert.assertEquals((Object)"example2", (Object)((Package)config.getPackages().get(0)).getName());
        Assert.assertEquals((long)1L, (long)config.getMonitors().size());
    }
}

