/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.config;

import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.DataCollectionConfigDao;
import org.opennms.netmgt.config.MibObject;
import org.opennms.netmgt.config.datacollection.DatacollectionConfig;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.internal.collection.DataCollectionConfigImpl;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.web.rest.config.DataCollectionConfigResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@RunWith(value=BlockJUnit4ClassRunner.class)
public class DataCollectionConfigResourceTest {
    private DataCollectionConfigResource m_configResource;

    @Before
    public void setUp() throws Exception {
        this.m_configResource = new DataCollectionConfigResource();
        TestDataCollectionConfigDao testDao = new TestDataCollectionConfigDao();
        testDao.setConfigResource((Resource)new FileSystemResource("target/test-classes/config-rest/dc.xml"));
        testDao.afterPropertiesSet();
        this.m_configResource.setDataCollectionConfigDao((DataCollectionConfigDao)testDao);
        this.m_configResource.afterPropertiesSet();
    }

    @Test
    public void testGetConfig() throws Exception {
        Response response = this.m_configResource.getDataCollectionConfiguration();
        Assert.assertNotNull((Object)response.getEntity());
        DataCollectionConfigImpl config = (DataCollectionConfigImpl)response.getEntity();
        Assert.assertEquals((long)2L, (long)config.getSnmpCollections().length);
        System.err.println(JaxbUtils.marshal((Object)config));
        Assert.assertEquals((long)164L, (long)config.getSnmpCollections()[0].getDataCollectionGroups()[0].getResourceTypes().length);
        Assert.assertEquals((long)164L, (long)config.getSnmpCollections()[1].getDataCollectionGroups()[0].getResourceTypes().length);
    }

    public static class TestDataCollectionConfigDao
    extends AbstractJaxbConfigDao<DatacollectionConfig, DatacollectionConfig>
    implements DataCollectionConfigDao {
        public TestDataCollectionConfigDao() {
            super(DatacollectionConfig.class, "data-collection");
        }

        protected DatacollectionConfig translateConfig(DatacollectionConfig config) {
            return config;
        }

        public String getSnmpStorageFlag(String collectionName) {
            throw new UnsupportedOperationException("Not yet implemented!");
        }

        public List<MibObject> getMibObjectList(String cName, String aSysoid, String anAddress, int ifType) {
            throw new UnsupportedOperationException("Not yet implemented!");
        }

        public Map<String, ResourceType> getConfiguredResourceTypes() {
            throw new UnsupportedOperationException("Not yet implemented!");
        }

        public RrdRepository getRrdRepository(String collectionName) {
            throw new UnsupportedOperationException("Not yet implemented!");
        }

        public int getStep(String collectionName) {
            throw new UnsupportedOperationException("Not yet implemented!");
        }

        public List<String> getRRAList(String collectionName) {
            throw new UnsupportedOperationException("Not yet implemented!");
        }

        public String getRrdPath() {
            throw new UnsupportedOperationException("Not yet implemented!");
        }

        public DatacollectionConfig getRootDataCollection() {
            throw new UnsupportedOperationException("Not yet implemented!");
        }

        public List<String> getAvailableDataCollectionGroups() {
            throw new UnsupportedOperationException("Not yet implemented!");
        }

        public List<String> getAvailableSystemDefs() {
            throw new UnsupportedOperationException("Not yet implemented!");
        }

        public List<String> getAvailableMibGroups() {
            throw new UnsupportedOperationException("Not yet implemented!");
        }

        public void reload() {
            throw new UnsupportedOperationException("Not yet implemented!");
        }

        public Date getLastUpdate() {
            throw new UnsupportedOperationException("Not yet implemented!");
        }
    }
}

