/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.config;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.api.collection.IDataCollectionGroup;
import org.opennms.netmgt.config.api.collection.IResourceType;
import org.opennms.netmgt.config.api.collection.ISnmpCollection;
import org.opennms.netmgt.config.internal.collection.DataCollectionConfigImpl;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml", "classpath:/applicationContext-collectd-rest-test.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class DataCollectionConfigResourceITTest
extends AbstractSpringJerseyRestTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(DataCollectionConfigResourceITTest.class);

    protected void afterServletStart() throws Exception {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
    }

    @Test
    public void testDataCollectionConfig() throws Exception {
        String xml = this.sendRequest(GET, "/config/datacollection", 200);
        DataCollectionConfigImpl config = (DataCollectionConfigImpl)JaxbUtils.unmarshal(DataCollectionConfigImpl.class, (String)xml);
        Assert.assertNotNull((Object)config);
        ISnmpCollection[] snmpCollections = config.getSnmpCollections();
        Assert.assertNotNull((Object)snmpCollections);
        Assert.assertEquals((long)1L, (long)snmpCollections.length);
        Assert.assertNotNull((Object)snmpCollections[0]);
        IDataCollectionGroup[] dataCollectionGroups = snmpCollections[0].getDataCollectionGroups();
        Assert.assertNotNull((Object)dataCollectionGroups);
        Assert.assertEquals((long)1L, (long)dataCollectionGroups.length);
        Assert.assertNotNull((Object)dataCollectionGroups[0]);
        IResourceType[] resourceTypes = dataCollectionGroups[0].getResourceTypes();
        Assert.assertNotNull((Object)resourceTypes);
        Assert.assertEquals((long)1L, (long)resourceTypes.length);
        Assert.assertNotNull((Object)resourceTypes[0]);
        Assert.assertEquals((Object)"ifIndex", (Object)resourceTypes[0].getTypeName());
    }
}

