/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.config;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.opennms.core.config.api.ConfigurationResource;
import org.opennms.core.config.impl.JaxbResourceConfiguration;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.agents.AgentResponse;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.mock.UnimplementedFilterDao;
import org.opennms.netmgt.dao.mock.UnimplementedMonitoredServiceDao;
import org.opennms.netmgt.dao.mock.UnimplementedSnmpConfigDao;
import org.opennms.netmgt.filter.FilterDao;
import org.opennms.netmgt.filter.FilterParseException;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpConfiguration;
import org.opennms.web.rest.config.AgentConfigurationResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@RunWith(value=BlockJUnit4ClassRunner.class)
public class AgentConfigurationResourceTest {
    private TestFilterDao m_filterDao;
    private TestMonitoredServiceDao m_monitoredServiceDao;
    private TestSnmpConfigDao m_snmpConfigDao;
    private AgentConfigurationResource m_configResource;

    @Before
    public void setUp() throws Exception {
        this.m_filterDao = new TestFilterDao();
        this.m_monitoredServiceDao = new TestMonitoredServiceDao();
        this.m_snmpConfigDao = new TestSnmpConfigDao();
        this.m_configResource = new AgentConfigurationResource();
        this.m_configResource.setCollectdConfigurationResource((ConfigurationResource)new JaxbResourceConfiguration(CollectdConfiguration.class, (Resource)new ClassPathResource("/config-rest/collectd-configuration.xml")));
        this.m_configResource.setFilterDao((FilterDao)this.m_filterDao);
        this.m_configResource.setMonitoredServiceDao((MonitoredServiceDao)this.m_monitoredServiceDao);
        this.m_configResource.setAgentConfigFactory((SnmpAgentConfigFactory)this.m_snmpConfigDao);
        this.m_configResource.afterPropertiesSet();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidInputs() throws Exception {
        this.m_configResource.getAgentsJson(null, null);
    }

    @Test(expected=WebApplicationException.class)
    public void testMissingFilter() throws Exception {
        this.m_configResource.getAgentsJson("foo", "SNMP");
    }

    @Test
    public void testSimpleFilter() throws Exception {
        InetAddress oneNinetyTwo = InetAddressUtils.addr((String)"192.168.0.1");
        List<InetAddress> addresses = Arrays.asList(oneNinetyTwo);
        this.m_filterDao.setActiveIPAddressList(addresses);
        OnmsNode node = new OnmsNode(null, "foo");
        node.setId(Integer.valueOf(1));
        node.setForeignSource("foo");
        node.setForeignId("bar");
        node.setSysObjectId(".1.2.3.4.5");
        OnmsIpInterface iface = new OnmsIpInterface(oneNinetyTwo, node);
        OnmsServiceType serviceType = new OnmsServiceType("SNMP");
        OnmsMonitoredService service = new OnmsMonitoredService(iface, serviceType);
        this.m_monitoredServiceDao.setMatching(Arrays.asList(service));
        Response response = this.m_configResource.getAgentsJson("example1", "SNMP");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Object entity = response.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)(entity instanceof GenericEntity));
        List agentResponses = (List)((GenericEntity)entity).getEntity();
        System.err.println(agentResponses);
        Assert.assertEquals((long)1L, (long)agentResponses.size());
        Assert.assertEquals((Object)oneNinetyTwo, (Object)((AgentResponse)agentResponses.get(0)).getAddress());
        Assert.assertEquals((long)1161L, (long)((AgentResponse)agentResponses.get(0)).getPort().intValue());
        Assert.assertEquals((Object)".1.2.3.4.5", ((AgentResponse)agentResponses.get(0)).getParameters().get("sysObjectId"));
        Assert.assertEquals((Object)"1", ((AgentResponse)agentResponses.get(0)).getParameters().get("nodeId"));
        Assert.assertEquals((Object)"foo", ((AgentResponse)agentResponses.get(0)).getParameters().get("foreignSource"));
        Assert.assertEquals((Object)"bar", ((AgentResponse)agentResponses.get(0)).getParameters().get("foreignId"));
    }

    private static final class TestSnmpConfigDao
    extends UnimplementedSnmpConfigDao {
        private TestSnmpConfigDao() {
        }

        public SnmpAgentConfig getAgentConfig(InetAddress address) {
            return new SnmpAgentConfig(address, this.getDefaults());
        }

        public SnmpConfiguration getDefaults() {
            SnmpConfiguration config = new SnmpConfiguration();
            config.setPort(1161);
            return config;
        }
    }

    private static final class TestFilterDao
    extends UnimplementedFilterDao {
        private List<InetAddress> m_activeAddresses;

        private TestFilterDao() {
        }

        public void setActiveIPAddressList(List<InetAddress> addresses) {
            this.m_activeAddresses = addresses;
        }

        public List<InetAddress> getActiveIPAddressList(String rule) throws FilterParseException {
            return this.m_activeAddresses;
        }
    }

    private static final class TestMonitoredServiceDao
    extends UnimplementedMonitoredServiceDao {
        private List<OnmsMonitoredService> m_services;

        private TestMonitoredServiceDao() {
        }

        public List<OnmsMonitoredService> findMatching(Criteria criteria) {
            return this.m_services;
        }

        public void setMatching(List<OnmsMonitoredService> services) {
            this.m_services = services;
        }
    }
}

