/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.config;

import javax.servlet.ServletContext;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml", "classpath:/applicationContext-agents-rest-test.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class AgentConfigurationResourceITTest
extends AbstractSpringJerseyRestTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AgentConfigurationResourceITTest.class);
    @Autowired
    DatabasePopulator m_databasePopulator;

    protected void beforeServletStart() throws Exception {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
        this.m_databasePopulator.populateDatabase();
    }

    protected void afterServletDestroy() throws Exception {
        this.m_databasePopulator.resetDatabase();
    }

    @Test
    public void testAgentConfig() throws Exception {
        this.sendRequest(GET, "/config/agents/foo/SNMP", 404);
        String xml = this.sendRequest(GET, "/config/agents/example1/SNMP", 200);
        Assert.assertTrue((boolean)xml.contains("192.168.1.1"));
    }

    @Test
    public void testJsonResponse() throws Exception {
        MockHttpServletRequest req = AgentConfigurationResourceITTest.createRequest((ServletContext)this.getServletContext(), (String)GET, (String)"/config/agents/example1/SNMP");
        req.addHeader("Accept", (Object)"application/json");
        String json = this.sendRequest(req, 200);
        Assert.assertTrue((boolean)json.contains("\"address\":\"192.168.1.1\""));
    }
}

