/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.users.User;
import org.opennms.netmgt.model.OnmsUser;
import org.opennms.netmgt.model.OnmsUserList;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class UserRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    private static final String PASSWORD = "21232F297A57A5A743894A0E4A801FC3";

    @Test
    public void testUser() throws Exception {
        String url = "/users";
        String xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("admin"));
        OnmsUserList list = (OnmsUserList)JaxbUtils.unmarshal(OnmsUserList.class, (String)xml);
        Assert.assertEquals((long)1L, (long)list.getUsers().size());
        Assert.assertEquals((String)xml, (Object)"admin", (Object)((OnmsUser)list.getUsers().get(0)).getUsername());
        xml = this.sendRequest(GET, url + "/admin", 200);
        Assert.assertTrue((boolean)xml.contains(">admin<"));
        this.sendRequest(GET, url + "/idontexist", 404);
    }

    @Test
    public void testWriteUser() throws Exception {
        this.createUser("test");
        String xml = this.sendRequest(GET, "/users/test", 200);
        Assert.assertTrue((boolean)xml.contains("<user><user-id>test</user-id>"));
        this.sendPut("/users/test", "password=MONKEYS&email=test@opennms.org", 303, "/users/test");
        xml = this.sendRequest(GET, "/users/test", 200);
        OnmsUser testUser = (OnmsUser)JaxbUtils.unmarshal(OnmsUser.class, (String)xml);
        User castorUser = ((UserManager)this.getWebAppContext().getBean(UserManager.class)).getUser("test");
        Assert.assertEquals((Object)castorUser.getPassword().getContent(), (Object)"MONKEYS");
        Assert.assertEquals((Object)"test@opennms.org", (Object)testUser.getEmail());
    }

    @Test
    public void testWriteUserWithEmail() throws Exception {
        this.createUser("test123", "test123@opennms.org");
        String xml = this.sendRequest(GET, "/users/test123", 200);
        Assert.assertNotNull((Object)xml);
        OnmsUser testUser = (OnmsUser)JaxbUtils.unmarshal(OnmsUser.class, (String)xml);
        Assert.assertNotNull((Object)testUser);
        Assert.assertEquals((Object)"test123", (Object)testUser.getUsername());
        Assert.assertEquals((Object)"test123@opennms.org", (Object)testUser.getEmail());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWriteALotOfUsers() throws Exception {
        void var5_10;
        int userCount = 50;
        ExecutorService pool = Executors.newFixedThreadPool(25);
        ArrayList<Future<Object>> createFutures = new ArrayList<Future<Object>>();
        for (int i = 0; i < userCount; ++i) {
            final String string = "test" + i;
            createFutures.add(pool.submit(Executors.callable(new Runnable(){

                @Override
                public void run() {
                    try {
                        UserRestServiceTest.this.createUser(string, string + "@opennms.org");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.getMessage());
                    }
                }
            })));
        }
        for (Future future : createFutures) {
            future.get();
        }
        OnmsUserList users = (OnmsUserList)JaxbUtils.unmarshal(OnmsUserList.class, (String)this.sendRequest(GET, "/users", 200));
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((long)(userCount + 1), (long)users.size());
        boolean bl = false;
        while (var5_10 < userCount) {
            String xml = this.sendRequest(GET, "/users/test" + (int)var5_10, 200);
            OnmsUser eachUser = (OnmsUser)JaxbUtils.unmarshal(OnmsUser.class, (String)xml);
            Assert.assertEquals((Object)("test" + (int)var5_10), (Object)eachUser.getUsername());
            Assert.assertEquals((Object)("test" + (int)var5_10 + " Full Name"), (Object)eachUser.getFullName());
            Assert.assertEquals((Object)("test" + (int)var5_10 + "@opennms.org"), (Object)eachUser.getEmail());
            Assert.assertEquals((Object)"Autogenerated by a unit test...", (Object)eachUser.getComments());
            this.sendPut("/users/test" + (int)var5_10, "password=MONKEYS&email=TEST@OPENNMS.COM", 303, "/users/test" + (int)var5_10);
            eachUser = (OnmsUser)JaxbUtils.unmarshal(OnmsUser.class, (String)this.sendRequest(GET, "/users/test" + (int)var5_10, 200));
            User castorUser = ((UserManager)this.getWebAppContext().getBean(UserManager.class)).getUser("test" + (int)var5_10);
            Assert.assertEquals((Object)castorUser.getPassword().getContent(), (Object)"MONKEYS");
            Assert.assertEquals((Object)"TEST@OPENNMS.COM", (Object)eachUser.getEmail());
            ++var5_10;
        }
    }

    @Test
    public void testDeleteUser() throws Exception {
        this.createUser("deleteMe");
        String xml = this.sendRequest(GET, "/users", 200);
        Assert.assertTrue((boolean)xml.contains("deleteMe"));
        this.sendRequest(DELETE, "/users/idontexist", 400);
        this.sendRequest(DELETE, "/users/deleteMe", 200);
        this.sendRequest(GET, "/users/deleteMe", 404);
    }

    @Test
    public void testGetUserWithoutAuth() throws Exception {
        this.createUser("foo");
        this.createUser("bar");
        UserRestServiceTest.setUser((String)"foo", (String[])new String[]{"ROLE_USER"});
        String xml = this.sendRequest(GET, "/users", 200);
        Assert.assertTrue((boolean)xml.contains("foo"));
        Assert.assertTrue((boolean)xml.contains("bar"));
        OnmsUserList users = (OnmsUserList)JaxbUtils.unmarshal(OnmsUserList.class, (String)xml);
        Assert.assertEquals((long)3L, (long)users.size());
        Assert.assertEquals((Object)"xxxxxxxx", (Object)((OnmsUser)users.get(0)).getPassword());
        Assert.assertEquals((Object)"xxxxxxxx", (Object)((OnmsUser)users.get(1)).getPassword());
        Assert.assertEquals((Object)PASSWORD, (Object)((OnmsUser)users.get(2)).getPassword());
        UserRestServiceTest.setUser((String)"bar", (String[])new String[]{"ROLE_USER"});
        xml = this.sendRequest(GET, "/users", 200);
        Assert.assertTrue((boolean)xml.contains("foo"));
        Assert.assertTrue((boolean)xml.contains("bar"));
        users = (OnmsUserList)JaxbUtils.unmarshal(OnmsUserList.class, (String)xml);
        Assert.assertEquals((long)3L, (long)users.size());
        Assert.assertEquals((Object)"xxxxxxxx", (Object)((OnmsUser)users.get(0)).getPassword());
        Assert.assertEquals((Object)PASSWORD, (Object)((OnmsUser)users.get(1)).getPassword());
        Assert.assertEquals((Object)"xxxxxxxx", (Object)((OnmsUser)users.get(2)).getPassword());
        UserRestServiceTest.setUser((String)"admin", (String[])new String[]{"ROLE_ADMIN"});
        xml = this.sendRequest(GET, "/users", 200);
        Assert.assertTrue((boolean)xml.contains("foo"));
        Assert.assertTrue((boolean)xml.contains("bar"));
        users = (OnmsUserList)JaxbUtils.unmarshal(OnmsUserList.class, (String)xml);
        Assert.assertEquals((long)3L, (long)users.size());
        Assert.assertEquals((Object)PASSWORD, (Object)((OnmsUser)users.get(0)).getPassword());
        Assert.assertEquals((Object)PASSWORD, (Object)((OnmsUser)users.get(1)).getPassword());
        Assert.assertEquals((Object)PASSWORD, (Object)((OnmsUser)users.get(2)).getPassword());
    }

    protected void createUser(String username) throws Exception {
        this.createUser(username, null);
    }

    protected void createUser(String username, String email) throws Exception {
        UserRestServiceTest.setUser((String)"admin", (String[])new String[]{"ROLE_ADMIN"});
        String userXml = "<user><user-id>" + username + "</user-id>" + "<full-name>" + username + " Full Name</full-name>" + "{EMAIL}" + "<user-comments>Autogenerated by a unit test...</user-comments>" + "<password>" + PASSWORD + "</password>" + "</user>";
        userXml = userXml.replace("{EMAIL}", email != null ? "<email>" + email + "</email>" : "");
        this.sendPost("/users", userXml, 303, "/users/" + username);
    }
}

