/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.spi.spring.container.servlet.SpringServlet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.db.XADataSourceFactory;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.test.DaoTestConfigBean;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.rest.AvailCalculator;
import org.opennms.web.rest.support.TimeChunker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.orm.hibernate3.support.OpenSessionInViewFilter;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.context.support.WebApplicationContextUtils;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml", "classpath:/org/opennms/web/rest/applicationContext-test.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
@Transactional
public class RemotePollerAvailabilityRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    @Autowired
    ApplicationDao m_applicationDao;
    @Autowired
    LocationMonitorDao m_locationMonitorDao;
    @Autowired
    MonitoredServiceDao m_monServiceDao;
    @Autowired
    DatabasePopulator m_databasePopulator;
    public static final String BASE_REST_URL = "/remotelocations/availability";

    @Before
    public void setUp() throws Throwable {
        this.beforeServletStart();
        DaoTestConfigBean bean = new DaoTestConfigBean();
        bean.afterPropertiesSet();
        MockDatabase db = new MockDatabase(true);
        DataSourceFactory.setInstance((DataSource)db);
        XADataSourceFactory.setInstance((XADataSource)db);
        this.setServletConfig(new MockServletConfig(this.getServletContext(), "dispatcher"));
        this.getServletConfig().addInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        this.getServletConfig().addInitParameter("com.sun.jersey.config.property.packages", "org.opennms.web.rest");
        try {
            MockFilterConfig filterConfig = new MockFilterConfig(this.getServletContext(), "openSessionInViewFilter");
            this.setFilter((Filter)new OpenSessionInViewFilter());
            this.getFilter().init((FilterConfig)filterConfig);
            this.setDispatcher((ServletContainer)new SpringServlet());
            this.getDispatcher().init((ServletConfig)this.getServletConfig());
        }
        catch (ServletException se) {
            throw se.getRootCause();
        }
        this.setWebAppContext(WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext()));
        this.afterServletStart();
        System.err.println("------------------------------------------------------------------------------");
    }

    protected void afterServletStart() {
        MockLogAppender.setupLogging();
        this.m_databasePopulator = (DatabasePopulator)this.getBean("databasePopulator", DatabasePopulator.class);
        this.m_applicationDao = (ApplicationDao)this.getBean("applicationDao", ApplicationDao.class);
        this.m_locationMonitorDao = (LocationMonitorDao)this.getBean("locationMonitorDao", LocationMonitorDao.class);
        this.m_monServiceDao = (MonitoredServiceDao)this.getBean("monitoredServiceDao", MonitoredServiceDao.class);
        this.m_databasePopulator.populateDatabase();
        try {
            this.createLocationMonitors();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Test
    public void testGetAvailability() {
        final long endMillis = System.currentTimeMillis();
        final long startMillis = endMillis - 12000L;
        final long totalTime = endMillis - startMillis;
        TransactionTemplate txTemplate = (TransactionTemplate)this.getBean("transactionTemplate", TransactionTemplate.class);
        txTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                TimeChunker timeChunker = new TimeChunker(totalTime, new Date(startMillis), new Date(endMillis));
                timeChunker.getNextSegment();
                Collection allStatusChanges = RemotePollerAvailabilityRestServiceTest.this.m_locationMonitorDao.getStatusChangesForApplicationBetween(new Date(startMillis), new Date(endMillis), "IPv6");
                AvailCalculator calc = new AvailCalculator(timeChunker);
                for (OnmsLocationSpecificStatus statusChange : allStatusChanges) {
                    calc.onStatusChange(statusChange);
                }
                Set svcs = RemotePollerAvailabilityRestServiceTest.this.m_monServiceDao.findByApplication(RemotePollerAvailabilityRestServiceTest.this.m_applicationDao.findByName("IPv6"));
                double avail = calc.getAvailabilityFor((Collection)svcs, 0);
                Assert.assertEquals((double)0.8333, (double)avail, (double)0.0333);
            }
        });
    }

    @Test
    public void testGetLocations() throws Exception {
        String url = "/remotelocations";
        String responseString = this.sendRequest(GET, url, 200);
        Assert.assertTrue((responseString != null ? 1 : 0) != 0);
    }

    @Test
    public void testGetParticipants() throws Exception {
        String url = "/remotelocations/participants";
        String responseString = this.sendRequest(GET, url, 200);
        Assert.assertTrue((responseString != null ? 1 : 0) != 0);
    }

    @Test
    public void testRemotePollerAvailability() throws Exception {
        long startTime = System.currentTimeMillis();
        String url = BASE_REST_URL;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("resolution", "minute");
        String responseString = this.sendRequest(GET, url, parameters, 200);
        Assert.assertTrue((boolean)responseString.contains("IPv6"));
        Assert.assertTrue((boolean)responseString.contains("IPv4"));
        System.err.println("total time taken: " + (System.currentTimeMillis() - startTime) + "UptimeCalculator.count = " + AvailCalculator.UptimeCalculator.count);
        Thread.sleep(2000L);
        startTime = System.currentTimeMillis();
        responseString = this.sendRequest(GET, url, parameters, 200);
        Assert.assertTrue((boolean)responseString.contains("IPv6"));
        Assert.assertTrue((boolean)responseString.contains("IPv4"));
        System.err.println("total time taken for cache: " + (System.currentTimeMillis() - startTime) + "UptimeCalculator.count = " + AvailCalculator.UptimeCalculator.count);
    }

    @Test
    public void testRemotePollerAvailabilitySingleLocation() throws Exception {
        long startTime = System.currentTimeMillis();
        String url = "/remotelocations/availability/RDU";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("resolution", "minute");
        this.addStartTime(parameters);
        this.addEndTime(parameters);
        String responseString = this.sendRequest(GET, "/remotelocations/availability/RDU", parameters, 200);
        Assert.assertTrue((boolean)responseString.contains("IPv6"));
        Assert.assertTrue((boolean)responseString.contains("IPv4"));
        System.err.println("total time taken: " + (System.currentTimeMillis() - startTime));
    }

    private void addEndTime(Map<String, String> parameters) {
        parameters.put("endTime", "" + System.currentTimeMillis());
    }

    private void addStartTime(Map<String, String> parameters) {
        parameters.put("startTime", "" + (System.currentTimeMillis() - 300001L));
    }

    @Test
    public void testRemotePollerAvailabilityFiveMinutes() throws Exception {
        String url = BASE_REST_URL;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("startTime", "" + (new Date().getTime() - 172800000L));
        parameters.put("endTime", "" + (new Date().getTime() - 86400000L));
        parameters.put("resolution", "minute");
        String responseString = this.sendRequest(GET, url, parameters, 200);
        Assert.assertTrue((boolean)responseString.contains("IPv6"));
        Assert.assertTrue((boolean)responseString.contains("IPv4"));
    }

    private void createLocationMonitors() throws InterruptedException {
        TransactionTemplate txTemplate = (TransactionTemplate)this.getBean("transactionTemplate", TransactionTemplate.class);
        txTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                System.err.println("======= Starting createLocationMonitors() ======");
                OnmsLocationMonitor locMon1 = new OnmsLocationMonitor();
                locMon1.setDefinitionName("RDU");
                locMon1.setLastCheckInTime(new Date());
                locMon1.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
                RemotePollerAvailabilityRestServiceTest.this.m_locationMonitorDao.save((Object)locMon1);
                OnmsApplication ipv6App = new OnmsApplication();
                ipv6App.setName("IPv6");
                RemotePollerAvailabilityRestServiceTest.this.m_applicationDao.saveOrUpdate((Object)ipv6App);
                OnmsApplication ipv4App = new OnmsApplication();
                ipv4App.setName("IPv4");
                RemotePollerAvailabilityRestServiceTest.this.m_applicationDao.saveOrUpdate((Object)ipv4App);
                OnmsMonitoredService service2 = (OnmsMonitoredService)RemotePollerAvailabilityRestServiceTest.this.m_monServiceDao.findByType("HTTP").get(1);
                service2.addApplication(ipv4App);
                ipv4App.addMonitoredService(service2);
                RemotePollerAvailabilityRestServiceTest.this.m_monServiceDao.saveOrUpdate((Object)service2);
                RemotePollerAvailabilityRestServiceTest.this.m_applicationDao.saveOrUpdate((Object)ipv4App);
                List services = RemotePollerAvailabilityRestServiceTest.this.m_monServiceDao.findByType("HTTP");
                for (OnmsMonitoredService service : services) {
                    service = (OnmsMonitoredService)RemotePollerAvailabilityRestServiceTest.this.m_monServiceDao.findByType("HTTP").get(0);
                    service.addApplication(ipv6App);
                    ipv6App.addMonitoredService(service);
                    RemotePollerAvailabilityRestServiceTest.this.m_monServiceDao.saveOrUpdate((Object)service);
                    RemotePollerAvailabilityRestServiceTest.this.m_applicationDao.saveOrUpdate((Object)ipv6App);
                    OnmsLocationMonitor locMon = (OnmsLocationMonitor)RemotePollerAvailabilityRestServiceTest.this.m_locationMonitorDao.findAll().get(0);
                    OnmsLocationSpecificStatus statusChange = new OnmsLocationSpecificStatus();
                    statusChange.setLocationMonitor(locMon);
                    statusChange.setPollResult(PollStatus.available());
                    statusChange.setMonitoredService(service);
                    RemotePollerAvailabilityRestServiceTest.this.m_locationMonitorDao.saveStatusChange(statusChange);
                }
                System.err.println("======= End createLocationMonitors() ======");
            }
        });
        Thread.sleep(2000L);
        txTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                List services = RemotePollerAvailabilityRestServiceTest.this.m_monServiceDao.findByType("HTTP");
                for (OnmsMonitoredService service : services) {
                    OnmsLocationMonitor locMon = (OnmsLocationMonitor)RemotePollerAvailabilityRestServiceTest.this.m_locationMonitorDao.findAll().get(0);
                    OnmsLocationSpecificStatus statusChange = new OnmsLocationSpecificStatus();
                    statusChange.setLocationMonitor(locMon);
                    statusChange.setPollResult(PollStatus.unavailable());
                    statusChange.setMonitoredService(service);
                    RemotePollerAvailabilityRestServiceTest.this.m_locationMonitorDao.saveStatusChange(statusChange);
                }
            }
        });
        Thread.sleep(2000L);
        txTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                List services = RemotePollerAvailabilityRestServiceTest.this.m_monServiceDao.findByType("HTTP");
                for (OnmsMonitoredService service : services) {
                    OnmsLocationMonitor locMon = (OnmsLocationMonitor)RemotePollerAvailabilityRestServiceTest.this.m_locationMonitorDao.findAll().get(0);
                    OnmsLocationSpecificStatus statusChange = new OnmsLocationSpecificStatus();
                    statusChange.setLocationMonitor(locMon);
                    statusChange.setPollResult(PollStatus.available());
                    statusChange.setMonitoredService(service);
                    RemotePollerAvailabilityRestServiceTest.this.m_locationMonitorDao.saveStatusChange(statusChange);
                }
            }
        });
    }
}

