/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.util.Date;
import javax.servlet.ServletContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.OnmsDao;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class OutageRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    @Autowired
    private ApplicationDao applicationDao;
    @Autowired
    private DatabasePopulator populator;

    @Before
    public void setUp() throws Throwable {
        super.setUp();
        Assert.assertNotNull((Object)this.populator);
        Assert.assertNotNull((Object)this.applicationDao);
        this.populator.addExtension((DatabasePopulator.Extension)new DatabasePopulator.Extension<ApplicationDao>(){
            private OnmsOutage unresolvedOutage;
            private OnmsEvent outageEvent;
            private OnmsApplication application;

            public DatabasePopulator.DaoSupport<ApplicationDao> getDaoSupport() {
                return new DatabasePopulator.DaoSupport(ApplicationDao.class, (OnmsDao)OutageRestServiceTest.this.applicationDao);
            }

            public void onPopulate(DatabasePopulator populator, ApplicationDao dao) {
                OnmsDistPoller distPoller = populator.getDistPoller("localhost", "127.0.0.1");
                this.outageEvent = populator.buildEvent(distPoller);
                populator.getEventDao().save((Object)this.outageEvent);
                populator.getEventDao().flush();
                this.application = new OnmsApplication();
                this.application.setName("Awesome Application");
                dao.save((Object)this.application);
                OnmsMonitoredService svc = populator.getMonitoredServiceDao().get(populator.getNode1().getId(), InetAddressUtils.addr((String)"192.168.1.1"), "SNMP");
                svc.addApplication(this.application);
                this.application.addMonitoredService(svc);
                populator.getMonitoredServiceDao().saveOrUpdate((Object)svc);
                populator.getMonitoredServiceDao().flush();
                this.unresolvedOutage = new OnmsOutage(new Date(), this.outageEvent, svc);
                populator.getOutageDao().save((Object)this.unresolvedOutage);
                populator.getOutageDao().flush();
            }

            public void onShutdown(DatabasePopulator populator, ApplicationDao dao) {
                for (OnmsApplication application : dao.findAll()) {
                    dao.delete((Object)application);
                }
            }
        });
        this.populator.populateDatabase();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.populator.resetDatabase();
    }

    @Test
    public void testGetAllOutages() throws Exception {
        String xml = this.sendRequest(GET, "/outages", 200);
        MockHttpServletRequest jsonRequest = OutageRestServiceTest.createRequest((ServletContext)this.getServletContext(), (String)GET, (String)"/outages");
        jsonRequest.addHeader("Accept", (Object)"application/json");
        String json = this.sendRequest(jsonRequest, 200);
        Assert.assertNotNull((Object)xml);
        Assert.assertNotNull((Object)json);
    }
}

