/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class GzipEncodingRestTest
extends AbstractSpringJerseyRestTestCase {
    @Autowired
    private ApplicationDao applicationDao;
    @Autowired
    private DatabasePopulator populator;

    @Before
    public void setUp() throws Throwable {
        super.setUp();
        Assert.assertNotNull((Object)this.populator);
        Assert.assertNotNull((Object)this.applicationDao);
        this.populator.populateDatabase();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.populator.resetDatabase();
    }

    @Test
    public void testGzippedEncodedReponse() throws Exception {
        MockHttpServletRequest request = GzipEncodingRestTest.createRequest((ServletContext)this.getServletContext(), (String)GET, (String)"/nodes");
        String xml = this.sendRequest(request, 200);
        request.addHeader("Accept-Encoding", (Object)"gzip");
        MockHttpServletResponse response = GzipEncodingRestTest.createResponse();
        this.dispatch(request, response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"gzip", (Object)response.getHeader("Content-Encoding"));
        GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(response.getContentAsByteArray()));
        String ungzippedXml = CharStreams.toString((Readable)new InputStreamReader((InputStream)gzip, Charsets.UTF_8));
        Assert.assertEquals((Object)xml, (Object)ungzippedXml);
    }
}

