/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.web.rest.AvailCalculator;
import org.opennms.web.rest.support.TimeChunker;

public class AvailCalculatorTest {
    private OnmsLocationMonitor m_locationMon;
    private OnmsMonitoredService m_svc;

    @Before
    public void setUp() {
        this.m_locationMon = new OnmsLocationMonitor();
        this.m_locationMon.setDefinitionName("IPv6");
        this.m_locationMon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        this.m_svc = new OnmsMonitoredService();
    }

    @Test
    public void testGetAvailabilityOneStatus() {
        Date endTime = new Date(System.currentTimeMillis());
        Date startTime = new Date(endTime.getTime() - 100L);
        PollStatus pollStatus = PollStatus.unavailable();
        Date timestamp = new Date(endTime.getTime() - 50L);
        OnmsLocationSpecificStatus statusChange = this.createStatusChange(pollStatus, timestamp);
        TimeChunker chunker = new TimeChunker((long)((int)(endTime.getTime() - startTime.getTime())), startTime, endTime);
        AvailCalculator calculator = new AvailCalculator(chunker);
        calculator.onStatusChange(statusChange);
        chunker.getNextSegment();
        double uptimePercent = calculator.getAvailabilityFor(this.getServices(), 0);
        Assert.assertEquals((double)0.5, (double)uptimePercent, (double)0.0);
    }

    private OnmsLocationSpecificStatus createStatusChange(PollStatus pollStatus, Date timestamp) {
        pollStatus.setTimestamp(timestamp);
        OnmsLocationSpecificStatus statusChange = new OnmsLocationSpecificStatus();
        statusChange.setLocationMonitor(this.m_locationMon);
        statusChange.setMonitoredService(this.m_svc);
        statusChange.setPollResult(pollStatus);
        return statusChange;
    }

    private Collection<OnmsMonitoredService> getServices() {
        ArrayList<OnmsMonitoredService> svcs = new ArrayList<OnmsMonitoredService>();
        svcs.add(this.m_svc);
        return svcs;
    }

    @Test
    public void testGetAvailabilityStatusFlipFlop() {
        Date endTime = new Date(System.currentTimeMillis());
        Date startTime = new Date(endTime.getTime() - 100L);
        TimeChunker chunker = new TimeChunker((long)((int)(endTime.getTime() - startTime.getTime())), startTime, endTime);
        AvailCalculator calculator = new AvailCalculator(chunker);
        calculator.onStatusChange(this.createStatusChange(PollStatus.unavailable(), new Date(endTime.getTime() - 90L)));
        calculator.onStatusChange(this.createStatusChange(PollStatus.available(), new Date(endTime.getTime() - 70L)));
        calculator.onStatusChange(this.createStatusChange(PollStatus.unavailable(), new Date(endTime.getTime() - 50L)));
        calculator.onStatusChange(this.createStatusChange(PollStatus.available(), new Date(endTime.getTime() - 20L)));
        Collection<OnmsMonitoredService> svcs = this.getServices();
        double uptimePercent = calculator.getAvailabilityFor(svcs, 0);
        Assert.assertEquals((double)0.5, (double)uptimePercent, (double)0.0);
    }

    @Test
    public void testGetAvailabilityUnavailableBefore() {
        Date endTime = new Date(System.currentTimeMillis());
        Date startTime = new Date(endTime.getTime() - 100L);
        TimeChunker chunker = new TimeChunker((long)((int)(endTime.getTime() - startTime.getTime())), startTime, endTime);
        AvailCalculator calculator = new AvailCalculator(chunker);
        calculator.onStatusChange(this.createStatusChange(PollStatus.unavailable(), new Date(endTime.getTime() - 150L)));
        calculator.onStatusChange(this.createStatusChange(PollStatus.available(), new Date(endTime.getTime() - 50L)));
        Collection<OnmsMonitoredService> svcs = this.getServices();
        double uptimePercent = calculator.getAvailabilityFor(svcs, 0);
        Assert.assertEquals((double)0.5, (double)uptimePercent, (double)0.0);
    }

    @Test
    public void testNotAvailabileDuringTimeChunk() {
        Date endTime = new Date(System.currentTimeMillis());
        Date startTime = new Date(endTime.getTime() - 100L);
        TimeChunker chunker = new TimeChunker((long)((int)(endTime.getTime() - startTime.getTime())), startTime, endTime);
        AvailCalculator calculator = new AvailCalculator(chunker);
        calculator.onStatusChange(this.createStatusChange(PollStatus.unavailable(), new Date(endTime.getTime() - 150L)));
        calculator.onStatusChange(this.createStatusChange(PollStatus.available(), new Date(endTime.getTime() + 50L)));
        Collection<OnmsMonitoredService> svcs = this.getServices();
        double uptimePercent = calculator.getAvailabilityFor(svcs, 0);
        Assert.assertEquals((double)0.0, (double)uptimePercent, (double)0.0);
    }
}

