/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class AlarmRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    @Autowired
    TransactionTemplate m_template;
    private DatabasePopulator m_databasePopulator;

    protected void afterServletStart() {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.m_databasePopulator = (DatabasePopulator)context.getBean("databasePopulator", DatabasePopulator.class);
        this.m_template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                AlarmRestServiceTest.this.m_databasePopulator.populateDatabase();
            }
        });
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAlarms() throws Exception {
        String xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"orderBy=lastEventTime&order=desc&alarmAckUser=null&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms/1", AlarmRestServiceTest.parseParamData((String)"orderBy=lastEventTime&order=desc&alarmAckUser=null&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        Assert.assertTrue((boolean)xml.contains("<nodeLabel>node1</nodeLabel>"));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAlarmQueryByNode() throws Exception {
        String xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"nodeId=6&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("<alarms"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"node.id=6&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("<alarms"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"node.label=node1&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("node1"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"ipInterface.ipAddress=192.168.1.2&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("node1"));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAlarmQueryBySeverityEquals() throws Exception {
        String xml = null;
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"comparator=eq&severity=NORMAL&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"comparator=eq&severity=MAJOR&limit=1"), 200);
        Assert.assertFalse((boolean)xml.contains("This is a test alarm"));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAlarmQueryBySeverityLessThan() throws Exception {
        String xml = null;
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"comparator=le&severity=NORMAL&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"comparator=lt&severity=NORMAL&limit=1"), 200);
        Assert.assertFalse((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"comparator=lt&severity=WARNING&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAlarmQueryBySeverityGreaterThan() throws Exception {
        String xml = null;
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"comparator=ge&severity=NORMAL&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"comparator=gt&severity=NORMAL&limit=1"), 200);
        Assert.assertFalse((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"comparator=gt&severity=CLEARED&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testAlarmUpdates() throws Exception {
        this.createAlarm(OnmsSeverity.MAJOR);
        OnmsAlarm alarm = this.getLastAlarm();
        alarm.setAlarmAckTime(null);
        alarm.setAlarmAckUser(null);
        this.getAlarmDao().saveOrUpdate((Object)alarm);
        Integer alarmId = alarm.getId();
        this.sendPut("/alarms", "ack=true&alarmId=" + alarmId, 303, "/alarms/" + alarmId);
        String xml = this.sendRequest(GET, "/alarms/" + alarmId, 200);
        Assert.assertTrue((boolean)xml.contains("ackUser>admin<"));
        this.sendPut("/alarms/" + alarmId, "clear=true", 303, "/alarms/" + alarmId);
        xml = this.sendRequest(GET, "/alarms/" + alarmId, 200);
        Assert.assertTrue((boolean)xml.contains("severity=\"CLEARED\""));
        this.sendPut("/alarms/" + alarmId, "escalate=true", 303, "/alarms/" + alarmId);
        xml = this.sendRequest(GET, "/alarms/" + alarmId, 200);
        Assert.assertTrue((boolean)xml.contains("severity=\"NORMAL\""));
        alarm = this.getLastAlarm();
        alarm.setSeverity(OnmsSeverity.MAJOR);
        alarm.setAlarmAckTime(null);
        alarm.setAlarmAckUser(null);
        this.getAlarmDao().saveOrUpdate((Object)alarm);
        AlarmRestServiceTest.setUser((String)"foo", (String[])new String[]{"ROLE_REST"});
        this.sendPut("/alarms/" + alarmId, "ack=true&ackUser=bar", 403, null);
    }

    private OnmsAlarm getLastAlarm() {
        TreeSet<OnmsAlarm> alarms = new TreeSet<OnmsAlarm>(new Comparator<OnmsAlarm>(){

            @Override
            public int compare(OnmsAlarm a, OnmsAlarm b) {
                return a.getId().compareTo(b.getId());
            }
        });
        alarms.addAll(this.getAlarmDao().findAll());
        return (OnmsAlarm)alarms.last();
    }

    private OnmsAlarm createAlarm(OnmsSeverity severity) {
        OnmsEvent event = (OnmsEvent)this.getEventDao().findAll().get(0);
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setDistPoller((OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost")));
        alarm.setUei(event.getEventUei());
        alarm.setAlarmType(Integer.valueOf(1));
        alarm.setNode(this.m_databasePopulator.getNode1());
        alarm.setDescription("This is a test alarm");
        alarm.setLogMsg("this is a test alarm log message");
        alarm.setCounter(Integer.valueOf(1));
        alarm.setIpAddr(InetAddressUtils.getInetAddress((String)"192.168.1.1"));
        alarm.setSeverity(severity);
        alarm.setFirstEventTime(event.getEventTime());
        alarm.setLastEvent(event);
        alarm.setAlarmAckTime(new Date());
        alarm.setAlarmAckUser("admin");
        this.getAlarmDao().save((Object)alarm);
        this.getAlarmDao().flush();
        return alarm;
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAlarmClearAsAdmin() throws Exception {
        AlarmRestServiceTest.setUser((String)"admin", (String[])new String[]{"ROLE_ADMIN"});
        OnmsAlarm alarm = this.createAlarm(OnmsSeverity.MAJOR);
        this.sendRequest(PUT, "/alarms/" + alarm.getId(), AlarmRestServiceTest.parseParamData((String)"clear=true"), 303);
        String xml = this.sendRequest(GET, "/alarms/" + alarm.getId(), 200);
        OnmsAlarm fromRest = (OnmsAlarm)JaxbUtils.unmarshal(OnmsAlarm.class, (String)xml);
        Assert.assertEquals((Object)fromRest.getSeverity(), (Object)OnmsSeverity.CLEARED);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAlarmClearAsUser() throws Exception {
        AlarmRestServiceTest.setUser((String)"ranger", (String[])new String[]{"ROLE_USER"});
        OnmsAlarm alarm = this.createAlarm(OnmsSeverity.MAJOR);
        this.sendRequest(PUT, "/alarms/" + alarm.getId(), AlarmRestServiceTest.parseParamData((String)"clear=true"), 303);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAlarmClearAsRest() throws Exception {
        AlarmRestServiceTest.setUser((String)"ranger", (String[])new String[]{"ROLE_REST"});
        OnmsAlarm alarm = this.createAlarm(OnmsSeverity.MAJOR);
        this.sendRequest(PUT, "/alarms/" + alarm.getId(), AlarmRestServiceTest.parseParamData((String)"clear=true"), 303);
        String xml = this.sendRequest(GET, "/alarms/" + alarm.getId(), 200);
        OnmsAlarm fromRest = (OnmsAlarm)JaxbUtils.unmarshal(OnmsAlarm.class, (String)xml);
        Assert.assertEquals((Object)fromRest.getSeverity(), (Object)OnmsSeverity.CLEARED);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAlarmClearAsMobile() throws Exception {
        AlarmRestServiceTest.setUser((String)"ranger", (String[])new String[]{"ROLE_MOBILE"});
        OnmsAlarm alarm = this.createAlarm(OnmsSeverity.MAJOR);
        this.sendRequest(PUT, "/alarms/" + alarm.getId(), AlarmRestServiceTest.parseParamData((String)"clear=true"), 303);
        String xml = this.sendRequest(GET, "/alarms/" + alarm.getId(), 200);
        OnmsAlarm fromRest = (OnmsAlarm)JaxbUtils.unmarshal(OnmsAlarm.class, (String)xml);
        Assert.assertEquals((Object)fromRest.getSeverity(), (Object)OnmsSeverity.CLEARED);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAlarmClearAsReadOnly() throws Exception {
        AlarmRestServiceTest.setUser((String)"ranger", (String[])new String[]{"ROLE_MOBILE", "ROLE_READONLY"});
        OnmsAlarm alarm = this.createAlarm(OnmsSeverity.MAJOR);
        this.sendRequest(PUT, "/alarms/" + alarm.getId(), AlarmRestServiceTest.parseParamData((String)"clear=true"), 403);
    }

    private EventDao getEventDao() {
        return this.m_databasePopulator.getEventDao();
    }

    private AlarmDao getAlarmDao() {
        return this.m_databasePopulator.getAlarmDao();
    }

    private DistPollerDao getDistPollerDao() {
        return this.m_databasePopulator.getDistPollerDao();
    }
}

