/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class AcknowledgmentRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    @Autowired
    TransactionTemplate m_template;

    protected void afterServletStart() {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        final DatabasePopulator dbp = (DatabasePopulator)context.getBean("databasePopulator", DatabasePopulator.class);
        this.m_template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                dbp.populateDatabase();
            }
        });
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAcknowlegeNotification() throws Exception {
        Pattern p = Pattern.compile("^.*<answeredBy>(.*?)</answeredBy>.*$", 0);
        this.sendData(POST, "application/x-www-form-urlencoded", "/acks", "notifId=1&action=ack");
        String xml = this.sendRequest(GET, "/notifications/1", new HashMap(), 200);
        Matcher m = p.matcher(xml);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertTrue((boolean)m.group(1).equals("admin"));
        this.sendData(POST, "application/x-www-form-urlencoded", "/acks", "notifId=1&action=unack");
        xml = this.sendRequest(GET, "/notifications/1", new HashMap(), 200);
        m = p.matcher(xml);
        Assert.assertFalse((boolean)m.matches());
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAcknowlegeAlarm() throws Exception {
        Pattern p = Pattern.compile("^.*<ackTime>(.*?)</ackTime>.*$", 0);
        this.sendData(POST, "application/x-www-form-urlencoded", "/acks", "alarmId=1&action=ack");
        String xml = this.sendRequest(GET, "/alarms/1", new HashMap(), 200);
        Matcher m = p.matcher(xml);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertTrue((m.group(1).length() > 0 ? 1 : 0) != 0);
        this.sendData(POST, "application/x-www-form-urlencoded", "/acks", "alarmId=1&action=unack");
        xml = this.sendRequest(GET, "/alarms/1", new HashMap(), 200);
        m = p.matcher(xml);
        Assert.assertFalse((boolean)m.matches());
    }
}

