/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.node;

import java.util.Arrays;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.provision.persist.DefaultNodeProvisionService;
import org.opennms.netmgt.provision.persist.NodeProvisionService;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.controller.node.NodeProvisioningController;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.ModelAndViewAssert;
import org.springframework.web.servlet.ModelAndView;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
@Ignore(value="This test doesn't quite work yet because we don't have mock provisioning classes in the webapp")
public class NodeProvisioningControllerTest {
    private static final GrantedAuthority ROLE_USER = new SimpleGrantedAuthority("ROLE_USER");
    private static final GrantedAuthority ROLE_ADMIN = new SimpleGrantedAuthority("ROLE_ADMIN");
    private static final GrantedAuthority ROLE_PROVISION = new SimpleGrantedAuthority("ROLE_PROVISION");
    private static final GrantedAuthority ROLE_ANONYMOUS = new SimpleGrantedAuthority("ROLE_ANONYMOUS");
    private static final GrantedAuthority ROLE_DASHBOARD = new SimpleGrantedAuthority("ROLE_DASHBOARD");
    private static final String USERNAME = "opennms";
    private static final String PASS = "r0c|<Z";
    NodeProvisioningController m_controller = new NodeProvisioningController();

    @Before
    public void setUp() throws Exception {
        SecurityContextImpl context = new SecurityContextImpl();
        User principal = new User(USERNAME, PASS, true, true, true, true, Arrays.asList(ROLE_ADMIN, ROLE_PROVISION));
        PreAuthenticatedAuthenticationToken auth = new PreAuthenticatedAuthenticationToken((Object)principal, new Object());
        context.setAuthentication((Authentication)auth);
        SecurityContextHolder.setContext((SecurityContext)context);
        this.m_controller.setRedirectView("REDIRECTED");
        this.m_controller.setSuccessView("REDIRECTED");
        this.m_controller.setNodeProvisionService((NodeProvisionService)new DefaultNodeProvisionService());
        this.m_controller.setServletContext((ServletContext)new MockServletContext());
        this.m_controller.afterPropertiesSet();
    }

    @Test
    public void testProvisionNode() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("GET");
        ModelAndView mv = this.m_controller.handleRequest((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        ModelAndViewAssert.assertViewName((ModelAndView)mv, (String)this.m_controller.getSuccessView());
    }
}

