/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.dao.support.PropertiesGraphDao;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.web.controller.GraphResultsController;
import org.opennms.web.svclayer.GraphResultsService;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class GraphResultsControllerTest {
    private GraphResultsController m_controller;
    private GraphResultsService m_service;

    @Before
    public void setUp() throws Exception {
        this.m_service = (GraphResultsService)EasyMock.createMock(GraphResultsService.class);
        PropertiesGraphDao graphDao = new PropertiesGraphDao();
        graphDao.loadProperties("performance", (Resource)new FileSystemResource(new File("src/test/resources/etc/snmp-graph.properties")));
        List prefabs = graphDao.getAllPrefabGraphs();
        Assert.assertNotNull((Object)prefabs);
        Assert.assertFalse((boolean)prefabs.isEmpty());
        EasyMock.expect((Object)this.m_service.getAllPrefabGraphs("node[1].nodeSnmp[]")).andReturn((Object)prefabs.toArray(new PrefabGraph[prefabs.size()])).anyTimes();
        this.m_controller = new GraphResultsController();
        this.m_controller.setGraphResultsService(this.m_service);
        EasyMock.replay((Object[])new Object[]{this.m_service});
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.m_service});
    }

    @Test
    public void testMatching() throws Exception {
        Object[] reports = this.m_controller.getSuggestedReports("node[1].nodeSnmp[]", "memAvailReal / memTotalReal * 100.0");
        System.out.println(StringUtils.join((Object[])reports, (String)", "));
        Assert.assertEquals((long)2L, (long)reports.length);
        Assert.assertEquals((Object)"netsnmp.memStats", (Object)reports[0]);
        reports = this.m_controller.getSuggestedReports("node[1].nodeSnmp[]", "memAvailReal");
        System.out.println(StringUtils.join((Object[])reports, (String)", "));
        Assert.assertEquals((long)2L, (long)reports.length);
        Assert.assertEquals((Object)"netsnmp.memStats", (Object)reports[0]);
        reports = this.m_controller.getSuggestedReports("node[1].nodeSnmp[]", "blahblah");
        System.out.println(StringUtils.join((Object[])reports, (String)", "));
        Assert.assertEquals((long)1L, (long)reports.length);
        Assert.assertEquals((Object)"all", (Object)reports[0]);
    }
}

