/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.validator;

import java.io.Serializable;
import org.opennms.netmgt.dao.api.StatisticsReportDao;
import org.opennms.web.command.StatisticsReportCommand;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class StatisticsReportCommandValidator
implements Validator,
InitializingBean {
    private StatisticsReportDao m_statisticsReportDao;

    public boolean supports(Class<?> clazz) {
        return clazz.equals(StatisticsReportCommand.class);
    }

    public void validate(Object obj, Errors errors) {
        StatisticsReportCommand cmd = (StatisticsReportCommand)obj;
        if (cmd.getId() == null) {
            errors.rejectValue("id", "statisticsReportId.notSpecified", new Object[]{"id"}, "Value required.");
        } else {
            try {
                int id = cmd.getId();
                this.m_statisticsReportDao.load((Serializable)Integer.valueOf(id));
            }
            catch (DataAccessException e) {
                errors.rejectValue("id", "statisticsReportId.notFound", new Object[]{"id", cmd.getId()}, "Valid statistics report ID required.");
            }
        }
    }

    public void afterPropertiesSet() {
        if (this.m_statisticsReportDao == null) {
            throw new IllegalStateException("statisticsReportDao property not set");
        }
    }

    public StatisticsReportDao getStatisticsReportDao() {
        return this.m_statisticsReportDao;
    }

    public void setStatisticsReportDao(StatisticsReportDao statisticsReportDao) {
        this.m_statisticsReportDao = statisticsReportDao;
    }
}

