/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.tags;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.opennms.netmgt.model.OnmsFilterFavorite;
import org.opennms.web.filter.Filter;
import org.opennms.web.filter.NormalizedQueryParameters;
import org.opennms.web.filter.QueryParameters;
import org.opennms.web.tags.filters.FilterCallback;

public class FavoriteTag
extends TagSupport {
    private static Action DEFAULT_DESELECT_ACTION = Action.CLEAR_FILTERS;
    private static final String TEMPLATE = "{0}\n{1}";
    private static final String IMG_TEMPLATE = new String("<img style=\"cursor:pointer;\" title=\"{0}\" with=25 height=25 onClick=\"{1}\" src=\"{2}\"/>{3}");
    private static final String BUTTON_TEMPLATE = new String("<button onClick=\"{0}\" title=\"{1}\" >{2}</button>");
    private static final String JAVASCRIPT_TEMPLATE = "<script type=\"text/javascript\">\n{SELECT_SCRIPT}\n\n{DESELECT_SCRIPT}\n</script>\n";
    private static final String CREATE_FAVORITE_JAVASCRIPT_TEMPLATE = "   function createFavorite() {\n       var favoriteName = prompt(\"Please enter a favorite name\", \"{DEFAULT_FAVORITE}\");\n       if (favoriteName != null) {\n           window.location.href = '{CREATE_FAVORITE_URL}' + favoriteName;\n       }\n}";
    private static final String DELETE_FAVORITE_JAVASCRIPT_TEMPLATE = "   function deleteFavorite(favoriteId) {\n       var reallyDelete = confirm('Do you really want to delete this favorite?');\n       if (reallyDelete) {\n           window.location.href = '{DELETE_FAVORITE_URL}' + favoriteId;\n       }\n   }";
    private static final String DESELECT_FAVORITE_JAVASCRIPT_TEMPLATE = "   function clearFilters() {\n       window.location.href = '{CLEAR_URL}'\n   }";
    private static final String DEFAULT_FAVORITE_NAME = "My Favorite";
    private FilterCallback filterCallback;
    private OnmsFilterFavorite favorite;
    private QueryParameters parameters;
    private String defaultFavoriteName;
    private String createFavoriteController;
    private String deleteFavoriteController;
    private String context;
    private Action deselectAction;

    private static String createLink(FilterCallback callback, String urlBase, QueryParameters params, OnmsFilterFavorite favorite) {
        return callback.createLink(urlBase, params, favorite).replaceAll("&amp;", "&");
    }

    public void setCallback(FilterCallback callback) {
        this.filterCallback = callback;
    }

    public void setParameters(QueryParameters parameters) {
        this.parameters = parameters;
    }

    public void setCreateFavoriteController(String createFavoriteController) {
        if (createFavoriteController.startsWith("/")) {
            createFavoriteController = createFavoriteController.substring(1, createFavoriteController.length());
        }
        this.createFavoriteController = createFavoriteController;
    }

    public void setDeleteFavoriteController(String deleteFavoriteController) {
        if (deleteFavoriteController.startsWith("/")) {
            deleteFavoriteController = deleteFavoriteController.substring(1, deleteFavoriteController.length());
        }
        this.deleteFavoriteController = deleteFavoriteController;
    }

    public void setDefaultFavoriteName(String favoriteName) {
        this.defaultFavoriteName = favoriteName;
    }

    public void setFavorite(OnmsFilterFavorite favorite) {
        this.favorite = favorite;
    }

    public void setContext(String context) {
        if (context != null && context.startsWith("/")) {
            context = context.substring(1, context.length());
        }
        this.context = context;
    }

    public void setOnDeselect(Action action) {
        this.deselectAction = action;
    }

    public OnmsFilterFavorite getFavorite() {
        return this.favorite;
    }

    public int doStartTag() throws JspException {
        String imageString = this.getImageString();
        String scriptString = this.getScriptString();
        String output = MessageFormat.format(TEMPLATE, scriptString, imageString);
        this.out(output);
        return 1;
    }

    private String getImageString() {
        if (this.getFavorite() != null) {
            return MessageFormat.format(BUTTON_TEMPLATE, this.getDeselectAction().getJavascriptCallback(this), this.getDeselectAction().getDescription(), "remove filter");
        }
        return MessageFormat.format(BUTTON_TEMPLATE, this.getSelectAction().getJavascriptCallback(this), this.getSelectAction().getDescription(), "save filter");
    }

    private String getScriptString() {
        Action selectAction = this.getSelectAction();
        Action deselectAction = this.getDeselectAction();
        return JAVASCRIPT_TEMPLATE.replaceAll("\\{SELECT_SCRIPT\\}", selectAction.getJavascript(this)).replaceAll("\\{DESELECT_SCRIPT\\}", deselectAction.getJavascript(this));
    }

    private String getUrlBase() {
        String contextPath = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath();
        if (!contextPath.endsWith("/")) {
            contextPath = contextPath + "/";
        }
        return contextPath;
    }

    private void out(String content) throws JspException {
        try {
            this.pageContext.getOut().write(content);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    private String getCreateFilterController() {
        return this.createFavoriteController;
    }

    private String getDeleteFilterController() {
        return this.deleteFavoriteController;
    }

    private String getDefaultFavoriteName() {
        return this.defaultFavoriteName != null ? this.defaultFavoriteName : DEFAULT_FAVORITE_NAME;
    }

    private String getContext() {
        return this.getUrlBase() + this.context;
    }

    private Action getSelectAction() {
        return Action.CREATE_FAVORITE;
    }

    private Action getDeselectAction() {
        if (this.deselectAction != null) {
            return this.deselectAction;
        }
        return DEFAULT_DESELECT_ACTION;
    }

    public static interface Action {
        public static final Action CLEAR_FILTERS = new Action(){

            @Override
            public String getDescription() {
                return "clear favorite and reset all filter criteria";
            }

            @Override
            public String getJavascriptCallback(FavoriteTag favoriteTag) {
                return "clearFilters()";
            }

            @Override
            public String getJavascript(FavoriteTag favoriteTag) {
                NormalizedQueryParameters parameters = new NormalizedQueryParameters(favoriteTag.parameters);
                parameters.setFilters(new ArrayList<Filter>());
                return FavoriteTag.DESELECT_FAVORITE_JAVASCRIPT_TEMPLATE.replaceAll("\\{CLEAR_URL\\}", FavoriteTag.createLink(favoriteTag.filterCallback, favoriteTag.getContext(), parameters, null));
            }
        };
        public static final Action DELETE_FAVORITE = new Action(){

            @Override
            public String getDescription() {
                return "delete the current selected favorite";
            }

            @Override
            public String getJavascriptCallback(FavoriteTag favoriteTag) {
                return "deleteFavorite(" + favoriteTag.getFavorite().getId() + ")";
            }

            @Override
            public String getJavascript(FavoriteTag favoriteTag) {
                String urlBase = favoriteTag.getUrlBase() + favoriteTag.getDeleteFilterController();
                String deleteFavoriteUrl = FavoriteTag.createLink(favoriteTag.filterCallback, urlBase, favoriteTag.parameters, null);
                return FavoriteTag.DELETE_FAVORITE_JAVASCRIPT_TEMPLATE.replaceAll("\\{DELETE_FAVORITE_URL\\}", MessageFormat.format("{0}&favoriteId=", deleteFavoriteUrl));
            }
        };
        public static final Action CREATE_FAVORITE = new Action(){

            @Override
            public String getDescription() {
                return "create a favorite with current filter settings";
            }

            @Override
            public String getJavascriptCallback(FavoriteTag favoriteTag) {
                return "createFavorite()";
            }

            @Override
            public String getJavascript(FavoriteTag favoriteTag) {
                String urlBase = favoriteTag.getUrlBase() + favoriteTag.getCreateFilterController();
                String createUrl = FavoriteTag.createLink(favoriteTag.filterCallback, urlBase, favoriteTag.parameters, null);
                String createFavoriteURL = MessageFormat.format("{0}&favoriteName=", createUrl);
                return FavoriteTag.CREATE_FAVORITE_JAVASCRIPT_TEMPLATE.replaceAll("\\{DEFAULT_FAVORITE\\}", favoriteTag.getDefaultFavoriteName()).replaceAll("\\{CREATE_FAVORITE_URL\\}", createFavoriteURL);
            }
        };

        public String getDescription();

        public String getJavascriptCallback(FavoriteTag var1);

        public String getJavascript(FavoriteTag var1);
    }
}

