/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.Serializable;
import java.util.Map;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.svclayer.TroubleTicketProxy;
import org.springframework.jdbc.datasource.lookup.DataSourceLookupFailureException;

public class DefaultTroubleTicketProxy
implements TroubleTicketProxy {
    private AlarmDao m_alarmDao;
    private EventProxy m_eventProxy;

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public void setEventProxy(EventProxy eventProxy) {
        this.m_eventProxy = eventProxy;
    }

    @Override
    public void closeTicket(Integer alarmId) {
        this.changeTicket(alarmId, TroubleTicketState.CLOSE_PENDING, "uei.opennms.org/troubleTicket/close", null);
    }

    @Override
    public void createTicket(Integer alarmId, Map<String, String> attributes) {
        this.changeTicket(alarmId, TroubleTicketState.CREATE_PENDING, "uei.opennms.org/troubleTicket/create", attributes);
    }

    @Override
    public void updateTicket(Integer alarmId) {
        this.changeTicket(alarmId, TroubleTicketState.UPDATE_PENDING, "uei.opennms.org/troubleTicket/update", null);
    }

    private void changeTicket(Integer alarmId, TroubleTicketState newState, String uei, Map<String, String> attributes) {
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)alarmId);
        alarm.setTTicketState(newState);
        this.m_alarmDao.saveOrUpdate((Object)alarm);
        EventBuilder bldr = new EventBuilder(uei, "AlarmUI");
        bldr.setNode(alarm.getNode());
        bldr.setInterface(alarm.getIpAddr());
        bldr.setService(alarm.getServiceType() == null ? null : alarm.getServiceType().getName());
        bldr.addParam("alarmUei", alarm.getUei());
        if (attributes == null || !attributes.containsKey("user")) {
            bldr.addParam("user", alarm.getAlarmAckUser());
        }
        bldr.addParam("alarmId", alarm.getId().intValue());
        if (alarm.getTTicketId() != null) {
            bldr.addParam("troubleTicket", alarm.getTTicketId());
        }
        if (attributes != null) {
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                bldr.addParam(attribute.getKey(), attribute.getValue());
            }
        }
        this.send(bldr.getEvent());
    }

    private void send(Event e) {
        try {
            this.m_eventProxy.send(e);
        }
        catch (EventProxyException e1) {
            throw new DataSourceLookupFailureException("Unable to send event to eventd", (Throwable)e1);
        }
    }
}

