/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.web.svclayer.RtcService;
import org.opennms.web.svclayer.support.RtcNodeModel;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultRtcService
implements RtcService,
InitializingBean {
    private MonitoredServiceDao m_monitoredServiceDao;
    private OutageDao m_outageDao;

    @Override
    public RtcNodeModel getNodeList() {
        OnmsCriteria serviceCriteria = this.createServiceCriteria();
        OnmsCriteria outageCriteria = this.createOutageCriteria();
        return this.getNodeListForCriteria(serviceCriteria, outageCriteria);
    }

    @Override
    public RtcNodeModel getNodeListForCriteria(OnmsCriteria serviceCriteria, OnmsCriteria outageCriteria) {
        serviceCriteria.addOrder(Order.asc((String)"node.label"));
        serviceCriteria.addOrder(Order.asc((String)"node.id"));
        serviceCriteria.addOrder(Order.asc((String)"ipInterface.ipAddress"));
        serviceCriteria.addOrder(Order.asc((String)"serviceType.name"));
        Date periodEnd = new Date(System.currentTimeMillis());
        Date periodStart = new Date(periodEnd.getTime() - 86400000L);
        Disjunction disjunction = Restrictions.disjunction();
        disjunction.add(Restrictions.isNull((String)"ifRegainedService"));
        disjunction.add((Criterion)Restrictions.ge((String)"ifLostService", (Object)periodStart));
        disjunction.add((Criterion)Restrictions.ge((String)"ifRegainedService", (Object)periodStart));
        outageCriteria.add((Criterion)disjunction);
        outageCriteria.addOrder(Order.asc((String)"monitoredService"));
        outageCriteria.addOrder(Order.asc((String)"ifLostService"));
        List services = this.m_monitoredServiceDao.findMatching(serviceCriteria);
        List outages = this.m_outageDao.findMatching(outageCriteria);
        Map<OnmsMonitoredService, Long> serviceDownTime = this.calculateServiceDownTime(periodEnd, periodStart, outages);
        RtcNodeModel model = new RtcNodeModel();
        OnmsNode lastNode = null;
        int serviceCount = 0;
        int serviceDownCount = 0;
        long downMillisCount = 0L;
        for (OnmsMonitoredService service : services) {
            Long downMillis;
            if (!service.getIpInterface().getNode().equals(lastNode) && lastNode != null) {
                Double availability = this.calculateAvailability(serviceCount, downMillisCount);
                model.addNode(new RtcNodeModel.RtcNode(lastNode, serviceCount, serviceDownCount, availability));
                serviceCount = 0;
                serviceDownCount = 0;
                downMillisCount = 0L;
            }
            ++serviceCount;
            if (service.isDown()) {
                ++serviceDownCount;
            }
            if ((downMillis = serviceDownTime.get(service)) != null) {
                downMillisCount += downMillis.longValue();
            }
            lastNode = service.getIpInterface().getNode();
        }
        if (lastNode != null) {
            Double availability = this.calculateAvailability(serviceCount, downMillisCount);
            model.addNode(new RtcNodeModel.RtcNode(lastNode, serviceCount, serviceDownCount, availability));
        }
        return model;
    }

    @Override
    public OnmsCriteria createOutageCriteria() {
        OnmsCriteria outageCriteria = new OnmsCriteria(OnmsOutage.class, "outage");
        outageCriteria.createAlias("monitoredService", "monitoredService", 0);
        outageCriteria.add((Criterion)Restrictions.eq((String)"monitoredService.status", (Object)"A"));
        outageCriteria.createAlias("monitoredService.ipInterface", "ipInterface", 0);
        outageCriteria.add((Criterion)Restrictions.ne((String)"ipInterface.isManaged", (Object)"D"));
        outageCriteria.createAlias("monitoredService.ipInterface.node", "node", 0);
        outageCriteria.add((Criterion)Restrictions.ne((String)"node.type", (Object)"D"));
        return outageCriteria;
    }

    @Override
    public OnmsCriteria createServiceCriteria() {
        OnmsCriteria serviceCriteria = new OnmsCriteria(OnmsMonitoredService.class, "monitoredService");
        serviceCriteria.add((Criterion)Restrictions.eq((String)"monitoredService.status", (Object)"A"));
        serviceCriteria.createAlias("ipInterface", "ipInterface", 0);
        serviceCriteria.add((Criterion)Restrictions.ne((String)"ipInterface.isManaged", (Object)"D"));
        serviceCriteria.createAlias("ipInterface.node", "node", 0);
        serviceCriteria.add((Criterion)Restrictions.ne((String)"node.type", (Object)"D"));
        serviceCriteria.createAlias("serviceType", "serviceType", 0);
        serviceCriteria.createAlias("currentOutages", "currentOutages", 0);
        return serviceCriteria;
    }

    private Map<OnmsMonitoredService, Long> calculateServiceDownTime(Date periodEnd, Date periodStart, List<OnmsOutage> outages) {
        HashMap<OnmsMonitoredService, Long> map = new HashMap<OnmsMonitoredService, Long>();
        for (OnmsOutage outage : outages) {
            if (map.get(outage.getMonitoredService()) == null) {
                map.put(outage.getMonitoredService(), 0L);
            }
            Date begin = outage.getIfLostService().before(periodStart) ? periodStart : outage.getIfLostService();
            Date end = outage.getIfRegainedService() == null || !outage.getIfRegainedService().before(periodEnd) ? periodEnd : outage.getIfRegainedService();
            Long count = (Long)map.get(outage.getMonitoredService());
            count = count + (end.getTime() - begin.getTime());
            map.put(outage.getMonitoredService(), count);
        }
        return map;
    }

    private Double calculateAvailability(int serviceCount, long downMillisCount) {
        long upMillis = (long)serviceCount * 86400000L - downMillisCount;
        return (double)upMillis / (double)(serviceCount * 86400000);
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_monitoredServiceDao != null ? 1 : 0) != 0, (String)"property monitoredServiceDao must be set and non-null");
        Assert.state((this.m_outageDao != null ? 1 : 0) != 0, (String)"property outageDao must be set and non-null");
    }

    public MonitoredServiceDao getMonitoredServiceDao() {
        return this.m_monitoredServiceDao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monitoredServiceDao) {
        this.m_monitoredServiceDao = monitoredServiceDao;
    }

    public OutageDao getOutageDao() {
        return this.m_outageDao;
    }

    public void setOutageDao(OutageDao outageDao) {
        this.m_outageDao = outageDao;
    }
}

