/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.web.svclayer.AdminApplicationService;

public class DefaultAdminApplicationService
implements AdminApplicationService {
    private ApplicationDao m_applicationDao;
    private MonitoredServiceDao m_monitoredServiceDao;

    @Override
    public ApplicationAndMemberServices getApplication(String applicationIdString) {
        if (applicationIdString == null) {
            throw new IllegalArgumentException("applicationIdString must not be null");
        }
        OnmsApplication application = this.findApplication(applicationIdString);
        Set memberServices = this.m_monitoredServiceDao.findByApplication(application);
        for (OnmsMonitoredService service : memberServices) {
            this.m_applicationDao.initialize((Object)service.getIpInterface());
            this.m_applicationDao.initialize((Object)service.getIpInterface().getNode());
        }
        return new ApplicationAndMemberServices(application, memberServices);
    }

    @Override
    public List<OnmsMonitoredService> findAllMonitoredServices() {
        ArrayList<OnmsMonitoredService> list = new ArrayList<OnmsMonitoredService>(this.m_monitoredServiceDao.findAll());
        Collections.sort(list);
        return list;
    }

    @Override
    public EditModel findApplicationAndAllMonitoredServices(String applicationIdString) {
        ApplicationAndMemberServices app = this.getApplication(applicationIdString);
        List<OnmsMonitoredService> monitoredServices = this.findAllMonitoredServices();
        return new EditModel(app.getApplication(), monitoredServices, app.getMemberServices());
    }

    public ApplicationDao getApplicationDao() {
        return this.m_applicationDao;
    }

    public void setApplicationDao(ApplicationDao dao) {
        this.m_applicationDao = dao;
    }

    public MonitoredServiceDao getMonitoredServiceDao() {
        return this.m_monitoredServiceDao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monitoredServiceDao) {
        this.m_monitoredServiceDao = monitoredServiceDao;
    }

    @Override
    public void performEdit(String applicationIdString, String editAction, String[] toAdd, String[] toDelete) {
        if (applicationIdString == null) {
            throw new IllegalArgumentException("applicationIdString cannot be null");
        }
        if (editAction == null) {
            throw new IllegalArgumentException("editAction cannot be null");
        }
        OnmsApplication application = this.findApplication(applicationIdString);
        if (editAction.contains("Add")) {
            if (toAdd == null) {
                return;
            }
            for (String idString : toAdd) {
                Integer id;
                try {
                    id = WebSecurityUtils.safeParseInt((String)idString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("toAdd element '" + idString + "' is not an integer");
                }
                OnmsMonitoredService service = (OnmsMonitoredService)this.m_monitoredServiceDao.get((Serializable)id);
                if (service == null) {
                    throw new IllegalArgumentException("monitored service with id of " + id + "could not be found");
                }
                if (service.getApplications().contains(application)) {
                    throw new IllegalArgumentException("monitored service with id of " + id + "is already a member of " + "application " + application.getName());
                }
                service.addApplication(application);
                this.m_monitoredServiceDao.save((Object)service);
            }
        } else if (editAction.contains("Remove")) {
            if (toDelete == null) {
                return;
            }
            for (String idString : toDelete) {
                Integer id;
                try {
                    id = WebSecurityUtils.safeParseInt((String)idString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("toDelete element '" + idString + "' is not an integer");
                }
                OnmsMonitoredService service = (OnmsMonitoredService)this.m_monitoredServiceDao.get((Serializable)id);
                if (service == null) {
                    throw new IllegalArgumentException("monitored service with id of " + id + "could not be found");
                }
                if (!service.getApplications().contains(application)) {
                    throw new IllegalArgumentException("monitored service with id of " + id + "is not a member of " + "application " + application.getName());
                }
                service.removeApplication(application);
                this.m_monitoredServiceDao.save((Object)service);
            }
            this.m_applicationDao.save((Object)application);
        } else {
            throw new IllegalArgumentException("editAction of '" + editAction + "' is not allowed");
        }
    }

    @Override
    public OnmsApplication addNewApplication(String name) {
        OnmsApplication application = new OnmsApplication();
        application.setName(name);
        this.m_applicationDao.save((Object)application);
        return application;
    }

    @Override
    public List<OnmsApplication> findAllApplications() {
        List applications = this.m_applicationDao.findAll();
        ArrayList<OnmsApplication> sortedApplications = new ArrayList<OnmsApplication>(applications);
        Collections.sort(sortedApplications);
        return sortedApplications;
    }

    @Override
    public void removeApplication(String applicationIdString) {
        OnmsApplication application = this.findApplication(applicationIdString);
        this.m_applicationDao.delete((Object)application);
    }

    @Override
    public List<OnmsApplication> findByMonitoredService(int id) {
        OnmsMonitoredService service = (OnmsMonitoredService)this.m_monitoredServiceDao.get((Serializable)Integer.valueOf(id));
        if (service == null) {
            throw new IllegalArgumentException("monitored service with id of " + id + " could not be found");
        }
        ArrayList<OnmsApplication> sortedApplications = new ArrayList<OnmsApplication>(service.getApplications());
        Collections.sort(sortedApplications);
        return sortedApplications;
    }

    @Override
    public void performServiceEdit(String ifServiceIdString, String editAction, String[] toAdd, String[] toDelete) {
        if (ifServiceIdString == null) {
            throw new IllegalArgumentException("ifServiceIdString cannot be null");
        }
        if (editAction == null) {
            throw new IllegalArgumentException("editAction cannot be null");
        }
        OnmsMonitoredService service = this.findService(ifServiceIdString);
        if (editAction.contains("Add")) {
            if (toAdd == null) {
                return;
            }
            for (String idString : toAdd) {
                Integer id;
                try {
                    id = WebSecurityUtils.safeParseInt((String)idString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("toAdd element '" + idString + "' is not an integer");
                }
                OnmsApplication application = (OnmsApplication)this.m_applicationDao.get((Serializable)id);
                if (application == null) {
                    throw new IllegalArgumentException("application with id of " + id + " could not be found");
                }
                if (service.getApplications().contains(application)) {
                    throw new IllegalArgumentException("application with id of " + id + " is already a member of " + "service " + service.getServiceName());
                }
                service.getApplications().add(application);
            }
            this.m_monitoredServiceDao.save((Object)service);
        } else if (editAction.contains("Remove")) {
            if (toDelete == null) {
                return;
            }
            for (String idString : toDelete) {
                Integer id;
                try {
                    id = WebSecurityUtils.safeParseInt((String)idString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("toDelete element '" + idString + "' is not an integer");
                }
                OnmsApplication application = (OnmsApplication)this.m_applicationDao.get((Serializable)id);
                if (application == null) {
                    throw new IllegalArgumentException("application with id of " + id + " could not be found");
                }
                if (!service.getApplications().contains(application)) {
                    throw new IllegalArgumentException("application with id of " + id + " is not a member of " + "service " + service.getServiceName());
                }
                service.getApplications().add(application);
            }
            this.m_monitoredServiceDao.save((Object)service);
        } else {
            throw new IllegalArgumentException("editAction of '" + editAction + "' is not allowed");
        }
    }

    @Override
    public ServiceEditModel findServiceApplications(String ifServiceIdString) {
        if (ifServiceIdString == null) {
            throw new IllegalArgumentException("ifServiceIdString must not be null");
        }
        OnmsMonitoredService service = this.findService(ifServiceIdString);
        List<OnmsApplication> applications = this.findAllApplications();
        this.m_monitoredServiceDao.initialize((Object)service.getIpInterface());
        this.m_monitoredServiceDao.initialize((Object)service.getIpInterface().getNode());
        return new ServiceEditModel(service, applications);
    }

    public OnmsApplication findApplication(String name) {
        int applicationId = -1;
        try {
            applicationId = WebSecurityUtils.safeParseInt((String)name);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("parameter 'applicationid' with value '" + name + "' could not be parsed " + "as an integer");
        }
        OnmsApplication application = (OnmsApplication)this.m_applicationDao.get((Serializable)Integer.valueOf(applicationId));
        if (application == null) {
            throw new IllegalArgumentException("Could not find application with application ID " + applicationId);
        }
        return application;
    }

    private OnmsMonitoredService findService(String ifServiceIdString) {
        int ifServiceId;
        try {
            ifServiceId = WebSecurityUtils.safeParseInt((String)ifServiceIdString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("parameter ifserviceid '" + ifServiceIdString + "' is not an integer");
        }
        OnmsMonitoredService service = (OnmsMonitoredService)this.m_monitoredServiceDao.get((Serializable)Integer.valueOf(ifServiceId));
        if (service == null) {
            throw new IllegalArgumentException("monitored service with id of " + ifServiceId + " could not be found");
        }
        return service;
    }

    public class ServiceEditModel {
        private OnmsMonitoredService m_service;
        private List<OnmsApplication> m_applications;
        private List<OnmsApplication> m_sortedApplications;

        public ServiceEditModel(OnmsMonitoredService service, List<OnmsApplication> applications) {
            this.m_service = service;
            this.m_applications = applications;
            for (OnmsApplication application : service.getApplications()) {
                this.m_applications.remove(application);
            }
            this.m_sortedApplications = new ArrayList<OnmsApplication>(this.m_service.getApplications());
            Collections.sort(this.m_sortedApplications);
        }

        public OnmsMonitoredService getService() {
            return this.m_service;
        }

        public List<OnmsApplication> getApplications() {
            return this.m_applications;
        }

        public List<OnmsApplication> getSortedApplications() {
            return this.m_sortedApplications;
        }
    }

    public class EditModel {
        private OnmsApplication m_application;
        private List<OnmsMonitoredService> m_monitoredServices;
        private List<OnmsMonitoredService> m_sortedMemberServices;

        public EditModel(OnmsApplication application, List<OnmsMonitoredService> monitoredServices, Collection<OnmsMonitoredService> memberServices) {
            this.m_application = application;
            this.m_monitoredServices = monitoredServices;
            this.m_monitoredServices.removeAll(memberServices);
            this.m_sortedMemberServices = new ArrayList<OnmsMonitoredService>(memberServices);
            Collections.sort(this.m_sortedMemberServices);
        }

        public OnmsApplication getApplication() {
            return this.m_application;
        }

        public List<OnmsMonitoredService> getMonitoredServices() {
            return this.m_monitoredServices;
        }

        public List<OnmsMonitoredService> getSortedMemberServices() {
            return this.m_sortedMemberServices;
        }
    }

    public class ApplicationAndMemberServices {
        private OnmsApplication m_application;
        private Collection<OnmsMonitoredService> m_memberServices;

        public ApplicationAndMemberServices(OnmsApplication application, Collection<OnmsMonitoredService> memberServices) {
            this.m_application = application;
            this.m_memberServices = memberServices;
        }

        public OnmsApplication getApplication() {
            return this.m_application;
        }

        public Collection<OnmsMonitoredService> getMemberServices() {
            return this.m_memberServices;
        }
    }
}

