/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.daemonstatus.support;

import java.util.Collection;
import java.util.Map;
import org.opennms.netmgt.dao.api.DaemonStatusDao;
import org.opennms.netmgt.model.ServiceDaemon;
import org.opennms.netmgt.model.ServiceInfo;
import org.opennms.web.svclayer.daemonstatus.DaemonStatusService;

public class DefaultDaemonStatusService
implements DaemonStatusService {
    private DaemonStatusDao daemonStatusDao;

    public void setDaemonStatusDao(DaemonStatusDao daemonStatusDao) {
        this.daemonStatusDao = daemonStatusDao;
    }

    @Override
    public Map<String, ServiceInfo> getCurrentDaemonStatus() {
        Map info = this.daemonStatusDao.getCurrentDaemonStatus();
        return info;
    }

    @Override
    public Collection<ServiceInfo> getCurrentDaemonStatusColl() {
        return this.daemonStatusDao.getCurrentDaemonStatus().values();
    }

    @Override
    public Map<String, ServiceInfo> performOperationOnDaemons(String operation, String[] daemons) {
        for (int i = 0; i < daemons.length; ++i) {
            if (operation.equalsIgnoreCase("start")) {
                this.startDaemon(daemons[i]);
                continue;
            }
            if (operation.equalsIgnoreCase("stop")) {
                this.stopDaemon(daemons[i]);
                continue;
            }
            if (operation.equalsIgnoreCase("restart")) {
                this.restartDaemon(daemons[i]);
                continue;
            }
            if (!operation.equalsIgnoreCase("refresh")) continue;
        }
        return this.getCurrentDaemonStatus();
    }

    @Override
    public Map<String, ServiceInfo> restartDaemon(String service) {
        ServiceDaemon serviceDaemon = this.daemonStatusDao.getServiceHandle(service);
        serviceDaemon.stop();
        serviceDaemon.start();
        return this.getCurrentDaemonStatus();
    }

    @Override
    public Map<String, ServiceInfo> startDaemon(String service) {
        ServiceDaemon serviceDaemon = this.daemonStatusDao.getServiceHandle(service);
        serviceDaemon.start();
        return this.getCurrentDaemonStatus();
    }

    @Override
    public Map<String, ServiceInfo> stopDaemon(String service) {
        return this.getCurrentDaemonStatus();
    }
}

