/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.SurveillanceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateStatus
implements SurveillanceStatus {
    private static final Logger LOG = LoggerFactory.getLogger(AggregateStatus.class);
    private String m_label;
    private Integer m_totalEntityCount;
    private final List<OnmsNode> m_downNodes = new ArrayList<OnmsNode>();
    private String m_status;
    private String m_link;
    public static final String NODES_ARE_DOWN = "Critical";
    public static final String ONE_SERVICE_DOWN = "Warning";
    public static final String ALL_NODES_UP = "Normal";

    public AggregateStatus(Collection<OnmsNode> nodes) {
        this.computeStatusValues(nodes);
    }

    public String getStatus() {
        return this.m_status;
    }

    private void setStatus(String color) {
        this.m_status = color;
    }

    public Integer getDownEntityCount() {
        return this.m_downNodes.size();
    }

    public List<OnmsNode> getDownNodes() {
        return Collections.unmodifiableList(this.m_downNodes);
    }

    private void setDownNodes(Collection<OnmsNode> downNodes) {
        if (this.m_downNodes == downNodes) {
            return;
        }
        this.m_downNodes.clear();
        this.m_downNodes.addAll(downNodes);
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public Integer getTotalEntityCount() {
        return this.m_totalEntityCount;
    }

    private void setTotalEntityCount(Integer totalEntityCount) {
        this.m_totalEntityCount = totalEntityCount;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.m_label == null ? "null" : this.m_label);
        sb.append(": ");
        sb.append(this.m_downNodes == null ? -1 : this.m_downNodes.size());
        sb.append(" down of ");
        sb.append(this.m_totalEntityCount == null ? -1 : this.m_totalEntityCount);
        sb.append(" total.");
        return sb.toString();
    }

    private void visitNodes(Collection<OnmsNode> nodes, AggregateStatusVisitor statusVisitor) {
        if (nodes == null) {
            return;
        }
        for (OnmsNode node : nodes) {
            node.visit((EntityVisitor)statusVisitor);
        }
    }

    private AggregateStatus computeStatusValues(Collection<OnmsNode> nodes) {
        AggregateStatusVisitor statusVisitor = new AggregateStatusVisitor();
        this.visitNodes(nodes, statusVisitor);
        this.setDownNodes(statusVisitor.getDownNodes());
        this.setTotalEntityCount(nodes.size());
        this.setStatus(statusVisitor.getStatus());
        return this;
    }

    public String getLink() {
        return this.m_link;
    }

    public void setLink(String link) {
        this.m_link = link;
    }

    final class AggregateStatusVisitor
    extends AbstractEntityVisitor {
        Set<OnmsNode> m_downNodes = new LinkedHashSet<OnmsNode>();
        String m_status = "Normal";
        boolean m_isCurrentNodeDown = true;

        AggregateStatusVisitor() {
        }

        public void visitNode(OnmsNode node) {
            LOG.debug("visitNode({})", (Object)node);
            this.m_isCurrentNodeDown = true;
        }

        public void visitNodeComplete(OnmsNode node) {
            LOG.debug("visitNodeComplete({}) -- m_isCurrentNodeDown = {}", (Object)node, (Object)this.m_isCurrentNodeDown);
            if (this.m_isCurrentNodeDown) {
                this.m_downNodes.add(node);
                this.m_status = AggregateStatus.NODES_ARE_DOWN;
            }
        }

        public void visitMonitoredService(OnmsMonitoredService svc) {
            LOG.debug("visitMonitoredService({}) - currentOutages.isEmpty = {}", (Object)svc, (Object)svc.getCurrentOutages().isEmpty());
            if ("A".equals(svc.getStatus()) && !svc.getCurrentOutages().isEmpty()) {
                if (AggregateStatus.ALL_NODES_UP.equals(this.m_status)) {
                    this.m_status = AggregateStatus.ONE_SERVICE_DOWN;
                }
            } else if ("A".equals(svc.getStatus())) {
                this.m_isCurrentNodeDown = false;
            }
        }

        public String getStatus() {
            return this.m_status;
        }

        public Set<OnmsNode> getDownNodes() {
            return this.m_downNodes;
        }
    }
}

